/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.tenant.service.impl;

import com.horizon.core.common.entity.ViewData;
import com.horizon.license.ExtrasFactory;
import com.horizon.license.LicenseInfo;
import com.horizon.utils.StringUtil;
import com.horizon.workflow.tenant.entity.TenantAuth;
import com.horizon.workflow.tenant.repository.Impl.TenantGrantRepositoryImpl;
import com.horizon.workflow.tenant.repository.TenantGrantRepository;
import com.horizon.workflow.tenant.service.ITenantGrantService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class TenantGrantServiceImpl
implements ITenantGrantService {
    private final TenantGrantRepository tenantGrantRepository = new TenantGrantRepositoryImpl();

    @Override
    public void insert(TenantAuth tenantAuth) {
        this.tenantGrantRepository.insert(tenantAuth);
    }

    @Override
    public void update(TenantAuth tenantAuth) {
        this.tenantGrantRepository.insert(tenantAuth);
    }

    @Override
    public void save(TenantAuth tenantAuth) {
        if (tenantAuth.isNewRecord()) {
            tenantAuth.preInsert();
            this.tenantGrantRepository.insert(tenantAuth);
        } else {
            tenantAuth.preUpdate();
            this.tenantGrantRepository.update(tenantAuth);
        }
    }

    @Override
    public void resetTenantGrant(List<String> idsArr) {
        this.tenantGrantRepository.delTenantGrant(idsArr);
    }

    @Override
    public boolean checkTenantGrant(TenantAuth tenantAuth) {
        String tenantAuthExpiration;
        String tenantCode = tenantAuth.getTenantCode();
        Map<String, Integer> hasGrantRes = this.getHasGrantRes(tenantCode);
        LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
        String users = licenseInfo.getUsers();
        String units = licenseInfo.getUnits();
        String flow = licenseInfo.getFlow();
        String work = licenseInfo.getWork();
        String formsums = licenseInfo.getFormsums();
        String licenseExpiration = licenseInfo.getExpiration();
        if (!"unlimited".equals(users) && StringUtil.hasValue((String)tenantAuth.getTenantUser()) && Integer.parseInt(users) - hasGrantRes.get("user") < Integer.parseInt(tenantAuth.getTenantUser())) {
            return false;
        }
        if (!"unlimited".equals(units) && StringUtil.hasValue((String)tenantAuth.getUnit()) && Integer.parseInt(units) - hasGrantRes.get("unit") < Integer.parseInt(tenantAuth.getUnit())) {
            return false;
        }
        if (!"unlimited".equals(flow) && StringUtil.hasValue((String)tenantAuth.getFlow()) && Integer.parseInt(flow) - hasGrantRes.get("flow") < Integer.parseInt(tenantAuth.getFlow())) {
            return false;
        }
        if (!"unlimited".equals(work) && StringUtil.hasValue((String)tenantAuth.getWork()) && Integer.parseInt(work) - hasGrantRes.get("work") < Integer.parseInt(tenantAuth.getWork())) {
            return false;
        }
        if (!"unlimited".equals(formsums) && StringUtil.hasValue((String)tenantAuth.getForm()) && Integer.parseInt(formsums) - hasGrantRes.get("form") < Integer.parseInt(tenantAuth.getForm())) {
            return false;
        }
        return "unlimited".equals(licenseExpiration) || !StringUtil.hasValue((String)(tenantAuthExpiration = tenantAuth.getExpiration())) || licenseExpiration.compareTo(tenantAuthExpiration) >= 0;
    }

    @Override
    public boolean checkTenantExpiration(TenantAuth tenantAuth) {
        String tenantCode = tenantAuth.getTenantCode();
        String expiration = tenantAuth.getExpiration();
        if (StringUtil.hasValue((String)expiration)) {
            String tenantAuthE;
            TenantAuth tenant = this.tenantGrantRepository.getTenantAuthByTenantCode(tenantCode);
            if (tenant != null && StringUtil.hasValue((String)(tenantAuthE = tenant.getExpiration()))) {
                return expiration.compareTo(tenant.getExpiration()) <= 0;
            }
            LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
            String licenseExpiration = licenseInfo.getExpiration();
            if (!"unlimited".equals(licenseExpiration)) {
                return expiration.compareTo(licenseExpiration) <= 0;
            }
        }
        return true;
    }

    @Override
    public boolean checkTenantFlow(String tenantCode, int flowCount) {
        LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
        String flow = licenseInfo.getFlow();
        Map<String, Integer> hasGrantRes = this.getTenantAuthByTenantCode(tenantCode);
        if (hasGrantRes != null) {
            return hasGrantRes.get("flow") > flowCount;
        }
        if (!"unlimited".equals(flow)) {
            Map<String, Integer> otherHasGrantRes = this.getHasGrantRes(tenantCode);
            return Integer.parseInt(flow) - otherHasGrantRes.get("flow") > flowCount;
        }
        return true;
    }

    @Override
    public boolean checkTenantWork(String tenantCode, int workCount) {
        LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
        String work = licenseInfo.getWork();
        Map<String, Integer> hasGrantRes = this.getTenantAuthByTenantCode(tenantCode);
        if (hasGrantRes != null) {
            return hasGrantRes.get("work") > workCount;
        }
        if (!"unlimited".equals(work)) {
            Map<String, Integer> otherHasGrantRes = this.getHasGrantRes(tenantCode);
            return Integer.parseInt(work) - otherHasGrantRes.get("work") > workCount;
        }
        return true;
    }

    @Override
    public boolean checkTenantForm(String tenantCode, int formCount) {
        LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
        String form = licenseInfo.getFormsums();
        Map<String, Integer> hasGrantRes = this.getTenantAuthByTenantCode(tenantCode);
        if (hasGrantRes != null) {
            return hasGrantRes.get("form") > formCount;
        }
        if (!"unlimited".equals(form)) {
            Map<String, Integer> otherHasGrantRes = this.getHasGrantRes(tenantCode);
            return Integer.parseInt(form) - otherHasGrantRes.get("form") > formCount;
        }
        return true;
    }

    @Override
    public int getTenantFormCount(String tenantCode) {
        LicenseInfo licenseInfo = ExtrasFactory.newInstance().getInfo();
        String form = licenseInfo.getFormsums();
        Map<String, Integer> hasGrantRes = this.getTenantAuthByTenantCode(tenantCode);
        if (hasGrantRes != null) {
            return hasGrantRes.get("form");
        }
        if (!"unlimited".equals(form)) {
            Map<String, Integer> otherHasGrantRes = this.getHasGrantRes(tenantCode);
            return Integer.parseInt(form) - otherHasGrantRes.get("form");
        }
        return -1;
    }

    @Override
    public boolean checkTenantUnique(TenantAuth tenantAuth) {
        return this.tenantGrantRepository.checkTenantUnique(tenantAuth) <= 0;
    }

    @Override
    public Map<String, Integer> getTenantAuthByTenantCode(String tenantCode) {
        HashMap<String, Integer> hasGrantRes = null;
        TenantAuth tenantAuth = this.tenantGrantRepository.getTenantAuthByTenantCode(tenantCode);
        if (tenantAuth != null) {
            int user = Integer.parseInt(tenantAuth.getTenantUser());
            int unit = Integer.parseInt(tenantAuth.getUnit());
            int flow = Integer.parseInt(tenantAuth.getFlow());
            int work = Integer.parseInt(tenantAuth.getWork());
            int form = Integer.parseInt(tenantAuth.getForm());
            hasGrantRes = new HashMap<String, Integer>();
            hasGrantRes.put("user", user);
            hasGrantRes.put("unit", unit);
            hasGrantRes.put("flow", flow);
            hasGrantRes.put("work", work);
            hasGrantRes.put("form", form);
        }
        return hasGrantRes;
    }

    private Map<String, Integer> getHasGrantRes(String tenantCode) {
        List<TenantAuth> tenantAuthList = this.tenantGrantRepository.findGrantList();
        HashMap<String, Integer> hasGrantRes = new HashMap<String, Integer>();
        int user = 0;
        int unit = 0;
        int flow = 0;
        int work = 0;
        int form = 0;
        if (tenantAuthList != null && !tenantAuthList.isEmpty()) {
            for (TenantAuth tenantAuth : tenantAuthList) {
                String eachTenantCode = tenantAuth.getTenantCode();
                if (tenantCode.equals(eachTenantCode)) continue;
                user += Integer.parseInt(tenantAuth.getTenantUser());
                unit += Integer.parseInt(tenantAuth.getUnit());
                flow += Integer.parseInt(tenantAuth.getFlow());
                work += Integer.parseInt(tenantAuth.getWork());
                form += Integer.parseInt(tenantAuth.getForm());
            }
        }
        hasGrantRes.put("user", user);
        hasGrantRes.put("unit", unit);
        hasGrantRes.put("flow", flow);
        hasGrantRes.put("work", work);
        hasGrantRes.put("form", form);
        return hasGrantRes;
    }

    @Override
    public ViewData<TenantAuth> findPage(TenantAuth tenantAuth, int pageNo, int pageSize) {
        return this.tenantGrantRepository.findPage(tenantAuth, pageNo, pageSize);
    }
}

