/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.workflow.tenant.repository.Impl;

import com.horizon.core.common.entity.ViewData;
import com.horizon.db.Access;
import com.horizon.utils.StringUtil;
import com.horizon.workflow.tenant.entity.TenantAuth;
import com.horizon.workflow.tenant.repository.TenantGrantRepository;
import java.util.ArrayList;
import java.util.List;

public class TenantGrantRepositoryImpl
implements TenantGrantRepository {
    @Override
    public void insert(TenantAuth tenantAuth) {
        String sql = "INSERT INTO TW_HZ_TENANT_AUTH (ID, TENANTCODE, TENANTUSER, UNIT, FLOW, WORK, FORM, EXPIRATION, CREATED, OPERATOR) VALUES (?,?,?,?,?,?,?,?,?,?)";
        ArrayList<String> lstConditions = new ArrayList<String>();
        lstConditions.add(tenantAuth.getId());
        lstConditions.add(tenantAuth.getTenantCode());
        lstConditions.add(tenantAuth.getTenantUser());
        lstConditions.add(tenantAuth.getUnit());
        lstConditions.add(tenantAuth.getFlow());
        lstConditions.add(tenantAuth.getWork());
        lstConditions.add(tenantAuth.getForm());
        lstConditions.add(tenantAuth.getExpiration());
        lstConditions.add(tenantAuth.getCreated());
        lstConditions.add(tenantAuth.getOperator());
        Access.executeUpdate((String)sql, lstConditions);
    }

    @Override
    public void update(TenantAuth tenantAuth) {
        String sql = "UPDATE TW_HZ_TENANT_AUTH SET TENANTCODE =?, TENANTUSER =?, UNIT = ?, FLOW = ?, WORK = ?, FORM = ?, EXPIRATION = ?, CREATED = ?, OPERATOR = ? WHERE ID = ?";
        ArrayList<String> lstConditions = new ArrayList<String>();
        lstConditions.add(tenantAuth.getTenantCode());
        lstConditions.add(tenantAuth.getTenantUser());
        lstConditions.add(tenantAuth.getUnit());
        lstConditions.add(tenantAuth.getFlow());
        lstConditions.add(tenantAuth.getWork());
        lstConditions.add(tenantAuth.getForm());
        lstConditions.add(tenantAuth.getExpiration());
        lstConditions.add(tenantAuth.getCreated());
        lstConditions.add(tenantAuth.getOperator());
        lstConditions.add(tenantAuth.getId());
        Access.executeUpdate((String)sql, lstConditions);
    }

    @Override
    public List<TenantAuth> findGrantList() {
        String sql = "SELECT TA.ID, TA.TENANTCODE AS TENANT_CODE, TA.TENANTUSER AS TENANT_USER, TA.UNIT, TA.FLOW, TA.WORK, TA.FORM, TA.EXPIRATION FROM TW_HZ_TENANT T, TW_HZ_TENANT_AUTH TA WHERE T.TENANTCODE = TA.TENANTCODE ";
        return Access.getMultiObject((String)sql, null, TenantAuth.class);
    }

    @Override
    public ViewData<TenantAuth> findPage(TenantAuth tenantAuth, int pageNo, int pageSize) {
        StringBuilder sql = new StringBuilder("SELECT TA.ID, T.TENANTCODE AS TENANT_CODE, T.TENANTNAME AS TENANT_NAME, TA.TENANTUSER AS TENANT_USER, TA.UNIT, TA.FLOW, TA.WORK, TA.FORM, TA.EXPIRATION FROM TW_HZ_TENANT T LEFT JOIN TW_HZ_TENANT_AUTH TA ON T.TENANTCODE = TA.TENANTCODE WHERE 1 = 1 ");
        String tenantName = tenantAuth.getTenantName();
        String tenantCode = tenantAuth.getTenantCode();
        String search = tenantAuth.getSearch();
        ArrayList<String> lstConditions = new ArrayList<String>();
        if (StringUtil.hasValue((String)tenantName)) {
            sql.append("AND TA.TENANTNAME LIKE ?");
            lstConditions.add(tenantName);
        }
        if (StringUtil.hasValue((String)tenantCode)) {
            sql.append("AND TA.TENANTCODE LIKE ?");
            lstConditions.add(tenantCode);
        }
        if (StringUtil.hasValue((String)search)) {
            sql.append("(TA.TENANTNAME LIKE ? OR TA.TENANTCODE LIKE ?)");
            lstConditions.add(search);
            lstConditions.add(search);
        }
        pageNo = pageNo <= 1 ? 1 : pageNo;
        List datas = Access.getPagingObject((String)sql.toString(), lstConditions, (int)pageNo, (int)pageSize, TenantAuth.class);
        int count = Access.getRsCount((String)sql.toString(), lstConditions);
        ViewData viewData = new ViewData();
        viewData.setDatas(datas);
        viewData.setRecordsTotal(String.valueOf(count));
        viewData.setRecordsFiltered(String.valueOf(count));
        return viewData;
    }

    @Override
    public void delTenantGrant(List<String> ids) {
        StringBuilder sql = new StringBuilder("DELETE FROM TW_HZ_TENANT_AUTH WHERE ID IN (");
        for (String id : ids) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.lastIndexOf(",")).append(")");
        Access.executeUpdate((String)sql.toString(), ids);
    }

    @Override
    public void delTenantGrantByTenantCode(List<String> tenantCodes) {
        StringBuilder sql = new StringBuilder("DELETE FROM TW_HZ_TENANT_AUTH WHERE TENANTCODE IN (");
        for (String tenantCode : tenantCodes) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.lastIndexOf(",")).append(")");
        Access.executeUpdate((String)sql.toString(), tenantCodes);
    }

    @Override
    public TenantAuth getTenantAuthByTenantCode(String tenantCode) {
        String sql = "SELECT TA.ID, TA.TENANTCODE AS TENANT_CODE, TA.TENANTUSER AS TENANT_USER, TA.UNIT, TA.FLOW, TA.WORK, TA.FORM, TA.EXPIRATION FROM TW_HZ_TENANT T, TW_HZ_TENANT_AUTH TA WHERE T.TENANTCODE = TA.TENANTCODE AND TA.TENANTCODE = ?";
        ArrayList<String> lstConditions = new ArrayList<String>();
        lstConditions.add(tenantCode);
        return (TenantAuth)((Object)Access.getSingleObject((String)sql, lstConditions, TenantAuth.class));
    }

    @Override
    public int checkTenantUnique(TenantAuth tenantAuth) {
        String sql = "SELECT COUNT(1) FROM TW_HZ_TENANT_AUTH TA WHERE TA.TENANTCODE = ?";
        ArrayList<String> lstConditions = new ArrayList<String>();
        lstConditions.add(tenantAuth.getTenantCode());
        String id = tenantAuth.getId();
        if (StringUtil.hasValue((String)id)) {
            sql = sql + " AND TA.ID !=  ? ";
            lstConditions.add(tenantAuth.getId());
        }
        return Access.getRsCount((String)sql, lstConditions);
    }
}

