/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.language.web;

import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Maps;
import com.horizon.core.common.controller.SuperController;
import com.horizon.language.Hi18n;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${url.prefix}/profile/"})
public class HorizonLanguageController
extends SuperController {
    @ResponseBody
    @RequestMapping(value={"lang${url.suffix}"})
    public String languages(String groups) {
        HashMap langs = Maps.newHashMap();
        if (StringUtil.hasValue((String)groups)) {
            List list = Splitter.on((String)";").omitEmptyStrings().trimResults().splitToList((CharSequence)groups);
            for (String group : list) {
                Map map = Hi18n.getLanguage((String)group);
                langs.put(group, map);
            }
        }
        return JsonUtil.toJson((Object)langs);
    }

    @ResponseBody
    @RequestMapping(value={"lang/local${url.suffix}"})
    public String getLocalLang() {
        HashMap localLang = Maps.newHashMap();
        localLang.put("localeVal", Hi18n.getDefLocaleKey());
        return JsonUtil.toJson((Object)localLang);
    }
}

