/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.horizon.utils.json.filters.LowerUpperKeyFilter;
import com.horizon.utils.json.filters.Null2EmptyValueFilter;
import com.horizon.utils.json.filters.PropertiesFilter;
import java.util.List;

public class JsonUtil {
    public static String toJson(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String toJsonSerializerNull(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializeFilter)new Null2EmptyValueFilter(), (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJsonKeyLowerUpperSerializerNull(Object obj, boolean isLower) {
        return JSON.toJSONString((Object)obj, (SerializeFilter[])new SerializeFilter[]{new Null2EmptyValueFilter(), new LowerUpperKeyFilter(isLower)}, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJson(Object obj, SerializeFilter ... filters) {
        return JSON.toJSONString((Object)obj, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static String toJsonSkipFileds(Object obj, String ... fileds) {
        return JSON.toJSONString((Object)obj, (SerializeFilter[])new SerializeFilter[]{new PropertiesFilter(fileds), new Null2EmptyValueFilter()}, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object fromJson(String json) {
        return JSON.parse((String)json);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }
}

