/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import com.horizon.common.base.Function;
import com.horizon.common.base.Joiner;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Collections2;
import com.horizon.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class StringUtil2 {
    private StringUtil2() {
    }

    public static List<String> splitToList(String source, String charSequence) {
        return StringUtil.hasValue(source) ? Splitter.on((String)charSequence).trimResults().splitToList((CharSequence)source) : Collections.emptyList();
    }

    public static List<String> splitAddPreFix(String source, String charSequence, final String preFix) {
        List sources = StringUtil.hasValue(source) ? Splitter.on((String)charSequence).trimResults().splitToList((CharSequence)source) : Collections.emptyList();
        Collection transform = Collections2.transform((Collection)sources, (Function)new Function<String, String>(){

            public String apply(String source) {
                return StringUtil2.addPreFix(source, preFix);
            }
        });
        return new ArrayList<String>(transform);
    }

    public static List<String> splitTrimPreFix(String source, String charSequence, final String preFix) {
        List sources = StringUtil.hasValue(source) ? Splitter.on((String)charSequence).trimResults().splitToList((CharSequence)source) : Collections.emptyList();
        Collection transform = Collections2.transform((Collection)sources, (Function)new Function<String, String>(){

            public String apply(String source) {
                return StringUtil2.trimPreFix(source, preFix);
            }
        });
        return new ArrayList<String>(transform);
    }

    public static String addPreFix(String source, String preFix) {
        return StringUtil.hasValue(source) && !source.startsWith(preFix) ? preFix + source : source;
    }

    public static List<String> addPreFix(Collection<String> sources, final String preFix) {
        if (sources != null && !sources.isEmpty()) {
            Collection transform = Collections2.transform(sources, (Function)new Function<String, String>(){

                public String apply(String objectId) {
                    return StringUtil2.addPreFix(objectId, preFix);
                }
            });
            return new ArrayList<String>(transform);
        }
        return Collections.emptyList();
    }

    public static String addPreFixAndJoin(Collection<String> sources, String charSequence, final String preFix) {
        Collection transform = Collections2.transform(sources, (Function)new Function<String, String>(){

            public String apply(String source) {
                return StringUtil2.addPreFix(source, preFix);
            }
        });
        return Joiner.on((String)charSequence).skipNulls().join((Iterable)transform);
    }

    public static String trimPreFix(String source, String preFix) {
        return StringUtil.hasValue(source) && source.startsWith(preFix) ? source.substring(preFix.length()) : source;
    }

    public static List<String> trimPreFix(Collection<String> sources, final String preFix) {
        Collection transform = Collections2.transform(sources, (Function)new Function<String, String>(){

            public String apply(String source) {
                return StringUtil2.trimPreFix(source, preFix);
            }
        });
        return new ArrayList<String>(transform);
    }

    public static String trimPreFixAndJoin(Collection<String> sources, String charSequence, final String preFix) {
        Collection transform = Collections2.transform(sources, (Function)new Function<String, String>(){

            public String apply(String source) {
                return StringUtil2.trimPreFix(source, preFix);
            }
        });
        return Joiner.on((String)charSequence).skipNulls().join((Iterable)transform);
    }
}

