/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class StringUtil
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY = "";
    private static final String EMPTY_FOR_HTML = "&nbsp;";
    private static final String TIP_BRACKET_LEFT = "<";
    private static final String TIP_BRACKET_RIGHT = ">";
    private static final String TIP_BRACKET_LEFT_HTML = "&lt;";
    private static final String TIP_BRACKET_RIGHT_HTML = "&gt;";
    private static final int ZERO = 0;

    private StringUtil() {
    }

    public static String null2Empty(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str;
    }

    public static String null2HtmlEmpty(String str) {
        if (str == null) {
            return EMPTY_FOR_HTML;
        }
        return str;
    }

    public static String convertString2Html(String str) {
        if (str == null) {
            return EMPTY_FOR_HTML;
        }
        if (str.length() == 0) {
            // empty if block
        }
        str = str.replaceAll(TIP_BRACKET_LEFT, TIP_BRACKET_LEFT_HTML);
        str = str.replaceAll(TIP_BRACKET_RIGHT, TIP_BRACKET_RIGHT_HTML);
        return str;
    }

    public static String convertHtml2String(String str) {
        if (str == null) {
            return EMPTY;
        }
        str = str.replaceAll(TIP_BRACKET_LEFT_HTML, TIP_BRACKET_LEFT);
        str = str.replaceAll(TIP_BRACKET_RIGHT_HTML, TIP_BRACKET_RIGHT);
        return str;
    }

    public static String encode(String message) {
        if (message == null) {
            return null;
        }
        if (message.trim().length() == 0) {
            return message;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuffer result = new StringBuffer(content.length + 50);
        block11: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append(TIP_BRACKET_LEFT_HTML);
                    continue block11;
                }
                case '>': {
                    result.append(TIP_BRACKET_RIGHT_HTML);
                    continue block11;
                }
                case '&': {
                    result.append("&amp;");
                    continue block11;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block11;
                }
                case '%': {
                    result.append("&#37;");
                    continue block11;
                }
                case '\'': {
                    result.append("&#39;");
                    continue block11;
                }
                case ' ': {
                    result.append(EMPTY_FOR_HTML);
                    continue block11;
                }
                case '\u2022': {
                    result.append("&#8226;");
                    continue block11;
                }
                case '\u2014': {
                    result.append("&mdash;");
                    continue block11;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    public static String decode(String message) {
        if (message == null) {
            return null;
        }
        if (message.trim().length() == 0) {
            return message;
        }
        String decodestr = message.replaceAll(TIP_BRACKET_LEFT_HTML, TIP_BRACKET_LEFT);
        decodestr = decodestr.replaceAll(TIP_BRACKET_RIGHT_HTML, TIP_BRACKET_RIGHT);
        decodestr = decodestr.replaceAll("&amp;", "&");
        decodestr = decodestr.replaceAll("&quot;", "\"");
        decodestr = decodestr.replaceAll("&#37;", "%");
        decodestr = decodestr.replaceAll("&#39;", "'");
        decodestr = decodestr.replaceAll("&#40;", "(");
        decodestr = decodestr.replaceAll("&#41;", ")");
        decodestr = decodestr.replaceAll("&#43;", "+");
        decodestr = decodestr.replaceAll("&#59;", ";");
        decodestr = decodestr.replaceAll("&#92;", "\\");
        decodestr = decodestr.replaceAll(EMPTY_FOR_HTML, " ");
        decodestr = decodestr.replaceAll("&mdash;", "\u2014");
        return decodestr;
    }

    public static boolean hasValue(String value) {
        return value != null && value.trim().length() > 0;
    }

    public static boolean isEmpty(String str) {
        return !StringUtil.hasValue(str);
    }

    public static boolean isNotEmpty(String str) {
        return StringUtil.hasValue(str);
    }

    public static String encodeFileName(String userAgent, String fileName) {
        String eFileName = EMPTY;
        try {
            String newFileName = URLEncoder.encode(fileName, "utf-8");
            if (StringUtil.hasValue(userAgent)) {
                if ((userAgent = userAgent.toLowerCase()).contains("opera")) {
                    eFileName = "filename*=UTF-8''" + newFileName;
                } else if (userAgent.contains("safari")) {
                    String str = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
                    eFileName = "filename=\"" + str + "\"";
                } else {
                    eFileName = userAgent.contains("mozilla") ? "filename*=UTF-8''" + newFileName : "filename=\"" + newFileName + "\"";
                }
            } else {
                eFileName = "filename=\"" + newFileName + "\"";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return eFileName;
    }
}

