/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import com.horizon.common.base.Preconditions;
import com.horizon.common.collect.Maps;
import com.horizon.utils.SessionValueItem;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionUtil.class);

    private SessionUtil() {
    }

    public static Object getAttribute(String attrKey) {
        return SessionUtil.getAttribute(null, attrKey);
    }

    public static Object getAttribute(HttpSession session, String attrKey) {
        Preconditions.checkNotNull((Object)attrKey, (Object)"\u8bf7\u6c42\u7684\u53c2\u6570 attrKey \u4e3a null ");
        String sessionId = "HORIZON_" + SessionUtil.getSession().getId();
        Object mapObject = SessionUtil.getSession().getAttribute(sessionId);
        if (mapObject == null) {
            return null;
        }
        if (!(mapObject instanceof Map)) {
            LOGGER.error("\u9884\u671f\u7684\u5bf9\u8c61\u4e0d\u662fMap\u7c7b\u578b");
            return null;
        }
        Map map = (Map)mapObject;
        Object objs = map.get(attrKey);
        if (objs == null) {
            LOGGER.warn("KEY \u4e3a {} \u7684\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object)attrKey);
            return null;
        }
        if (!(objs instanceof SessionValueItem)) {
            LOGGER.error("\u975e\u6cd5\u7684\u6570\u636e\u7ed3\u6784\uff1a\u975e\u9884\u671f\u7684 SessionValueItem \u5bf9\u8c61");
            return null;
        }
        SessionValueItem item = (SessionValueItem)objs;
        Object value = item.getValue();
        return value;
    }

    public static void setAttribute(HttpSession session, String attrKey, String value) {
        Preconditions.checkNotNull((Object)session, (Object)"\u8bf7\u6c42\u7684\u53c2\u6570 session \u4e3a null ");
        Preconditions.checkNotNull((Object)attrKey, (Object)"\u8bf7\u6c42\u7684\u53c2\u6570 attrKey \u4e3a null ");
        if (value == null) {
            LOGGER.warn("\u6307\u5b9a\u7684KEY {} \u503c\u5bf9\u8c61\u4e3a null", (Object)attrKey);
        }
        String sessionId = "HORIZON_" + SessionUtil.getSession().getId();
        Object sessionObject = SessionUtil.getSession().getAttribute(sessionId);
        Map mapObject = (Map)sessionObject;
        if (mapObject == null) {
            mapObject = Maps.newHashMap();
        }
        if (!(mapObject instanceof Map)) {
            LOGGER.error("\u9884\u671f\u7684\u5bf9\u8c61\u4e0d\u662fMap\u7c7b\u578b");
            return;
        }
        long timeMillis = System.currentTimeMillis();
        SessionValueItem svi = new SessionValueItem(value, timeMillis);
        mapObject.put(attrKey, svi);
        session.setAttribute(sessionId, (Object)mapObject);
    }

    public static void removeAttribute(HttpSession session, String attrKey) {
        Preconditions.checkNotNull((Object)attrKey, (Object)"\u8bf7\u6c42\u7684\u53c2\u6570 attrKey \u4e3a null ");
        String sessionId = "HORIZON_" + SessionUtil.getSession().getId();
        Object mapObject = SessionUtil.getSession().getAttribute(sessionId);
        if (mapObject == null) {
            LOGGER.error("SESSION \u9884\u671f\u7684 Map \u7c7b\u578b\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return;
        }
        if (!(mapObject instanceof Map)) {
            LOGGER.error("\u9884\u671f\u7684\u5bf9\u8c61\u4e0d\u662fMap\u7c7b\u578b");
            return;
        }
        Map attributeMap = (Map)mapObject;
        attributeMap.remove(attrKey);
    }

    public static HttpSession getSession() {
        HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return req.getSession(true);
    }
}

