/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import com.horizon.exception.extend.InitException;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectHelper.class);

    private ReflectHelper() {
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Field targetField = ReflectHelper.getTargetField(obj.getClass(), fieldName);
        try {
            return FieldUtils.readField((Field)targetField, (Object)obj, (boolean)true);
        }
        catch (IllegalAccessException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u5931\u8d25obj=" + obj + ",fieldName=" + fieldName, (Throwable)e);
            }
            return null;
        }
    }

    public static Field getTargetField(Class<?> targetClass, String fieldName) {
        Field field;
        block5: {
            field = null;
            try {
                if (targetClass == null) {
                    return field;
                }
                if (Object.class.equals(targetClass)) {
                    return field;
                }
                field = FieldUtils.getDeclaredField(targetClass, (String)fieldName, (boolean)true);
                if (field == null) {
                    field = ReflectHelper.getTargetField(targetClass.getSuperclass(), fieldName);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block5;
                LOGGER.error("\u83b7\u53d6\u83b7\u53d6\u4ee3\u7406\u5c5e\u6027\u5931\u8d25class=" + targetClass + ",fieldName=" + fieldName, (Throwable)e);
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        block3: {
            if (null == obj) {
                return;
            }
            Field targetField = ReflectHelper.getTargetField(obj.getClass(), fieldName);
            try {
                FieldUtils.writeField((Field)targetField, (Object)obj, (Object)value);
            }
            catch (IllegalAccessException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("\u5229\u7528\u53cd\u5c04\u8d4b\u503c\u65f6\u53d1\u751f\u9519\u8befobj=" + obj + ", fieldName=" + fieldName + ",value=" + value, (Throwable)e);
            }
        }
    }

    public static <T> T initClass(String clazzName) throws InitException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(clazzName);
            return (T)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("\u627e\u4e0d\u5230\u52a0\u8f7d\u7684\u7c7b," + e.getMessage());
            throw new InitException("\u627e\u4e0d\u5230\u52a0\u8f7d\u7684\u7c7b," + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            LOGGER.info("\u8be5\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316," + e.getMessage());
            throw new InitException("\u8be5\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316," + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.info("\u8be5\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316,\u53ef\u80fd\u7f3a\u5c11\u7a7a\u53c2\u6784\u9020\u51fd\u6570," + e.getMessage());
            throw new InitException("\u8be5\u7c7b\u65e0\u6cd5\u5b9e\u4f8b\u5316,\u53ef\u80fd\u7f3a\u5c11\u7a7a\u53c2\u6784\u9020\u51fd\u6570," + e.getMessage(), e);
        }
    }
}

