/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.springframework.util.FileCopyUtils;

public class ManifestUtil {
    private static final String MANIFEST_DIRECTORY_LOCATION = "META-INF" + File.separator + "MANIFEST.MF";
    private static final String MANIFEST_ENTRY = "META-INF/MANIFEST.MF";

    public static final Reader manifestReaderFromExplodedDirectory(File directory) {
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException("Must supply a valid directory");
        }
        try {
            File manifestFile = new File(directory.getAbsolutePath() + File.separator + MANIFEST_DIRECTORY_LOCATION);
            if (manifestFile.exists()) {
                return new FileReader(manifestFile);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read MANIFEST for exploded directory '" + directory.getAbsolutePath() + "'.", e);
        }
    }

    public static final Reader manifestReaderFromJar(File file) {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry(MANIFEST_ENTRY);
            if (entry != null) {
                StringWriter writer = new StringWriter();
                FileCopyUtils.copy((Reader)new InputStreamReader(jar.getInputStream(entry)), (Writer)writer);
                jar.close();
                StringReader stringReader = new StringReader(writer.toString());
                return stringReader;
            }
            Reader reader = null;
            return reader;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read MANIFEST.MF from jar '" + file.getAbsolutePath() + "'.", e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to close jar '" + file.getAbsolutePath() + "'.", ioe);
                }
            }
        }
    }

    public static Map<String, String> getProductVersionInfo(String filePath) {
        Map<String, Map<String, String>> map = ManifestUtil.getJarVersionInfo(filePath);
        Map<String, String> mapAll = new HashMap<String, String>();
        if (map != null && map.size() > 0) {
            mapAll = map.get("all");
        }
        return mapAll;
    }

    private static Map<String, Map<String, String>> getJarVersionInfo(String filePath) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        HashMap<String, String> mapAll = new HashMap<String, String>();
        HashMap<String, String> mapWorkflow = new HashMap<String, String>();
        HashMap<String, String> mapHorizon = new HashMap<String, String>();
        HashMap<String, String> mapDesigner = new HashMap<String, String>();
        File file = new File(filePath);
        if (!file.isDirectory()) {
            return null;
        }
        File[] allfiles = file.listFiles();
        if (allfiles != null && allfiles.length > 0) {
            for (int i = 0; i < allfiles.length; ++i) {
                File jarFile = allfiles[i];
                String fileName = jarFile.getName();
                if (!jarFile.isFile() || !fileName.startsWith("horizon-") || !fileName.endsWith(".jar")) continue;
                Reader reader = ManifestUtil.manifestReaderFromJar(jarFile);
                BufferedReader bReader = new BufferedReader(reader);
                String s = "";
                String version = "";
                try {
                    while ((s = bReader.readLine()) != null) {
                        if (s.contains("Timestamp:")) {
                            version = s.split("-")[3];
                            break;
                        }
                        if (!s.contains("Implementation-Version") || !(version = s.split(":")[1]).contains("SNAPSHOT")) continue;
                        version = version.split("-")[0];
                    }
                    bReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if ("".equals(version)) continue;
                if (fileName.startsWith("horizon-workflow")) {
                    mapWorkflow.put(fileName, version);
                } else if (fileName.startsWith("horizon-platform")) {
                    mapHorizon.put(fileName, version);
                } else if (fileName.startsWith("horizon-designer")) {
                    mapDesigner.put(fileName, version);
                }
                mapAll.put(fileName, version);
            }
            map.put("all", mapAll);
            map.put("workflow", mapWorkflow);
            map.put("horizon", mapHorizon);
            map.put("pageDesigner", mapDesigner);
        }
        return map;
    }

    public static String getProductMaxVersion(String filePath, String product) {
        Map<String, Map<String, String>> mapAll = ManifestUtil.getJarVersionInfo(filePath);
        Map<Object, Object> map = new HashMap();
        String strMaxVersion = "";
        if (mapAll == null || mapAll.size() == 0) {
            return "";
        }
        if ("".equals(product)) {
            return strMaxVersion;
        }
        map = mapAll.get(product);
        if (map != null && map.size() > 0) {
            int iMaxValue = 0;
            for (String string : map.keySet()) {
                String tmpVersion2;
                String version = ((String)map.get(string)).replaceAll(" ", "");
                if (!ManifestUtil.isInteger(version.replaceAll("\\.", ""))) continue;
                String[] ver = version.split("\\.");
                if ("".equals(strMaxVersion)) {
                    strMaxVersion = version;
                    iMaxValue = Integer.parseInt(strMaxVersion.replaceAll("\\.", ""));
                    continue;
                }
                String tmpVersion = version.replaceAll("\\.", "").substring(0, 2);
                if (Integer.parseInt(tmpVersion) > Integer.parseInt(String.valueOf(iMaxValue).substring(0, 2))) {
                    strMaxVersion = version;
                    iMaxValue = Integer.parseInt(strMaxVersion.replaceAll("\\.", ""));
                }
                if (ver.length <= 2 || String.valueOf(iMaxValue).length() <= 2) continue;
                String tmpVersion1 = version.replaceAll("\\.", "").substring(0, 3);
                if (Integer.parseInt(tmpVersion1) > Integer.parseInt(String.valueOf(iMaxValue).substring(0, 3))) {
                    strMaxVersion = version;
                    iMaxValue = Integer.parseInt(strMaxVersion.replaceAll("\\.", ""));
                }
                if (ver.length <= 3 || String.valueOf(iMaxValue).length() <= 3 || Integer.parseInt(tmpVersion2 = version.replaceAll("\\.", "").substring(0, 4)) <= Integer.parseInt(String.valueOf(iMaxValue).substring(0, 4))) continue;
                strMaxVersion = version;
                iMaxValue = Integer.parseInt(strMaxVersion.replaceAll("\\.", ""));
            }
        }
        return strMaxVersion;
    }

    private static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static void main(String[] args) {
        String filePath = "D:/software/TomcatAppTest/temp/horizon7.4.6/WEB-INF/lib";
        String strMaxVersion = ManifestUtil.getProductMaxVersion(filePath, "horizon");
        System.out.println("\u4ea7\u54c1\u7248\u672c\u53f7\u4e3a====" + strMaxVersion);
    }
}

