/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.utils;

import com.horizon.common.collect.Lists;
import com.horizon.utils.Constant;
import com.horizon.utils.DateUnit;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtil {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat shortSdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat longSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String formatDateTime(Date date) {
        return DateUtil.formatDateTime(date, DEFAULT_DATE_FORMAT);
    }

    public static String formatDateTime(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(date);
    }

    public static String getYear() {
        String nowDate = DateUtil.getNow();
        nowDate = nowDate.substring(0, 4);
        return nowDate;
    }

    public static String getYearMonth() {
        String nowDate = DateUtil.getNow();
        nowDate = nowDate.substring(0, 7);
        return nowDate;
    }

    public static String getYearMonthDay() {
        String nowDate = DateUtil.getNow();
        nowDate = nowDate.substring(0, 10);
        return nowDate;
    }

    public static String getYearMonthDayHour() {
        String nowDate = DateUtil.getNow();
        nowDate = nowDate.substring(0, 13) + ":00:00";
        return nowDate;
    }

    public static String getNow() {
        Date curDate = DateUtil.getNowDate();
        SimpleDateFormat formatter = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return formatter.format(curDate);
    }

    public static Date getNowDate() {
        Date curDate = new Date(System.currentTimeMillis());
        return curDate;
    }

    public static Date getDate(String strDate) {
        return DateUtil.getDate(strDate, DEFAULT_DATE_FORMAT);
    }

    public static Date getDate(String strDate, String format) {
        Date date = null;
        format = format != null && format.length() > 0 ? format : DEFAULT_DATE_FORMAT;
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            date = formatter.parse(strDate);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return date;
    }

    public static Timestamp getTimestamp(String strDate, String format) {
        Timestamp timestamp = null;
        format = format != null && format.length() > 0 ? format : DEFAULT_DATE_FORMAT;
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            Date date = formatter.parse(strDate);
            timestamp = new Timestamp(date.getTime());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return timestamp;
    }

    public static String getWeekDate(String dateTime) {
        Date date = DateUtil.getDate(dateTime, DEFAULT_DATE_FORMAT);
        if (date != null) {
            return DateUtil.getWeekDate(date);
        }
        return null;
    }

    public static String getWeekDate(Date date) {
        return DateUtil.getWeek(date);
    }

    public static String getWeekNow() {
        return DateUtil.getWeek(DateUtil.getNowDate());
    }

    public static String getWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (calendar.get(7)) {
            case 2: {
                return "\u661f\u671f\u4e00";
            }
            case 3: {
                return "\u661f\u671f\u4e8c";
            }
            case 4: {
                return "\u661f\u671f\u4e09";
            }
            case 5: {
                return "\u661f\u671f\u56db";
            }
            case 6: {
                return "\u661f\u671f\u4e94";
            }
            case 7: {
                return "\u661f\u671f\u516d";
            }
            case 1: {
                return "\u661f\u671f\u65e5";
            }
        }
        return "";
    }

    public static String getEnWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (calendar.get(7)) {
            case 2: {
                return "MONDAY";
            }
            case 3: {
                return "TUESDAY";
            }
            case 4: {
                return "WEDNESDAY";
            }
            case 5: {
                return "THURSDAY";
            }
            case 6: {
                return "FRIDAY";
            }
            case 7: {
                return "SATURDAY";
            }
            case 1: {
                return "SUNDAY";
            }
        }
        return "";
    }

    public static String getTimeZone(int id) {
        String[] values = Constant.TIMEZONEVALUES[id];
        return values[1];
    }

    public static boolean isAfter(Date srcdate, Date dtcdate) {
        return DateUtil.getGregorianCalendar(srcdate).after(DateUtil.getGregorianCalendar(dtcdate));
    }

    public static Date getEndWeekDate(Date date) {
        GregorianCalendar calendar = DateUtil.getGregorianCalendar(date);
        calendar.set(7, 1);
        Date enddateofweek = calendar.getTime();
        return enddateofweek;
    }

    public static Date getStartWeekDate(Date date) {
        GregorianCalendar calendar = DateUtil.getGregorianCalendar(date);
        calendar.set(7, 2);
        Date startdate = calendar.getTime();
        return startdate;
    }

    private static GregorianCalendar getGregorianCalendar(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar;
    }

    public static Date addDateYear(Date date, int count) {
        return DateUtil.addDateProcessor(1, date, count);
    }

    public static Date addDateMonth(Date date, int count) {
        return DateUtil.addDateProcessor(2, date, count);
    }

    public static Date addDateDay(Date date, int count) {
        return DateUtil.addDateProcessor(5, date, count);
    }

    public static Date addDateHour(Date date, int count) {
        return DateUtil.addDateProcessor(10, date, count);
    }

    public static Date addDateMinute(Date date, int count) {
        return DateUtil.addDateProcessor(12, date, count);
    }

    public static Date addDateSecond(Date date, int count) {
        return DateUtil.addDateProcessor(13, date, count);
    }

    private static Date addDateProcessor(int gregoriancalendar, Date date, int count) {
        GregorianCalendar calendar = DateUtil.getGregorianCalendar(date);
        calendar.add(gregoriancalendar, count);
        return calendar.getTime();
    }

    public static int subtractDateYYMMDD(String beginDate, String endDate) {
        beginDate = beginDate + " 00:00:00";
        endDate = endDate + " 23:59:59";
        return DateUtil.getSubtractDate(beginDate, endDate);
    }

    public static int getSubtractDate(String beginDate, String endDate) {
        Date bDate = DateUtil.getDate(beginDate, DEFAULT_DATE_FORMAT);
        Date eDate = DateUtil.getDate(endDate, DEFAULT_DATE_FORMAT);
        if (beginDate == null || endDate == null) {
            return 0;
        }
        return DateUtil.getSubtractDate(bDate, eDate);
    }

    public static int getSubtractDate(Date beginDate, Date endDate) {
        long beginTime = beginDate.getTime();
        long endTime = endDate.getTime();
        long betweenDays = (long)((double)((beginTime - endTime) / 86400000L) + 0.5);
        int bdays = (int)betweenDays;
        return bdays;
    }

    public static String getSubtractDHM(String beginTime, String endTime) {
        Date beginDate = DateUtil.getDate(beginTime, DEFAULT_DATE_FORMAT);
        Date endDate = DateUtil.getDate(endTime, DEFAULT_DATE_FORMAT);
        if (beginDate == null || endDate == null) {
            return null;
        }
        return DateUtil.getSubtractDHM(beginDate, endDate);
    }

    public static String getEnSubtractDHM(String beginTime, String endTime) {
        Date beginDate = DateUtil.getDate(beginTime, DEFAULT_DATE_FORMAT);
        Date endDate = DateUtil.getDate(endTime, DEFAULT_DATE_FORMAT);
        if (beginDate == null || endDate == null) {
            return null;
        }
        return DateUtil.getEnSubtractDHM(beginDate, endDate);
    }

    public static String getSubtractDHM(Date beginDate, Date endDate) {
        String[] res = DateUtil.getSubtractResArray(beginDate, endDate);
        StringBuffer dateBuffer = new StringBuffer();
        dateBuffer.append(res[0]).append(" \u5929 ");
        dateBuffer.append(res[1]).append(" \u65f6 ");
        dateBuffer.append(res[2]).append(" \u5206");
        return dateBuffer.toString();
    }

    public static String getEnSubtractDHM(Date beginDate, Date endDate) {
        String[] res = DateUtil.getSubtractResArray(beginDate, endDate);
        StringBuffer dateBuffer = new StringBuffer();
        dateBuffer.append(res[0]).append(" Day ");
        dateBuffer.append(res[1]).append(" Hour ");
        dateBuffer.append(res[2]).append(" Minute");
        return dateBuffer.toString();
    }

    public static String[] getSubtractResArray(Date beginDate, Date endDate) {
        long second = (endDate.getTime() - beginDate.getTime()) / 1000L;
        long date = second / 86400L;
        long hour = second / 3600L;
        long mint = second / 60L;
        mint -= hour * 60L;
        String[] subtractRes = new String[]{Long.toString(date), Long.toString(hour -= date * 24L), Long.toString(mint)};
        return subtractRes;
    }

    public static Date setHHmmss(Date date, int hour, int min, int sed) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, sed);
        return calendar.getTime();
    }

    public static Date getFirstDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getLastDateOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static int getDays(String ... data) {
        Date date = data.length == 0 ? DateUtil.getDate(data[0], "yyyy-MM-dd") : DateUtil.getDate(data[0], data[1]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, calendar.get(1));
        calendar.set(2, calendar.get(2));
        return calendar.getActualMaximum(5);
    }

    public static boolean isLeapYear(int year) {
        boolean isLeap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
        return isLeap;
    }

    public static List<String> getMonthBetween(String startDate, String endData, String format) {
        ArrayList result = Lists.newArrayList();
        Date begin = DateUtil.getDate(startDate, format);
        Date end = DateUtil.getDate(endData, format);
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(begin);
        min.set(min.get(1), min.get(2), 1);
        max.setTime(end);
        max.set(max.get(1), max.get(2), 2);
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(DateUtil.formatDateTime(curr.getTime(), format));
            curr.add(2, 1);
        }
        return result;
    }

    public static Date getCurrentMonthStartTime() {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.set(5, 1);
            now = shortSdf.parse(shortSdf.format(c.getTime()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentMonthEndTime() {
        Calendar c = Calendar.getInstance();
        Date now = null;
        try {
            c.set(5, 1);
            c.add(2, 1);
            c.add(5, -1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterStartTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 0);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 3);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 4);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 9);
            }
            c.set(5, 1);
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 00:00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static Date getCurrentQuarterEndTime() {
        Calendar c = Calendar.getInstance();
        int currentMonth = c.get(2) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3) {
                c.set(2, 2);
                c.set(5, 31);
            } else if (currentMonth >= 4 && currentMonth <= 6) {
                c.set(2, 5);
                c.set(5, 30);
            } else if (currentMonth >= 7 && currentMonth <= 9) {
                c.set(2, 8);
                c.set(5, 30);
            } else if (currentMonth >= 10 && currentMonth <= 12) {
                c.set(2, 11);
                c.set(5, 31);
            }
            now = longSdf.parse(shortSdf.format(c.getTime()) + " 23:59:59");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return now;
    }

    public static long betweenSecond(Date beginDate, Date endDate) {
        return DateUtil.between(beginDate, endDate, DateUnit.SECOND);
    }

    public static long betweenSecond(String beginDate, String endDate) {
        return DateUtil.between(beginDate, endDate, DateUnit.SECOND);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        long diff = 0L;
        diff = DateUtil.isAfter(beginDate, endDate) ? beginDate.getTime() - endDate.getTime() : endDate.getTime() - beginDate.getTime();
        return diff / unit.getMillis();
    }

    public static long between(String beginDate, String endDate, DateUnit unit) {
        Date end;
        long diff = 0L;
        Date begin = DateUtil.getDate(beginDate);
        diff = DateUtil.isAfter(begin, end = DateUtil.getDate(endDate)) ? begin.getTime() - end.getTime() : end.getTime() - begin.getTime();
        return diff / unit.getMillis();
    }

    public static String diffSecondToDHM(Long diffSecond) {
        return DateUtil.diffToDHM(diffSecond, DateUnit.SECOND);
    }

    public static String diffEnSecondToDHM(Long diffSecond) {
        return DateUtil.diffEnToDHM(diffSecond, DateUnit.SECOND);
    }

    public static String diffToDHM(Long diff, DateUnit unit) {
        long second = diff * unit.getMillis() / 1000L;
        long date = second / 86400L;
        long hour = second / 3600L;
        long mint = second / 60L;
        mint -= hour * 60L;
        String[] subtractRes = new String[]{Long.toString(date), Long.toString(hour -= date * 24L), Long.toString(mint)};
        StringBuffer dateBuffer = new StringBuffer();
        dateBuffer.append(subtractRes[0]).append(" \u5929 ");
        dateBuffer.append(subtractRes[1]).append(" \u65f6 ");
        dateBuffer.append(subtractRes[2]).append(" \u5206");
        return dateBuffer.toString();
    }

    public static String diffEnToDHM(Long diff, DateUnit unit) {
        long second = diff * unit.getMillis() / 1000L;
        long date = second / 86400L;
        long hour = second / 3600L;
        long mint = second / 60L;
        mint -= hour * 60L;
        String[] subtractRes = new String[]{Long.toString(date), Long.toString(hour -= date * 24L), Long.toString(mint)};
        StringBuffer dateBuffer = new StringBuffer();
        dateBuffer.append(subtractRes[0]).append(" Day ");
        dateBuffer.append(subtractRes[1]).append(" Hour ");
        dateBuffer.append(subtractRes[2]).append(" Minute");
        return dateBuffer.toString();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.getYearMonthDayHour());
        Date date = DateUtil.getDate(DateUtil.getYearMonthDayHour());
        System.out.println(DateUtil.formatDateTime(DateUtil.addDateHour(date, -12)));
    }
}

