/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.task.quartz.util;

import com.horizon.quartz.Scheduler;
import com.horizon.quartz.SchedulerException;
import com.horizon.quartz.impl.StdSchedulerFactory;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizonScheduleUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(HorizonScheduleUtil.class);
    private static final String DEFAULT_NAME = "DEFAULT_SCHEDULER";
    private static final String QUARTZ_TABLE_PREFIX = "QUARTZ_TABLE_PREFIX";
    private static final Map<String, Object> SCHEDULE_MAP = new HashMap<String, Object>();

    public static Scheduler getScheduler(String name) {
        if (SCHEDULE_MAP.containsKey(name)) {
            return (Scheduler)SCHEDULE_MAP.get(name);
        }
        LOGGER.error(" can not get scheduler by name:" + name);
        return null;
    }

    public static void addScheduler(String name, Scheduler scheduler) {
        SCHEDULE_MAP.put(name, scheduler);
        LOGGER.info(" add scheduler by name:" + name + " success!");
    }

    public static Scheduler getDefaultSchedule() {
        return (Scheduler)SCHEDULE_MAP.get(DEFAULT_NAME);
    }

    public static String getQuartzTablePrefix() {
        return (String)SCHEDULE_MAP.get(QUARTZ_TABLE_PREFIX);
    }

    static {
        try {
            Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();
            SCHEDULE_MAP.put(DEFAULT_NAME, scheduler);
            String quartzTablePrefix = StdSchedulerFactory.getTablePrefix();
            SCHEDULE_MAP.put(QUARTZ_TABLE_PREFIX, quartzTablePrefix);
        }
        catch (SchedulerException e) {
            LOGGER.error("Get default scheduler fail. Exception:" + e.getMessage());
        }
    }
}

