/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.task.quartz.util;

import com.horizon.common.collect.Maps;
import com.horizon.db.DBConfigInfoHelper;
import com.horizon.quartz.impl.jdbcjobstore.DriverDelegate;
import com.horizon.quartz.impl.jdbcjobstore.JobStoreTX;
import com.horizon.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import com.horizon.utils.StringUtil;
import java.util.Map;

public class HorizonJobStore
extends JobStoreTX {
    private static Map<String, DriverDelegate> holder = Maps.newHashMap();

    protected DriverDelegate getDelegate() throws NoSuchDelegateException {
        String identifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        if (StringUtil.hasValue(identifier)) {
            String sqlType = DBConfigInfoHelper.getDatabaseType(identifier);
            DriverDelegate delegate = holder.get(sqlType);
            if (delegate == null) {
                delegate = this.getHDelegate(sqlType);
                holder.put(sqlType, delegate);
            }
            return delegate;
        }
        return super.getDelegate();
    }

    private DriverDelegate getHDelegate(String sqlType) throws NoSuchDelegateException {
        if ("POSTGRESQL".equalsIgnoreCase(sqlType) || "GAUSS".equalsIgnoreCase(sqlType) || "POSTGRESQL".equalsIgnoreCase(sqlType) || "HIGHGO".equalsIgnoreCase(sqlType)) {
            return this.loadDelegate("com.horizon.quartz.impl.jdbcjobstore.PostgreSQLDelegate");
        }
        return super.getDelegate();
    }

    private DriverDelegate loadDelegate(String className) throws NoSuchDelegateException {
        try {
            Class delegateClass = this.getClassLoadHelper().loadClass(className, DriverDelegate.class);
            DriverDelegate delegate = (DriverDelegate)delegateClass.newInstance();
            delegate.initialize(this.getLog(), this.tablePrefix, this.instanceName, this.instanceId, this.getClassLoadHelper(), this.canUseProperties(), this.getDriverDelegateInitString());
            return delegate;
        }
        catch (InstantiationException e) {
            throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchDelegateException("Couldn't create delegate: " + e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchDelegateException("Couldn't load delegate class: " + e.getMessage(), (Throwable)e);
        }
    }
}

