/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.task.init;

import com.horizon.core.init.HInit;
import com.horizon.core.init.HorizonInitAble;
import com.horizon.db.DBConfigInfoHelper;
import com.horizon.task.api.HorizonTaskFactory;
import com.horizon.task.api.IHorizonTask;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HInit
public class HorizonTaskScheduleInit
implements HorizonInitAble {
    private static final Logger logger = LoggerFactory.getLogger(HorizonTaskScheduleInit.class);
    private static AtomicBoolean wasRun = new AtomicBoolean(false);
    private static CountDownLatch initCompleteLatch = new CountDownLatch(1);

    @Override
    public void start() {
        String identifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        if (HorizonPorps.isTaskStart() && StringUtil.hasValue(identifier)) {
            if (!wasRun.getAndSet(true)) {
                Thread horizonTaskSchedule = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        IHorizonTask api = HorizonTaskFactory.newInstance().getHorizonTask();
                        try {
                            if (!api.isStarted()) {
                                api.startup();
                                logger.info("task schedule is started.");
                            }
                        }
                        catch (HorizonTaskException e) {
                            logger.error("start task schedule fail:{}", (Throwable)e);
                        }
                        initCompleteLatch.countDown();
                    }
                }, "horizonTaskScheduleStartUp");
                horizonTaskSchedule.start();
            } else {
                logger.info("Waiting to task schedule to start.");
                try {
                    initCompleteLatch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                logger.warn("task schedule was already start");
            }
        }
    }

    @Override
    public void destory() {
    }

    @Override
    public int getSort() {
        return -1;
    }
}

