/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.task.api.service.impl;

import com.horizon.quartz.CronScheduleBuilder;
import com.horizon.quartz.DateBuilder;
import com.horizon.quartz.JobBuilder;
import com.horizon.quartz.JobDataMap;
import com.horizon.quartz.JobDetail;
import com.horizon.quartz.JobKey;
import com.horizon.quartz.JobListener;
import com.horizon.quartz.Matcher;
import com.horizon.quartz.ScheduleBuilder;
import com.horizon.quartz.Scheduler;
import com.horizon.quartz.SchedulerException;
import com.horizon.quartz.SimpleScheduleBuilder;
import com.horizon.quartz.Trigger;
import com.horizon.quartz.TriggerBuilder;
import com.horizon.quartz.impl.matchers.KeyMatcher;
import com.horizon.quartz.utils.Key;
import com.horizon.task.adapter.AbstractEntityTaskAdapter;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.api.model.TriggerBean;
import com.horizon.task.api.service.IQuartzService;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.utils.DateUtil;
import com.horizon.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QuartzServiceImpl
implements IQuartzService {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzServiceImpl.class);

    @Override
    public void scheduleJob(JobBean jobBean, Scheduler scheduler) throws HorizonTaskException {
        if (jobBean != null) {
            String jobName = jobBean.getJobName();
            String jobGroup = jobBean.getJobGroup();
            Class<AbstractEntityTaskAdapter> jobclass = this.getJobClass(jobBean.getJobClass());
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            String storeDurably = jobBean.getStoreDurably();
            boolean jobDurability = storeDurably != null && storeDurably.equals("1");
            JobDetail detail = JobBuilder.newJob(jobclass).withIdentity(jobKey).storeDurably(jobDurability).withDescription(jobBean.getDescription()).build();
            this.parseJobPara(jobBean, detail);
            JobListener listener = this.getJobListener(jobBean.getJobListener());
            try {
                if (listener != null) {
                    KeyMatcher matcher = KeyMatcher.keyEquals((Key)jobKey);
                    scheduler.getListenerManager().addJobListener(listener, (Matcher)matcher);
                }
                if (scheduler.checkExists(jobKey)) {
                    LOGGER.error("Job with name: " + jobName + " group :" + jobGroup + " exists already.");
                    throw new HorizonTaskException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\uff1a" + jobName + ", \u5206\u7ec4\u7f16\u7801\uff1a" + jobGroup + " \u7684\u4efb\u52a1\u5df2\u5b58\u5728\u3002");
                }
                for (int i = 0; i < jobBean.getJobTriggers().length; ++i) {
                    TriggerBean tb = jobBean.getJobTriggers()[i];
                    Trigger trigger = this.parseTriggerBean(tb, jobKey);
                    if (scheduler.checkExists(jobKey)) {
                        scheduler.scheduleJob(trigger);
                        continue;
                    }
                    scheduler.scheduleJob(detail, trigger);
                }
            }
            catch (SchedulerException e) {
                LOGGER.error("Schedule Job with name: " + jobName + " group :" + jobGroup + " Fail.");
                throw new HorizonTaskException("\u4fdd\u5b58\u5931\u8d25.\u539f\u56e0:" + e.getMessage());
            }
        }
    }

    private Class<AbstractEntityTaskAdapter> getJobClass(String jobclass) throws HorizonTaskException {
        Class<AbstractEntityTaskAdapter> task = null;
        try {
            task = Class.forName(jobclass);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("can not find class with classname:" + jobclass);
            throw new HorizonTaskException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4efb\u52a1\u5168\u7c7b\u540d\u662f\u5426\u586b\u5199\u6b63\u786e");
        }
        return task;
    }

    private JobListener getJobListener(String jobListener) throws HorizonTaskException {
        JobListener listener = null;
        if (StringUtil.hasValue(jobListener)) {
            try {
                listener = (JobListener)Class.forName(jobListener).newInstance();
            }
            catch (InstantiationException e) {
                LOGGER.error("can not create an instance with classname:" + jobListener);
                throw new HorizonTaskException("\u5b9e\u4f8b\u5316\u5931\u8d25\uff0cclassname:" + jobListener);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("can not access class with classname:" + jobListener);
                throw new HorizonTaskException("\u7c7b\u62d2\u7edd\u8bbf\u95ee\uff0cclassname:" + jobListener);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("can not find class with classname:" + jobListener);
                throw new HorizonTaskException("\u627e\u4e0d\u5230\u7c7b\uff0cclassname:" + jobListener);
            }
        }
        return listener;
    }

    @Override
    public void parseJobPara(JobBean jobBean, JobDetail jobDetail) {
        String para = jobBean.getJobPara();
        if (para != null && !"".equals(para)) {
            String[] paraArr = para.split(";");
            int len = paraArr.length;
            for (int i = 0; i < len; ++i) {
                String[] paraInfo = paraArr[i].split("=");
                jobDetail.getJobDataMap().put(paraInfo[0], paraInfo[1]);
            }
        }
        if ("1".equals(jobBean.getJobRunRecordFlag())) {
            jobDetail.getJobDataMap().put("jobrunrecordflag", jobBean.getJobRunRecordFlag());
            jobDetail.getJobDataMap().put("keeprunrecorddays", jobBean.getKeepRunRecordDays());
        }
        jobDetail.getJobDataMap().put("tk_horizon_trigger_rec_dbidentifier", jobBean.getDbIdentifier());
        jobDetail.getJobDataMap().putAll(jobBean.getDataMap());
    }

    @Override
    public String parseJobMapToStr(JobDataMap dataMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return "";
        }
        String[] keys = dataMap.getKeys();
        StringBuilder sb = new StringBuilder();
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            if ("jobrunrecordflag".equals(keys[i]) || "keeprunrecorddays".equals(keys[i]) || "tk_horizon_trigger_rec_dbidentifier".equals(keys[i])) continue;
            sb.append(keys[i]).append("=").append(dataMap.getString(keys[i])).append(";");
        }
        return sb.toString();
    }

    @Override
    public Trigger parseTriggerBean(TriggerBean triggerBean, JobKey jobKey) {
        Trigger trigger = null;
        if (triggerBean != null) {
            int triggerType = triggerBean.getTriggerType();
            switch (triggerType) {
                case 0: {
                    trigger = this.parseSimpleTriggerBean(triggerBean, jobKey);
                    break;
                }
                case 1: {
                    trigger = this.parseCronTriggerBean(triggerBean, jobKey);
                    break;
                }
            }
        }
        return trigger;
    }

    private Trigger parseSimpleTriggerBean(TriggerBean triggerBean, JobKey jobKey) {
        String name = triggerBean.getTriggerName() + "_" + jobKey.getName() + "_" + jobKey.getGroup();
        String group = triggerBean.getTriggerGroup();
        TriggerBuilder simpleTriggerBuilder = TriggerBuilder.newTrigger().withIdentity(name, group);
        String dateFormat = "yyyy-MM-dd HH:mm";
        if (StringUtil.hasValue(triggerBean.getStartTime())) {
            simpleTriggerBuilder.startAt(DateUtil.getDate(triggerBean.getStartTime(), dateFormat));
        } else {
            simpleTriggerBuilder.startAt(DateBuilder.evenSecondDateAfterNow());
        }
        if (StringUtil.hasValue(triggerBean.getEndTime())) {
            simpleTriggerBuilder.endAt(DateUtil.getDate(triggerBean.getEndTime(), dateFormat));
        }
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        this.setRepeatInterval(triggerBean.getIntervalType(), simpleScheduleBuilder, triggerBean.getRepeatInterval());
        if (triggerBean.getRepeatCount() >= 0) {
            simpleScheduleBuilder.withRepeatCount(triggerBean.getRepeatCount());
        } else {
            simpleScheduleBuilder.repeatForever();
        }
        simpleTriggerBuilder.withSchedule((ScheduleBuilder)simpleScheduleBuilder);
        return simpleTriggerBuilder.forJob(jobKey).build();
    }

    private Trigger parseCronTriggerBean(TriggerBean triggerBean, JobKey jobKey) {
        String name = triggerBean.getTriggerName() + "_" + jobKey.getName() + "_" + jobKey.getGroup();
        String group = triggerBean.getTriggerGroup();
        TriggerBuilder cronTriggerBuilder = TriggerBuilder.newTrigger().withIdentity(name, group);
        cronTriggerBuilder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)triggerBean.getCronExpress()));
        return cronTriggerBuilder.forJob(jobKey).build();
    }

    @Override
    public void setRepeatInterval(int intervalType, SimpleScheduleBuilder simpleScheduleBuilder, int intervalValue) {
        switch (intervalType) {
            case 0: {
                simpleScheduleBuilder.withIntervalInMilliseconds((long)intervalValue);
                break;
            }
            case 1: {
                simpleScheduleBuilder.withIntervalInSeconds(intervalValue);
                break;
            }
            case 2: {
                simpleScheduleBuilder.withIntervalInMinutes(intervalValue);
                break;
            }
            case 3: {
                simpleScheduleBuilder.withIntervalInHours(intervalValue);
                break;
            }
            default: {
                simpleScheduleBuilder.repeatForever();
            }
        }
    }
}

