/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.task.api.impl;

import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.quartz.JobDetail;
import com.horizon.quartz.JobKey;
import com.horizon.quartz.JobListener;
import com.horizon.quartz.Scheduler;
import com.horizon.quartz.SchedulerException;
import com.horizon.quartz.Trigger;
import com.horizon.quartz.TriggerKey;
import com.horizon.task.api.IHorizonJobListener;
import com.horizon.task.api.IHorizonTask;
import com.horizon.task.api.model.JobBean;
import com.horizon.task.api.model.TriggerBean;
import com.horizon.task.api.service.IQuartzService;
import com.horizon.task.exception.HorizonTaskException;
import com.horizon.task.quartz.util.HorizonScheduleUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HorizonTaskImpl
implements IHorizonTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(HorizonTaskImpl.class);
    @Autowired
    private IQuartzService quartzService;

    @Override
    public boolean startup() {
        try {
            Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
            Map maps = SpringContextHolder.getApplicationContext().getBeansOfType(IHorizonJobListener.class);
            if (maps != null) {
                Collection values = maps.values();
                int size = values != null ? values.size() : 0;
                LOGGER.info("task\u83b7\u53d6\u5230:" + size + " \u4e2aListener");
                if (values != null) {
                    for (IHorizonJobListener jobListener : values) {
                        scheduler.getListenerManager().addJobListener((JobListener)jobListener);
                    }
                }
            }
            scheduler.start();
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("\u542f\u52a8\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25" + e.getMessage());
            throw new HorizonTaskException("\u542f\u52a8\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25", e);
        }
    }

    @Override
    public boolean shutdown() {
        try {
            Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
            scheduler.shutdown();
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("\u5173\u95ed\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25.");
            throw new HorizonTaskException("\u5173\u95ed\u4efb\u52a1\u8c03\u5ea6\u5668\u5931\u8d25", e);
        }
    }

    @Override
    public boolean isStarted() {
        try {
            Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
            return scheduler.isStarted();
        }
        catch (SchedulerException e) {
            LOGGER.error("\u83b7\u53d6\u8c03\u5ea6\u5668\u662f\u5426\u542f\u52a8\u72b6\u6001\u5931\u8d25.");
            throw new HorizonTaskException("\u83b7\u53d6\u8c03\u5ea6\u5668\u662f\u5426\u542f\u52a8\u72b6\u6001\u5931\u8d25", e);
        }
    }

    @Override
    public boolean scheduleJob(JobBean jobBean) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        this.quartzService.scheduleJob(jobBean, scheduler);
        return true;
    }

    @Override
    public boolean scheduleJob(TriggerBean triggerBean, String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            if (scheduler.checkExists(jobKey)) {
                Trigger trigger = this.quartzService.parseTriggerBean(triggerBean, jobKey);
                scheduler.scheduleJob(trigger);
            }
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Schedule job fail.");
            throw new HorizonTaskException("\u8fd0\u884c\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean pauseJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            scheduler.pauseJob(jobKey);
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Pause job with name: " + jobName + " group :" + jobGroup + " fail.");
            throw new HorizonTaskException("\u6682\u505c\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean pauseTrigger(String triggerCode, String triggerGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerCode, (String)triggerGroup);
            scheduler.pauseTrigger(triggerKey);
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Pause trigger with name: " + triggerCode + " group :" + triggerGroup + " fail.");
            throw new HorizonTaskException("\u6682\u505c\u89e6\u53d1\u5668\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean pauseAll() {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            scheduler.pauseAll();
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Pause All Job Fail.");
            throw new HorizonTaskException("\u6682\u505c\u6240\u6709\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean resumeJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            scheduler.resumeJob(jobKey);
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Resume job with name: " + jobName + " group :" + jobGroup + " fail.");
            throw new HorizonTaskException("\u5524\u9192\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean resumeTrigger(String triggerCode, String triggerGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerCode, (String)triggerGroup);
            scheduler.resumeTrigger(triggerKey);
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Resume trigger with name: " + triggerCode + " group :" + triggerGroup + " fail.");
            throw new HorizonTaskException("\u5524\u9192\u89e6\u53d1\u5668\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean resumeAll() {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            scheduler.resumeAll();
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Resume All Job Fail.");
            throw new HorizonTaskException("\u5524\u9192\u6240\u6709\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean unscheduleJob(String triggerCode, String triggerGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerCode, (String)triggerGroup);
            return scheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            LOGGER.error("Unschedule trigger with name: " + triggerCode + " group :" + triggerGroup + " fail.");
            throw new HorizonTaskException("\u53d6\u6d88\u89e6\u53d1\u5668\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean deleteJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            if (scheduler.checkExists(jobKey)) {
                return scheduler.deleteJob(jobKey);
            }
            return true;
        }
        catch (SchedulerException e) {
            LOGGER.error("Batch delete job fail.");
            throw new HorizonTaskException("\u5220\u9664\u4efb\u52a1\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean checkExistsJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            return scheduler.checkExists(jobKey);
        }
        catch (SchedulerException e) {
            LOGGER.error("CheckExists jobKey fail.");
            throw new HorizonTaskException("\u5224\u65ad\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public boolean checkExistsTrigger(String triggerCode, String triggerGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerCode, (String)triggerGroup);
            return scheduler.checkExists(triggerKey);
        }
        catch (SchedulerException e) {
            LOGGER.error("CheckExists triggerKey fail.");
            throw new HorizonTaskException("\u5224\u65ad\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public List<Trigger> getTriggersOfJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            return scheduler.getTriggersOfJob(jobKey);
        }
        catch (SchedulerException e) {
            LOGGER.error("getTriggersOfJob fail.");
            throw new HorizonTaskException("\u83b7\u53d6\u4efb\u52a1\u7684\u89e6\u53d1\u5668\u4fe1\u606f\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public String getJobPara(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            JobDetail detail = scheduler.getJobDetail(jobKey);
            if (detail == null) {
                return "";
            }
            String jobPara = this.quartzService.parseJobMapToStr(detail.getJobDataMap());
            return jobPara;
        }
        catch (SchedulerException e) {
            LOGGER.error("getJobDetail fail.");
            throw new HorizonTaskException("\u83b7\u53d6\u4efb\u52a1\u53c2\u6570\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public String getSchedulerName() {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            return scheduler.getSchedulerName();
        }
        catch (SchedulerException e) {
            LOGGER.error("getSchedulerName fail.");
            throw new HorizonTaskException("\u83b7\u53d6\u8c03\u5ea6\u5668\u5b9e\u4f8b\u540d.\u539f\u56e0:", e);
        }
    }

    @Override
    public JobBean getJob(String jobName, String jobGroup) {
        Scheduler scheduler = HorizonScheduleUtil.getDefaultSchedule();
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroup);
            JobDetail detail = scheduler.getJobDetail(jobKey);
            if (detail == null) {
                return null;
            }
            JobBean jobBean = new JobBean();
            jobBean.setJobName(jobName);
            jobBean.setJobGroup(jobGroup);
            jobBean.setJobClass(detail.getJobClass().getName());
            jobBean.setJobPara(this.quartzService.parseJobMapToStr(detail.getJobDataMap()));
            jobBean.setDescription(detail.getDescription());
            String isStore = detail.isDurable() ? "1" : "0";
            jobBean.setStoreDurably(isStore);
            return jobBean;
        }
        catch (SchedulerException e) {
            LOGGER.error("getJobDetail fail.");
            throw new HorizonTaskException("\u83b7\u53d6\u4efb\u52a1\u4fe1\u606f\u5931\u8d25.\u539f\u56e0:", e);
        }
    }

    @Override
    public String getQuartzTablePrefix() {
        return HorizonScheduleUtil.getQuartzTablePrefix();
    }
}

