/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.taglib.language;

import com.horizon.language.Hi18n;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import java.io.IOException;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class Hi18nTag
extends TagSupport {
    private static final long serialVersionUID = 2965301813070774591L;
    private String group;
    private String key;

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            if (!StringUtil.hasValue(this.key) && StringUtil.hasValue(this.group)) {
                Map<String, String> map = Hi18n.getLanguage(this.group);
                out.print(JsonUtil.toJsonSerializerNull(map));
            } else if (this.key.equals("lang")) {
                out.print(Hi18n.getDefLocaleKey().replaceAll("_", "-"));
            } else {
                out.print(Hi18n.getVal(this.group, this.key));
            }
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void release() {
        super.release();
        this.group = null;
        this.key = null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

