/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.profile.api;

import com.horizon.exception.HorizonException;
import com.horizon.profile.IStream;
import com.horizon.profile.model.CommentedProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ProfileContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileContext.class);
    private static ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private String fileNames = "";
    private String resourceFolder = "";
    private IStream streamUtil;
    private final LinkedHashMap<String, String> keyCommentMap = new LinkedHashMap();
    private Map<String, CommentedProperties> profilePool = new ConcurrentHashMap<String, CommentedProperties>();
    private static final String BLANK = "";

    private ProfileContext() {
    }

    public static ProfileContext newInstance() {
        return SingletonHolder.instance;
    }

    public ProfileContext setStreamUtil(IStream streamUtil) {
        this.streamUtil = streamUtil;
        return this;
    }

    public Map<String, CommentedProperties> getProfilePool() {
        return this.profilePool;
    }

    public void build() {
        String[] names = this.getNames();
        if (names.length > 0) {
            for (String name : names) {
                CommentedProperties commentedProperties = new CommentedProperties(new Properties());
                try {
                    InputStream in = this.streamUtil.getInputStream(name);
                    commentedProperties.load(in, "UTF-8");
                    this.profilePool.put(name.substring(0, name.indexOf(".")), commentedProperties);
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        } else {
            LOGGER.error("\u6ca1\u6709\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6");
        }
    }

    private String[] getNames() {
        File file = new File(this.streamUtil.getRealPath(null));
        String[] names = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties");
            }
        });
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildResources(boolean jarPropReadonly) {
        if (jarPropReadonly) {
            this.buildResources();
        } else {
            this.copyResourceFromJar();
            String[] names = this.fileNames.split(";");
            if (names.length > 0) {
                for (String name : names) {
                    CommentedProperties properties = new CommentedProperties();
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(this.resourceFolder + name);
                        InputStreamReader isr = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                        BufferedReader br = new BufferedReader(isr);
                        properties.load(br);
                        name = name.substring(0, name.indexOf("."));
                        this.profilePool.put(name, properties);
                    }
                    catch (IOException e) {
                        LOGGER.error(e.getMessage());
                    }
                    finally {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException e) {
                                LOGGER.error(e.getMessage());
                            }
                        }
                    }
                }
            } else {
                LOGGER.error("\u6ca1\u6709\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6");
            }
        }
    }

    public void buildResources() {
        try {
            Resource[] resources = resolver.getResources("classpath*:workflow-conf/properties/*.properties");
            if (resources.length <= 0) {
                LOGGER.debug("file is not found!");
            } else {
                for (Resource resource : resources) {
                    String name = resource.getFilename();
                    if (name == null) continue;
                    CommentedProperties properties = new CommentedProperties();
                    InputStream is = resource.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    properties.load(br);
                    name = name.substring(0, name.indexOf("."));
                    if ("horizon".equals(name)) {
                        properties.setProperty("jarPropReadonly", "true");
                    }
                    this.profilePool.put(name, properties);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Get file failed :" + e.getMessage());
        }
    }

    private void copyResourceFromJar() {
        this.getCopyResource();
        try {
            Resource[] resources = resolver.getResources("classpath*:workflow-conf/properties/*.properties");
            if (resources.length <= 0) {
                LOGGER.debug("file is not found!");
            } else {
                for (Resource resource : resources) {
                    String name = resource.getFilename();
                    if (name == null) continue;
                    this.fileNames = this.fileNames + name + ";";
                    this.loadRecourseFromJar(name);
                }
                if (!BLANK.equals(this.fileNames)) {
                    this.fileNames = this.fileNames.substring(0, this.fileNames.lastIndexOf(59));
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Get file failed :" + e.getMessage());
        }
    }

    public void modify(String profileName, String key, String value) {
        CommentedProperties properties = this.getProperties(profileName);
        if (properties.containsKey(key)) {
            if (value == null) {
                value = BLANK;
            }
            String oldValue = properties.setProperty(key, value);
            try {
                this.write2File(profileName, properties);
            }
            catch (IOException e) {
                LOGGER.info("\u4fee\u6539\u5931\u8d25");
                properties.setProperty(key, oldValue);
                throw new HorizonException();
            }
        }
    }

    public void modify(String profileName, String key, String value, boolean escape) {
        if (escape) {
            this.modify(profileName, key, value);
        } else {
            CommentedProperties properties = this.getProperties(profileName);
            if (properties.containsKey(key)) {
                if (value == null) {
                    value = BLANK;
                }
                String oldValue = properties.setProperty(key, value);
                try {
                    this.write2FileNoEscape(profileName, properties);
                }
                catch (IOException e) {
                    LOGGER.info("\u4fee\u6539\u5931\u8d25");
                    properties.setProperty(key, oldValue);
                    throw new HorizonException();
                }
            }
        }
    }

    public void modify(String profileName, Map<String, String> keyValue) {
        CommentedProperties properties = this.getProperties(profileName);
        HashMap<String, String> keyValueBackup = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : keyValue.entrySet()) {
            if (!properties.containsKey(kv.getKey())) continue;
            keyValueBackup.put(kv.getKey(), this.get(profileName, kv.getKey()));
            properties.setProperty(kv.getKey(), kv.getValue());
        }
        try {
            this.write2File(profileName, properties);
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            for (Map.Entry kvb : keyValueBackup.entrySet()) {
                properties.setProperty((String)kvb.getKey(), (String)kvb.getValue());
            }
            throw new HorizonException();
        }
    }

    public void modify(String profileName, Map<String, String> keyValue, boolean escape) {
        CommentedProperties properties = this.getProperties(profileName);
        HashMap<String, String> keyValueBackup = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : keyValue.entrySet()) {
            if (!properties.containsKey(kv.getKey())) continue;
            keyValueBackup.put(kv.getKey(), this.get(profileName, kv.getKey()));
            properties.setProperty(kv.getKey(), kv.getValue());
        }
        try {
            this.write2FileNoEscape(profileName, properties);
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            for (Map.Entry kvb : keyValueBackup.entrySet()) {
                properties.setProperty((String)kvb.getKey(), (String)kvb.getValue());
            }
            throw new HorizonException();
        }
    }

    public void modify(String profileName, String key, String value, String comment) {
        CommentedProperties properties = this.getProperties(profileName);
        String valueBackup = this.get(profileName, key);
        String commentBackup = this.getComment(profileName, key);
        String tempComment = BLANK;
        if (properties.containsKey(key)) {
            properties.setProperty(key, value);
            tempComment = comment;
            try {
                this.write2File(profileName, properties);
            }
            catch (IOException e) {
                LOGGER.info("\u4fee\u6539\u5931\u8d25");
                properties.setProperty(key, valueBackup);
                tempComment = commentBackup;
                throw new HorizonException();
            }
            if (BLANK.equals(tempComment)) {
                if (!this.keyCommentMap.containsKey(key)) {
                    this.keyCommentMap.put(key, tempComment);
                }
            } else {
                this.keyCommentMap.put(key, tempComment);
            }
        }
    }

    public void delete(String profileName, String key) {
        CommentedProperties properties = this.getProperties(profileName);
        String oldvalue = (String)properties.remove(key);
        try {
            this.write2File(profileName, properties);
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            properties.setProperty(key, oldvalue);
            throw new HorizonException();
        }
    }

    public void delete(String profileName, List<String> list) {
        CommentedProperties properties = this.getProperties(profileName);
        HashMap<String, String> keyValueBackup = new HashMap<String, String>();
        for (String key : list) {
            keyValueBackup.put(key, this.get(profileName, key));
            properties.remove(key);
        }
        try {
            this.write2File(profileName, properties);
        }
        catch (IOException e) {
            for (Map.Entry kvb : keyValueBackup.entrySet()) {
                properties.setProperty((String)kvb.getKey(), (String)kvb.getValue());
            }
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            throw new HorizonException();
        }
    }

    public void set(String profileName, String key, String value) {
        CommentedProperties properties = this.getProperties(profileName);
        String valueBackup = this.get(profileName, key);
        properties.setProperty(key, value);
        try {
            this.write2File(profileName, properties);
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            properties.setProperty(key, valueBackup);
            throw new HorizonException();
        }
    }

    public void set(String profileName, String key, String value, String comment) {
        CommentedProperties properties = this.getProperties(profileName);
        String valueBackup = this.get(profileName, key);
        String commentBackup = this.getComment(profileName, key);
        String tempComment = BLANK;
        properties.setProperty(key, value);
        try {
            this.write2File(profileName, properties);
            tempComment = comment;
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            properties.setProperty(key, valueBackup);
            tempComment = commentBackup;
            throw new HorizonException();
        }
        if (BLANK.equals(tempComment)) {
            if (!this.keyCommentMap.containsKey(key)) {
                this.keyCommentMap.put(key, tempComment);
            }
        } else {
            this.keyCommentMap.put(key, tempComment);
        }
    }

    public void set(String profileName, Map<String, String> keyValue) {
        CommentedProperties properties = this.getProperties(profileName);
        HashMap<String, String> keyValueBackup = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : keyValue.entrySet()) {
            keyValueBackup.put(kv.getKey(), this.get(profileName, kv.getKey()));
            properties.setProperty(kv.getKey(), kv.getValue());
        }
        try {
            this.write2File(profileName, properties);
        }
        catch (IOException e) {
            LOGGER.info("\u4fee\u6539\u5931\u8d25");
            for (Map.Entry kvb : keyValueBackup.entrySet()) {
                properties.setProperty((String)kvb.getKey(), (String)kvb.getValue());
            }
            throw new HorizonException();
        }
    }

    public String getComment(String profileName, String key) {
        CommentedProperties properties = this.getProperties(profileName);
        if (properties == null) {
            return null;
        }
        return this.keyCommentMap.get(key);
    }

    public String get(String profileName, String key) {
        CommentedProperties properties = this.getProperties(profileName);
        if (properties == null) {
            return null;
        }
        return properties.getProperty(key);
    }

    private CommentedProperties getProperties(String profileName) {
        return this.profilePool.get(profileName);
    }

    public Properties getProfile(String profileName) {
        CommentedProperties properties = this.getProperties(profileName);
        if (properties == null) {
            return null;
        }
        return properties.getProps();
    }

    private void write2File(String profileName, CommentedProperties properties) throws IOException {
        String filename = profileName + ".properties";
        FileOutputStream oFile = null;
        OutputStream sFile = null;
        try {
            if (!BLANK.equals(this.resourceFolder)) {
                filename = this.resourceFolder + filename;
                oFile = new FileOutputStream(filename);
                properties.store(oFile);
            } else {
                sFile = this.streamUtil.getOutPutStream(filename);
                properties.store(sFile);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (oFile != null) {
                oFile.close();
            }
            if (sFile != null) {
                sFile.close();
            }
        }
    }

    private void write2FileNoEscape(String profileName, CommentedProperties properties) throws IOException {
        String filename = profileName + ".properties";
        FileOutputStream oFile = null;
        OutputStream sFile = null;
        try {
            if (!BLANK.equals(this.resourceFolder)) {
                filename = this.resourceFolder + filename;
                oFile = new FileOutputStream(filename);
                properties.store(oFile, false);
            } else {
                sFile = this.streamUtil.getOutPutStream(filename);
                properties.store(sFile, false);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (oFile != null) {
                oFile.close();
            }
            if (sFile != null) {
                sFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCopyResource() {
        String filename = "horizon.properties";
        try {
            Resource resource = resolver.getResources("classpath*:workflow-conf/properties/" + filename)[0];
            InputStream is = null;
            CommentedProperties commentedProperties = null;
            try {
                is = resource.getInputStream();
                commentedProperties = new CommentedProperties(new Properties());
                commentedProperties.load(is, "UTF-8");
                this.resourceFolder = commentedProperties.getProperty("horizon.home");
                String product = commentedProperties.getProperty("product");
                if (BLANK.equals(this.resourceFolder)) {
                    File file = new File(System.getProperty("user.home"));
                    this.resourceFolder = file.getCanonicalPath();
                }
                this.resourceFolder = this.resourceFolder + File.separator + product + "/properties" + File.separator;
            }
            catch (IOException ex) {
                LOGGER.error("Could not load properties ", (Object)ex.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOGGER.info("InputStream not close: " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not load properties ", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecourseFromJar(String filename) {
        block11: {
            String newfilename;
            File file;
            File dir = new File(this.resourceFolder);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ((file = new File(newfilename = this.resourceFolder + filename)).exists()) {
                return;
            }
            try {
                if (!file.createNewFile()) {
                    LOGGER.error("create file :{} failed", (Object)newfilename);
                    return;
                }
                byte[] buffer = new byte[1024];
                Resource[] resources = resolver.getResources("classpath*:workflow-conf/properties/" + filename);
                if (resources.length <= 0) {
                    LOGGER.debug("file is not found!");
                    break block11;
                }
                Resource resource = resources[0];
                InputStream is = resource.getInputStream();
                if (is == null) {
                    throw new FileNotFoundException("File " + filename + " was not found inside JAR.");
                }
                FileOutputStream os = new FileOutputStream(file);
                try {
                    int readBytes;
                    while ((readBytes = is.read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, readBytes);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                    is.close();
                }
            }
            catch (Exception var8) {
                LOGGER.debug("Error copying file :" + var8.getMessage());
            }
        }
    }

    private static class SingletonHolder {
        private static final ProfileContext instance = new ProfileContext();

        private SingletonHolder() {
        }
    }
}

