/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.profile;

import com.horizon.profile.api.ProfileContext;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AppConfig {
    private static ProfileContext getContext() {
        return ProfileContext.newInstance();
    }

    public static String getComment(String profileName, String key) {
        return AppConfig.getContext().getComment(profileName, key);
    }

    public static String get(String profileName, String key) {
        return AppConfig.getContext().get(profileName, key);
    }

    public static Integer getInteger(String profileName, String key) {
        String value = AppConfig.get(profileName, key);
        if (AppConfig.hasValue(value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public static Double getDouble(String profileName, String key) {
        String value = AppConfig.get(profileName, key);
        if (AppConfig.hasValue(value)) {
            return Double.parseDouble(value);
        }
        return null;
    }

    public static Float getFloat(String profileName, String key) {
        String value = AppConfig.get(profileName, key);
        if (AppConfig.hasValue(value)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return null;
    }

    public static Long getLong(String profileName, String key) {
        String value = AppConfig.get(profileName, key);
        if (AppConfig.hasValue(value)) {
            return Long.parseLong(value);
        }
        return null;
    }

    public static Boolean getBoolean(String profileName, String key) {
        String value = AppConfig.get(profileName, key);
        return AppConfig.hasValue(value) ? Boolean.parseBoolean(value) : false;
    }

    public static String[] getArray(String profileName, String key) {
        return AppConfig.getArray(profileName, key, ",");
    }

    public static String[] getArray(String profileName, String key, String regularly) {
        String value = AppConfig.get(profileName, key);
        return value.split(regularly);
    }

    public static void delete(String profileName, String key) {
        AppConfig.getContext().delete(profileName, key);
    }

    public static void delete(String profileName, List<String> list) {
        AppConfig.getContext().delete(profileName, list);
    }

    public static void add(String profileName, String key, String value) {
        AppConfig.getContext().set(profileName, key, value);
    }

    public static void add(String profileName, String key, String value, String comment) {
        AppConfig.getContext().set(profileName, key, value, comment);
    }

    public static void add(String profileName, Map<String, String> keyValue) {
        AppConfig.getContext().set(profileName, keyValue);
    }

    public static void modify(String profileName, Map<String, String> keyValue) {
        AppConfig.getContext().modify(profileName, keyValue);
    }

    public static void modify(String profileName, String key, String value) {
        AppConfig.getContext().modify(profileName, key, value);
    }

    public static void modify(String profileName, String key, String value, String comment) {
        AppConfig.getContext().modify(profileName, key, value, comment);
    }

    public static Properties getProfile(String profileName) {
        return AppConfig.getContext().getProfile(profileName);
    }

    public static boolean hasValue(String value) {
        return value != null && value.trim().length() > 0;
    }
}

