/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.message.jms;

import com.horizon.message.jms.JmsReceiver;
import com.horizon.message.jms.entity.JmsConnect;
import com.horizon.message.jms.properties.JmpProperties;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSupport
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JmsSupport.class);
    public static QueueConnection connection = null;
    public static QueueSession session = null;
    public static Queue queue = null;

    public JmsSupport() {
        String initialContextFactory = JmpProperties.getJmsPropsVlaue("initialContextFactory");
        String providerUrl = JmpProperties.getJmsPropsVlaue("providerUrl");
        String queueName = JmpProperties.getJmsPropsVlaue("queueName");
        String securityPrincipal = JmpProperties.getJmsPropsVlaue("securityPrincipal");
        String securityCredentials = JmpProperties.getJmsPropsVlaue("securityCredentials");
        String isReceiver = JmpProperties.getJmsPropsVlaue("isReceiver");
        JmsConnect jmsConnect = new JmsConnect();
        jmsConnect.setInitialContextFactory(initialContextFactory);
        jmsConnect.setProviderUrl(providerUrl);
        jmsConnect.setQueueName(queueName);
        jmsConnect.setSecurityPrincipal(securityPrincipal);
        jmsConnect.setSecurityCredentials(securityCredentials);
        jmsConnect.setIsReceiver(isReceiver);
        connection = JmsSupport.createJmsConnection(jmsConnect);
        session = JmsSupport.getSession(connection);
        queue = JmsSupport.getQueue(jmsConnect.getQueueName());
        JmsSupport.startJmsListener(jmsConnect);
    }

    public static QueueConnection createJmsConnection(JmsConnect jmsConnect) {
        QueueConnection tempConnection = null;
        try {
            Properties JMSProperties = new Properties();
            JMSProperties.put("java.naming.factory.initial", jmsConnect.getInitialContextFactory());
            JMSProperties.put("java.naming.provider.url", jmsConnect.getProviderUrl());
            JMSProperties.put("java.naming.security.principal", jmsConnect.getSecurityPrincipal());
            JMSProperties.put("java.naming.security.credentials", jmsConnect.getSecurityCredentials());
            InitialContext JMSContext = new InitialContext(JMSProperties);
            QueueConnectionFactory factory = (QueueConnectionFactory)JMSContext.lookupLink("QueueConnectionFactory");
            tempConnection = factory.createQueueConnection(jmsConnect.getSecurityPrincipal(), jmsConnect.getSecurityCredentials());
            try {
                tempConnection.start();
            }
            catch (JMSException e) {
                logger.error("JMS \u4e0a\u4e0b\u6587\u542f\u52a8\u5931\u8d25 " + (Object)((Object)e));
            }
        }
        catch (NamingException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316\u4e0a\u4e0b\u6587\u5931\u8d25 " + e);
        }
        catch (JMSException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316\u8fde\u63a5\u5de5\u5382\u5931\u8d25" + (Object)((Object)e));
        }
        return tempConnection;
    }

    public static QueueConnection getConnection(JmsConnect jmsConnect) {
        QueueConnection tempConnection = null;
        tempConnection = JmsSupport.createJmsConnection(jmsConnect);
        return tempConnection;
    }

    public static QueueConnection getConnection() {
        return connection;
    }

    public static QueueSession getSession(QueueConnection queueConnection) {
        QueueSession queueSession = null;
        try {
            if (null != queueConnection) {
                queueSession = queueConnection.createQueueSession(false, 1);
            }
        }
        catch (JMSException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316session\u5931\u8d25" + (Object)((Object)e));
        }
        return queueSession;
    }

    public static QueueSession getSession() {
        try {
            if (null == session) {
                session = connection.createQueueSession(false, 1);
            }
        }
        catch (JMSException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316session\u5931\u8d25" + (Object)((Object)e));
        }
        return session;
    }

    public static Queue getQueue(QueueSession queueSession, String queueName) {
        Queue tempQueue = null;
        try {
            tempQueue = queueSession.createQueue(queueName);
        }
        catch (JMSException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316\u6d88\u606f\u961f\u5217\u5931\u8d25" + (Object)((Object)e));
        }
        return tempQueue;
    }

    public static Queue getQueue(String queueName) {
        Queue tempQueue = null;
        try {
            tempQueue = session.createQueue(queueName);
        }
        catch (JMSException e) {
            logger.error("JMS \u5b9e\u4f8b\u5316\u6d88\u606f\u961f\u5217\u5931\u8d25" + (Object)((Object)e));
        }
        return tempQueue;
    }

    public static Queue getQueue() {
        return queue;
    }

    public static void startJmsListener(JmsConnect jmsConnect) {
        if ("on".equals(jmsConnect.getIsReceiver())) {
            JmsReceiver jmsReceiver = new JmsReceiver();
            jmsReceiver.messageReceiver(jmsConnect);
        }
    }
}

