/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.message.jms;

import com.horizon.message.jms.JmsSupport;
import com.horizon.message.jms.converter.SimpleMessageConverter;
import com.horizon.message.jms.entity.JmsConnect;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSender {
    private static Logger logger = LoggerFactory.getLogger((String)"JmsSender");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(JmsConnect jmsConnect, Object messageObj) {
        QueueConnection connection = JmsSupport.createJmsConnection(jmsConnect);
        QueueSession queueSession = JmsSupport.getSession(connection);
        Queue queue = JmsSupport.getQueue(queueSession, jmsConnect.getQueueName());
        QueueSender sender = null;
        try {
            sender = queueSession.createSender(queue);
            SimpleMessageConverter messageConverter = new SimpleMessageConverter();
            Message message = messageConverter.toMessage(messageObj, (Session)queueSession);
            sender.send(message);
        }
        catch (JMSException e) {
            logger.error("JMS\u6d88\u606f\u53d1\u9001\u8fde\u63a5\u5931\u8d25" + (Object)((Object)e));
        }
        finally {
            JmsSender.closeQueueSender(sender);
            JmsSender.closeQueueSession(queueSession);
            JmsSender.closeQueueConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String queueName, Object messageObj) {
        QueueSession queueSession = JmsSupport.getSession();
        Queue queue = null != queueName && !"".equals(queueName) ? JmsSupport.getQueue(queueName) : JmsSupport.getQueue();
        QueueSender sender = null;
        try {
            sender = queueSession.createSender(queue);
            SimpleMessageConverter messageConverter = new SimpleMessageConverter();
            Message message = messageConverter.toMessage(messageObj, (Session)queueSession);
            sender.send(message);
        }
        catch (JMSException e) {
            logger.error("JMS\u6d88\u606f\u53d1\u9001\u8fde\u63a5\u5931\u8d25" + (Object)((Object)e));
        }
        finally {
            JmsSender.closeQueueSender(sender);
        }
    }

    public static void sendMessage(Object messageObj) {
        JmsSender.sendMessage("", messageObj);
    }

    private static void closeQueueSession(QueueSession queueSession) {
        if (null != queueSession) {
            try {
                queueSession.close();
            }
            catch (JMSException e) {
                logger.error("JMS\u8fde\u63a5Session\u8d44\u6e90\u91ca\u653e\u5931\u8d25" + (Object)((Object)e));
            }
        }
    }

    private static void closeQueueConnection(QueueConnection connection) {
        if (null != connection) {
            try {
                connection.close();
            }
            catch (JMSException e) {
                logger.error("JMS\u94fe\u63a5\u8d44\u6e90\u91ca\u653e\u5931\u8d25" + (Object)((Object)e));
            }
        }
    }

    private static void closeQueueSender(QueueSender sender) {
        if (null != sender) {
            try {
                sender.close();
            }
            catch (JMSException e) {
                logger.error("JMS\u6d88\u606f\u53d1\u9001\u8fde\u63a5\u91ca\u653e\u5931\u8d25" + (Object)((Object)e));
            }
        }
    }
}

