/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.message.jms;

import com.horizon.message.jms.JmpMessageProcessFactory;
import com.horizon.message.jms.JmsSupport;
import com.horizon.message.jms.converter.MessageConverter;
import com.horizon.message.jms.converter.SimpleMessageConverter;
import com.horizon.message.jms.entity.FlowMessage;
import com.horizon.message.jms.entity.JmsConnect;
import com.horizon.message.jms.properties.JmpProperties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsReceiver
extends Thread
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JmsReceiver.class);
    private MessageConverter messageConverter;
    private static String className = JmpProperties.getJmsPropsVlaue("queueReceiverClass");

    public void messageReceiver(JmsConnect jmsConnect) {
        QueueConnection connection = JmsSupport.createJmsConnection(jmsConnect);
        QueueSession queueSession = JmsSupport.getSession(connection);
        QueueReceiver consumer = null;
        try {
            Queue queue = queueSession.createQueue(jmsConnect.getQueueName());
            consumer = queueSession.createReceiver(queue);
            logger.info("start jms listener.....");
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            logger.error("JMS\u521b\u5efa\u6d88\u606f\u63a5\u6536\u8fde\u63a5\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public void messageReceiver(String queueName) {
        QueueSession queueSession = JmsSupport.getSession();
        QueueReceiver consumer = null;
        try {
            Queue queue = queueSession.createQueue(queueName);
            consumer = queueSession.createReceiver(queue);
            logger.info("start jms listener.....");
            consumer.setMessageListener((MessageListener)this);
        }
        catch (JMSException e) {
            logger.error("JMS\u521b\u5efa\u6d88\u606f\u63a5\u6536\u8fde\u63a5\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public void onMessage(Message message) {
        try {
            this.messageConverter = new SimpleMessageConverter();
            Object messageObj = this.messageConverter.fromMessage(message);
            String classUrl = this.getClassUrl(messageObj);
            JmpMessageProcessFactory.getInstance(classUrl).doMsgProcess(messageObj);
        }
        catch (JMSException e) {
            logger.error("JMS\u6d88\u606f\u63a5\u6536\u5904\u7406\u5931\u8d25" + (Object)((Object)e));
        }
    }

    private String getClassUrl(Object messageObj) {
        String classUrl = null;
        try {
            FlowMessage messageEntity = (FlowMessage)messageObj;
            classUrl = messageEntity.getDoWithClass();
        }
        catch (Exception e) {
            logger.error("JMS\u6d88\u606f\u5bf9\u8c61\u8f6cMessageEntity\u5931\u8d25" + e);
        }
        if (null == classUrl || "".equals(classUrl)) {
            classUrl = className;
        }
        return classUrl;
    }
}

