/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.language;

import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18nContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageUtil {
    private static final Logger logger = LoggerFactory.getLogger(LanguageUtil.class);
    private static final String PROPERTIES = ".properties";

    private LanguageUtil() {
    }

    public static void reloadLanguage() {
        try {
            Map<String, String> nameReplace = LanguageUtil.getLanguageProperties("com/horizon/language");
            Collection<String> names = nameReplace.values();
            Hi18nContext.newInstance().reload();
            Hi18nContext.newInstance().setBaseNames(names.toArray(new String[names.size()]));
            Hi18nContext.newInstance().setSortNames(nameReplace);
            logger.info("\u56fd\u9645\u5316\u8bed\u8a00\u6587\u4ef6\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (IOException e1) {
            logger.error("\u56fd\u9645\u5316\u8bed\u8a00\u6587\u4ef6\u521d\u59cb\u5316\u5931\u8d25:" + e1.getMessage());
        }
    }

    public static Map<String, String> getLanguageProperties(String packageDirName) throws IOException {
        HashMap nameReplace = Maps.newHashMap();
        boolean recursive = true;
        Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        while (dirs.hasMoreElements()) {
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                logger.debug("file\u7c7b\u578b\u7684\u626b\u63cf:" + url);
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                LanguageUtil.findAndAddPropertiesInPackageByFile(packageDirName, filePath, recursive, nameReplace);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            logger.debug("jar\u7c7b\u578b\u7684\u626b\u63cf:" + url);
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            if (!jar.getName().contains("horizon-language")) continue;
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String key;
                String baseName;
                JarEntry entry = entries.nextElement();
                String fileName = entry.getName();
                String prefix = "com/horizon/language";
                String en_prefix = "com/horizon/language/en";
                if (!fileName.endsWith(PROPERTIES)) continue;
                if (fileName.startsWith(prefix) && !fileName.startsWith(en_prefix)) {
                    baseName = fileName.substring(0, fileName.indexOf(PROPERTIES));
                    key = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.indexOf(PROPERTIES));
                    nameReplace.put(key, baseName);
                    continue;
                }
                if (!fileName.startsWith(en_prefix)) continue;
                baseName = fileName.substring(0, fileName.indexOf(PROPERTIES));
                key = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.indexOf(PROPERTIES)) + "_en";
                nameReplace.put(key, baseName);
            }
        }
        return nameReplace;
    }

    public static void findAndAddPropertiesInPackageByFile(String packageName, String packagePath, final boolean recursive, Map<String, String> nameReplace) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(LanguageUtil.PROPERTIES);
            }
        })) {
            if (file.isDirectory()) {
                LanguageUtil.findAndAddPropertiesInPackageByFile(packageName + "/" + file.getName(), file.getAbsolutePath(), recursive, nameReplace);
                continue;
            }
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.indexOf(PROPERTIES));
            nameReplace.put(fileName, packageName + "/" + fileName);
        }
    }
}

