/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.language;

import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18nClassLoader;
import com.horizon.language.Hi18nMessageSource;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class Hi18nContext {
    private static final Logger logger = LoggerFactory.getLogger(Hi18nContext.class);
    private Hi18nMessageSource hzResourceBunldle = new Hi18nMessageSource();
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    private Map<String, String> sortNames = Maps.newHashMap();
    private static final String FILE_PATH = "com/horizon/language/";
    private static final String EN_FILE_PATH = "com/horizon/language/en/";

    public static Hi18nContext newInstance() {
        return SingletonHolder.instance;
    }

    public Map<String, String> getLanguage(String groupName) {
        String realGroup = this.getRealPath(groupName);
        if (!StringUtil.hasValue(realGroup)) {
            boolean isEnglish = "en".equalsIgnoreCase(this.getDefLocaleKey());
            String filePath = isEnglish ? EN_FILE_PATH : FILE_PATH;
            realGroup = filePath + groupName;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ResourceBundle rbmessage = this.hzResourceBunldle.getResourceBundle(realGroup, this.getDefLocale());
        if (rbmessage != null) {
            Enumeration<String> keys = rbmessage.getKeys();
            while (keys.hasMoreElements()) {
                String keyTemp = keys.nextElement();
                try {
                    map.put(keyTemp, rbmessage.getString(keyTemp));
                }
                catch (Exception e) {
                    map.put(keyTemp, "");
                }
            }
        }
        return map;
    }

    public String getVal(String groupName, String key) {
        ResourceBundle rbmessage;
        String realGroup = this.getRealPath(groupName);
        if (!StringUtil.hasValue(realGroup)) {
            String filePath = "en".equalsIgnoreCase(this.getDefLocaleKey()) ? EN_FILE_PATH : FILE_PATH;
            realGroup = filePath + groupName;
        }
        if ((rbmessage = this.hzResourceBunldle.getResourceBundle(realGroup, this.getDefLocale())) != null) {
            try {
                return rbmessage.getString(key);
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public String getVal(String key) {
        try {
            return this.hzResourceBunldle.getMessage(key, null, this.getDefLocale());
        }
        catch (NoSuchMessageException e) {
            return "";
        }
    }

    public List<Locale> getLocaleList() {
        ArrayList<Locale> languagePool = new ArrayList<Locale>();
        List<String> localeList = Hi18nClassLoader.newInstanse().getLocals();
        for (String localeString : localeList) {
            Locale locale = null;
            if (localeString.contains("_")) {
                String[] split = localeString.split("_");
                locale = new Locale(split[0], split[1]);
            } else {
                locale = new Locale(localeString);
            }
            languagePool.add(locale);
        }
        return languagePool;
    }

    public void reload() {
        this.hzResourceBunldle = new Hi18nMessageSource();
    }

    public void setBaseNames(String ... baseNames) {
        this.hzResourceBunldle.setBasenames(baseNames);
    }

    public Locale getDefLocale() {
        String localeString = this.getDefLocaleKey();
        Locale locale = null;
        if (localeString.contains("_")) {
            String[] split = localeString.split("_");
            locale = new Locale(split[0], split[1]);
        } else {
            locale = new Locale(localeString);
        }
        return locale;
    }

    public String getDefLocaleKey() {
        return AppConfig.get("horizon", "localeVal");
    }

    public void setSortNames(Map<String, String> nameReplace) {
        this.sortNames = nameReplace;
    }

    private String getRealPath(String groupName) {
        String key;
        boolean isEnglish = "en".equalsIgnoreCase(this.getDefLocaleKey());
        String string = key = isEnglish ? groupName + "_en" : groupName;
        if (this.sortNames.containsKey(key)) {
            return this.sortNames.get(key);
        }
        String filePath = isEnglish ? EN_FILE_PATH : FILE_PATH;
        try {
            Resource[] resources = this.resolver.getResources("classpath*:" + filePath + "**/" + groupName + ".properties");
            if (resources.length <= 0) {
                this.sortNames.put(key, filePath + groupName);
            } else {
                for (Resource resource : resources) {
                    String url = resource.getURL().toString();
                    if (!isEnglish && url.contains(EN_FILE_PATH) || isEnglish && !url.contains(EN_FILE_PATH)) continue;
                    url = url.substring(url.indexOf(filePath), url.indexOf(".properties"));
                    this.sortNames.put(key, url);
                    return url;
                }
            }
        }
        catch (Exception e) {
            logger.debug("\u5bfb\u627e\u56fd\u9645\u5316\u6587\u4ef6\u51fa\u9519:" + e.getMessage());
        }
        return filePath + groupName;
    }

    private static class SingletonHolder {
        static volatile Hi18nContext instance = new Hi18nContext();

        private SingletonHolder() {
        }
    }
}

