/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.language;

import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.utils.ServletContextUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.ClassUtils;

public class Hi18nClassLoader
extends URLClassLoader {
    private static Hi18nClassLoader loader;
    private Map<String, JarURLConnection> connections = Maps.newLinkedHashMap();
    private Pattern pattern = Pattern.compile(".*_(.+)\\.properties");

    public Hi18nClassLoader(Map<String, URL> localUrls) {
        super(localUrls.values().toArray(new URL[localUrls.values().size()]), Hi18nClassLoader.class.getClassLoader());
        for (Map.Entry<String, URL> entry : localUrls.entrySet()) {
            try {
                this.connections.put(entry.getKey(), (JarURLConnection)entry.getValue().openConnection());
            }
            catch (IOException e) {}
        }
    }

    public static Hi18nClassLoader newInstanse() {
        if (loader == null) {
            String basePath = ServletContextUtil.getRealPath("/WEB-INF/lib");
            File baseFile = new File(basePath);
            File[] files = baseFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String pathName = pathname.getName();
                    return pathName.startsWith("language") && pathName.endsWith(".jar");
                }
            });
            LinkedHashMap localUrls = Maps.newLinkedHashMap();
            if (files != null && files.length > 0) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    String jarUrl = "jar:" + file.toURI().toString() + "!/";
                    String name = file.getName();
                    try {
                        String key = name.substring(name.indexOf("_") + 1, name.indexOf(".jar"));
                        localUrls.put(key, new URL(jarUrl));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            } else {
                try {
                    ClassLoader defaultClassLoader = ClassUtils.getDefaultClassLoader();
                    boolean isJar = "jar".equals(defaultClassLoader.getResource("").getProtocol());
                    Enumeration<URL> dirs = defaultClassLoader.getResources("com/horizon/language");
                    while (dirs.hasMoreElements()) {
                        String jarName;
                        String pathName;
                        URL url = dirs.nextElement();
                        String protocol = url.getProtocol();
                        if (!"jar".equals(protocol) || !(pathName = url.getPath().replace("!/com/horizon/language", "")).endsWith(".jar") || !(jarName = pathName.substring(pathName.lastIndexOf(47) + 1)).startsWith("language")) continue;
                        String key = jarName.substring(jarName.lastIndexOf("_") + 1, jarName.lastIndexOf(".jar"));
                        String jarUrl = isJar ? pathName : "jar:" + pathName;
                        jarUrl = jarUrl + "!/";
                        localUrls.put(key, new URL(jarUrl));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            loader = new Hi18nClassLoader(localUrls);
        }
        return loader;
    }

    public void remove() {
        for (JarURLConnection jarURLConnection : this.connections.values()) {
            try {
                jarURLConnection.getJarFile().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        loader = null;
    }

    @Override
    public URL getResource(String name) {
        String local;
        JarURLConnection conn;
        Matcher matcher = this.pattern.matcher(name);
        if (matcher.matches() && (conn = this.connections.get(local = matcher.group(1))) != null) {
            try {
                URL url = new URL(conn.getURL().toExternalForm() + name.substring(0, name.indexOf("_")) + ".properties");
                url.openStream();
                return url;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return super.getResource(name);
    }

    public List<String> getLocals() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"zh_CN", "en"});
        list.addAll(this.connections.keySet());
        return list;
    }
}

