/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private StreamUtil() {
    }

    public static void exchangeStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        StreamUtil.exchangeStream(inputStream, outputStream, 8192);
    }

    public static void exchangeStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        if (inputStream == null) {
            return;
        }
        if (outputStream == null) {
            return;
        }
        if (bufferSize < 0) {
            bufferSize = 8192;
        }
        InputStream input = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        OutputStream output = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        int endCondition = -1;
        byte[] tmpBuffer = new byte[bufferSize];
        int readSize = input.read(tmpBuffer);
        while (readSize > -1) {
            output.write(tmpBuffer, 0, readSize);
            readSize = input.read(tmpBuffer);
        }
        output.flush();
        output.close();
        input.close();
    }

    public static byte encodeByte(byte e) {
        byte a = (byte)(e ^ 0x9F);
        int b1 = a << 4 & 0xF0;
        int b2 = a >>> 4 & 0xF;
        byte c = (byte)(b1 + b2);
        return c;
    }

    public static byte decodeByte(byte e) {
        byte a = e;
        int b1 = a << 4 & 0xF0;
        int b2 = a >>> 4 & 0xF;
        byte c = (byte)(b1 + b2);
        byte d = (byte)(0x9F ^ c);
        return d;
    }
}

