/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file.service.impl;

import com.horizon.file.service.FileNameGenerator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;
import org.springframework.stereotype.Service;

@Service
public class FileNameGeneratorImpl
implements FileNameGenerator {
    private Random random = new Random();
    private DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static int counter = 1;
    final String strFormat = "000000";

    @Override
    public String generateFileName() {
        return this.generateFileName(null);
    }

    @Override
    public String generateFileName(String prefixFileName) {
        StringBuffer buf = new StringBuffer();
        if (prefixFileName != null && prefixFileName.trim().length() > 0) {
            prefixFileName = prefixFileName.trim();
            buf.append(prefixFileName);
        }
        String curTime = this.getPrefixTime();
        buf.append(curTime);
        String suffixRandom = this.getSuffixRandom();
        buf.append(suffixRandom);
        return buf.toString();
    }

    @Override
    public String[] generateFileName(int fileNameNumber) {
        return this.generateFileName(fileNameNumber, null);
    }

    @Override
    public String[] generateFileName(int fileNameNumber, String prefixFileName) {
        if (fileNameNumber <= 0) {
            return null;
        }
        if (fileNameNumber == 1) {
            String[] fileNames = new String[]{this.generateFileName(prefixFileName)};
            return fileNames;
        }
        StringBuffer sbTempFileName = new StringBuffer(20);
        if (prefixFileName != null && prefixFileName.trim().length() > 0) {
            sbTempFileName.append(prefixFileName.trim());
        }
        sbTempFileName.append(this.getPrefixTime());
        int prefixTimeLen = sbTempFileName.length();
        int generalNumber = 0;
        HashMap<String, String> mFilterRepeatFileName = new HashMap<String, String>(fileNameNumber);
        while (generalNumber < fileNameNumber) {
            String suffixRandom = this.getSuffixRandom();
            sbTempFileName.append(suffixRandom);
            String fileName = sbTempFileName.toString();
            sbTempFileName.delete(prefixTimeLen, sbTempFileName.length());
            if (mFilterRepeatFileName.containsKey(fileName)) continue;
            ++generalNumber;
            mFilterRepeatFileName.put(fileName, fileName);
        }
        String[] fileNames = new String[fileNameNumber];
        mFilterRepeatFileName.keySet().toArray(fileNames);
        mFilterRepeatFileName.clear();
        return fileNames;
    }

    protected String format(int iValue) {
        String strValue = Integer.toHexString(iValue);
        StringBuffer buf = new StringBuffer("000000");
        buf.replace("000000".length() - strValue.length(), "000000".length(), strValue);
        return buf.toString();
    }

    private String getPrefixTime() {
        String curTime = this.dateFormat.format(new Date());
        return curTime;
    }

    private String getSuffixRandom() {
        String suffix = this.format(Math.abs(this.random.nextInt(1000000)) + counter++);
        return suffix;
    }

    public static void main(String[] args) {
        FileNameGeneratorImpl fileNameGenerator = new FileNameGeneratorImpl();
        System.out.println("1 FileName: " + fileNameGenerator.generateFileName());
        System.out.println("2 FileName: " + fileNameGenerator.generateFileName("ar"));
        long startMills = System.currentTimeMillis();
        int testSize = 1000;
        String[] fileNames = fileNameGenerator.generateFileName(testSize, "aaar_");
        System.out.println("\u4ea7\u751f\u6587\u4ef6\u540d\u6240\u6d88\u8017\u65f6\u95f4: " + (System.currentTimeMillis() - startMills));
        for (int i = 0; i < testSize; ++i) {
            System.out.println(i + "\tfileName: " + fileNames[i]);
        }
    }
}

