/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file.service.impl;

import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.core.HorizonCore;
import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.file.AttachmentUtil;
import com.horizon.file.entity.FileState;
import com.horizon.file.entity.StorageAttachment;
import com.horizon.file.service.FileNameGenerator;
import com.horizon.file.service.IAttachmentService;
import com.horizon.file.util.FileInfo;
import com.horizon.file.util.HorizonFileInputSteam;
import com.horizon.file.util.HorizonFileOutputStream;
import com.horizon.file.util.StreamUtil;
import com.horizon.utils.DateUtil;
import com.horizon.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AttachmentServiceImpl
implements IAttachmentService {
    @Autowired
    private FileNameGenerator fileNameGen;

    @Override
    public List<FileState> uploadFile(String userId, String maxSize, Iterator<String> iterator, MultiValueMap<String, MultipartFile> multiValueMap) throws IOException {
        return this.uploadFile(userId, maxSize, iterator, multiValueMap, null);
    }

    @Override
    public List<FileState> uploadFile(String userId, String maxSize, Iterator<String> iterator, MultiValueMap<String, MultipartFile> multiValueMap, String saveType) throws IOException {
        return this.uploadFile(userId, maxSize, null, iterator, multiValueMap, saveType);
    }

    @Override
    public List<FileState> uploadFile(String userId, String maxSize, String objectId, Iterator<String> iterator, MultiValueMap<String, MultipartFile> multiValueMap) throws IOException {
        return this.uploadFile(userId, maxSize, objectId, iterator, multiValueMap, null);
    }

    @Override
    public List<FileState> uploadFile(String userId, String maxSize, String objectId, Iterator<String> iterator, MultiValueMap<String, MultipartFile> multiValueMap, String saveType) throws IOException {
        ArrayList resultList = Lists.newArrayList();
        while (iterator.hasNext()) {
            List fileList = (List)multiValueMap.get((Object)iterator.next());
            ArrayList storageFile = Lists.newArrayList();
            boolean checkSize = true;
            maxSize = StringUtil.hasValue(maxSize) ? maxSize : FileInfo.getMaxSize();
            String fileFormats = FileInfo.getAllowableExtensions();
            for (MultipartFile file : fileList) {
                boolean isContainFormats;
                long fileSize = file.getSize();
                String fileName = file.getOriginalFilename();
                if (StringUtil.hasValue(maxSize) && fileSize > Long.parseLong(maxSize)) {
                    FileState fileState = new FileState();
                    fileState.setFileName(fileName);
                    fileState.setState("checkSizeError");
                    fileState.setMessage("\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u8bbe\u7f6e\u503c");
                    fileState.setFileSize(String.valueOf(fileSize));
                    resultList.add(fileState);
                    checkSize = false;
                    break;
                }
                int pos = fileName.lastIndexOf(".");
                boolean bl = isContainFormats = pos >= 0 && StringUtil.hasValue(fileFormats) && fileFormats.contains(fileName.substring(pos + 1));
                if (!isContainFormats) {
                    FileState fileState = new FileState();
                    fileState.setState("checkFormatError");
                    fileState.setMessage("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5141\u8bb8\u4e0a\u4f20");
                    fileState.setFileName(fileName);
                    fileState.setFileSize(String.valueOf(fileSize));
                    resultList.add(fileState);
                    checkSize = false;
                    break;
                }
                StorageAttachment sa = this.createStorageAttachment(file, userId, objectId, saveType);
                storageFile.add(sa);
                if ("1".equals(FileInfo.getSaveType()) || "1".equals(saveType)) {
                    this.setStorageBlob(file, sa);
                } else {
                    File fileDir = new File(sa.getSavePath());
                    if (!fileDir.exists()) {
                        fileDir.mkdirs();
                    }
                    File targetFile = new File(sa.getSavePath(), sa.getSaveName() + "." + sa.getExtention());
                    if (Objects.equal((Object)"true", (Object)FileInfo.getNeedEncode())) {
                        StreamUtil.exchangeStream(file.getInputStream(), new HorizonFileOutputStream(new FileOutputStream(targetFile)));
                    } else {
                        file.transferTo(targetFile);
                    }
                }
                FileState fileState = new FileState();
                fileState.setFileId(sa.getId());
                fileState.setFileName(sa.getFullFileName());
                fileState.setFileSize(String.valueOf(fileSize));
                fileState.setState("success");
                fileState.setFieldName(sa.getFieldName());
                resultList.add(fileState);
            }
            if (!checkSize) break;
            ArrayList<StorageAttachment[]> lstStorageAttachments = new ArrayList<StorageAttachment[]>();
            lstStorageAttachments.add(storageFile.toArray(new StorageAttachment[storageFile.size()]));
            AttachmentUtil.saveAttachment(lstStorageAttachments, HorizonCore.TENANT_IDENTIFIER.value());
        }
        return resultList;
    }

    @Override
    public StorageAttachment getFileInfo(String fileId) {
        StorageBlob blob;
        StorageAttachment fileResult = AttachmentUtil.getStorageAttachmentAndContent(fileId, HorizonCore.TENANT_IDENTIFIER.value());
        if (Objects.equal((Object)"true", (Object)FileInfo.getNeedEncode()) && (blob = fileResult.getStorageBlob()) != null && blob.getContent() != null) {
            blob.setContent(new HorizonFileInputSteam(blob.getContent()));
        }
        return fileResult;
    }

    private StorageAttachment createStorageAttachment(MultipartFile file, String userId) {
        String filedName = file.getName();
        filedName = filedName.replace(filedName.split("_")[0] + "_", "");
        String fileName = file.getOriginalFilename();
        String fileId = Access.getUUID();
        String newFileName = this.fileNameGen.generateFileName("hz");
        int pos = fileName.lastIndexOf(".");
        String type = pos == -1 ? "" : fileName.substring(pos + 1);
        fileName = fileName.substring(0, pos);
        StorageAttachment sa = new StorageAttachment();
        sa.setId(fileId);
        sa.setSaveTime(DateUtil.getNow());
        sa.setExtention(type);
        sa.setFileName(fileName);
        sa.setFileSize("" + file.getSize());
        sa.setOrderNo(0);
        sa.setActive("1");
        sa.setSaveType(FileInfo.getSaveType());
        sa.setViewFileName(fileName);
        sa.setComments("");
        sa.setTableName("TA_HORIZON_BLOB");
        sa.setColumnName("BLOB_CONTENT");
        sa.setSaveName(newFileName);
        sa.setSavePath(FileInfo.getStorePath() + "/" + DateUtil.formatDateTime(new Date(), "yyyyMMdd"));
        sa.setUserId(userId);
        sa.setFieldName(filedName);
        sa.setUploadType("4");
        sa.setContentSaveType("insert");
        return sa;
    }

    private StorageAttachment createStorageAttachment(MultipartFile file, String userId, String objectId, String saveType) {
        StorageAttachment sa = this.createStorageAttachment(file, userId);
        if (StringUtil.hasValue(objectId)) {
            sa.setObjectId(objectId);
        }
        if (StringUtil.hasValue(saveType)) {
            sa.setSaveType(saveType);
        }
        return sa;
    }

    private void setStorageBlob(MultipartFile file, StorageAttachment sa) throws IOException {
        StorageBlob storageBlob = new StorageBlob();
        storageBlob.setId(Access.getUUID());
        storageBlob.setContent(file.getInputStream());
        storageBlob.setObjectId(sa.getId());
        storageBlob.setTableName("ta_horizon_blob");
        storageBlob.setColumnName("blob_content");
        sa.setStorageBlob(storageBlob);
    }

    @Override
    public void exportFile(List<StorageAttachment> attachments) {
        for (StorageAttachment attachment : attachments) {
            byte[] imageBytes = Base64.decodeBase64((String)attachment.getStorageBlob().getContentStr());
            attachment.getStorageBlob().setContent(new ByteArrayInputStream(imageBytes));
            attachment.setUploadType("4");
            attachment.setContentSaveType("insert");
        }
        ArrayList lstStorageAttachments = Lists.newArrayList();
        lstStorageAttachments.add(attachments.toArray(new StorageAttachment[attachments.size()]));
        AttachmentUtil.saveAttachment(lstStorageAttachments, HorizonCore.TENANT_IDENTIFIER.value());
    }
}

