/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    private static String suffixForUnix = "/";
    private static String suffixForWindow = "\\";

    public static String composeFullFilePath(String prefixPath, String fileName) {
        if (prefixPath == null || prefixPath.trim().length() == 0) {
            return fileName;
        }
        if (fileName == null || fileName.trim().length() == 0) {
            return prefixPath;
        }
        prefixPath = prefixPath.trim();
        fileName = fileName.trim();
        while (fileName.startsWith(suffixForUnix) || fileName.startsWith(suffixForWindow)) {
            fileName = fileName.substring(1);
        }
        if (prefixPath.endsWith(suffixForUnix) || prefixPath.endsWith(suffixForWindow)) {
            StringBuffer sb = new StringBuffer(prefixPath.length() + fileName.length());
            sb.append(prefixPath).append(fileName);
            return sb.toString();
        }
        StringBuffer sb = new StringBuffer(prefixPath.length() + fileName.length() + 1);
        sb.append(prefixPath).append(suffixForUnix).append(fileName);
        return sb.toString();
    }

    public static File createFile(String pathWithFileName) throws IOException {
        if (pathWithFileName == null || pathWithFileName.trim().length() == 0) {
            return null;
        }
        File file = new File(pathWithFileName);
        if (!file.exists() && (file.isFile() ? !file.createNewFile() : file.isDirectory() && !file.mkdirs())) {
            return null;
        }
        return file;
    }

    public static boolean deleteFile(String pathWithFileName) {
        if (pathWithFileName == null || pathWithFileName.trim().length() == 0) {
            return Boolean.FALSE;
        }
        File file = new File(pathWithFileName.trim());
        if (!file.exists()) {
            return Boolean.FALSE;
        }
        return file.delete();
    }

    public static boolean deleteFiles(String fileDirectory) {
        return FileUtil.deleteFiles(fileDirectory, Boolean.FALSE);
    }

    public static boolean deleteFiles(String fileDirectory, boolean isDeleteSelfDir) {
        if (fileDirectory == null || fileDirectory.trim().length() == 0) {
            return Boolean.FALSE;
        }
        File fileDir = new File(fileDirectory.trim());
        if (!fileDir.exists()) {
            return Boolean.FALSE;
        }
        File[] files = fileDir.listFiles();
        if (files != null && files.length > 0) {
            boolean isOk = false;
            int len = files.length;
            for (int i = 0; i < len && (isOk = files[i].delete()) != Boolean.FALSE; ++i) {
            }
            if (isOk == Boolean.FALSE) {
                return Boolean.FALSE;
            }
        }
        if (isDeleteSelfDir) {
            return fileDir.delete();
        }
        return Boolean.TRUE;
    }
}

