/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file;

import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.datasource.util.DataSourceContextHolder;
import com.horizon.db.Access;
import com.horizon.db.access.def.ExeQuery;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xlob.XlobProcessor;
import com.horizon.exception.HorizonException;
import com.horizon.file.AttachmentClone;
import com.horizon.file.entity.StorageAttachment;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentUtil.class);
    private static final String FILEUPLOAD_TYPE_NOSAVE = "0";
    private static final String FILEUPLOAD_TYPE_FILE = "1";
    private static final String FILEUPLOAD_TYPE_ATTACH_BLOB_ALL = "4";
    private static final String FILEUPLOAD_TYPE_ATTACH_BLOB = "5";
    private static final String SQL_INSERT_STORAGE_ATTACHMENT = "insert into TA_HORIZON_INFO(id, file_name, save_name, extention, file_size, order_no, object_id, active, save_type, save_time, save_path, view_file_name, comments, user_id, table_name, column_name, file_content_id, field_name,status) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_UPDATE_STORAGE_ATTACHMENT = "update TA_HORIZON_INFO set file_name=?, save_name=?, extention=?, file_size=?, order_no=?, object_id=?, active=?, save_type=?, save_time=?, save_path=?, view_file_name=?, comments=?, user_id=?, table_name=?, column_name=?, file_content_id=?, field_name=?, status=? where id=?";
    private static final String SQL_DELETE_STORAGE_ATTACHMENT = "delete from TA_HORIZON_INFO where id=?";
    private static final String SQL_ATTACHMENT_SELECT = "select * from TA_HORIZON_INFO where id=?";
    private static final String SQL_ATTACHMENT_UPDATET_OBJECT_ID = "update TA_HORIZON_INFO set object_id=? where id=?";
    private static final String SAVE_TYPE_INSERT = "insert";
    private static final String SAVE_TYPE_UPDATE = "update";
    private static final String SAVE_TYPE_RENEW = "renew";
    private static final String SAVE_TYPE_FILE = "0";
    private static final String SAVE_TYPE_DB = "1";
    private static final String DOT = ".";

    private AttachmentUtil() {
    }

    public static boolean saveAttachment(List lstStorageAttachments) throws HorizonException {
        boolean isOk = AttachmentUtil.saveAttachment(lstStorageAttachments);
        return isOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAttachment(List lstStorageAttachments, String dbIdentifier) throws HorizonException {
        if (lstStorageAttachments == null || lstStorageAttachments.isEmpty()) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1alstStorageAttachments\u4e3anull\u6216\u6ca1\u6709\u5143\u7d20(Invalid parameter: lstStorageAttachments is null or empty)");
        }
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1adbIdentifier\u4e3anull\u6216\u6ca1\u6709\u5143\u7d20(Invalid parameter: dbIdentifier is null or empty)");
        }
        int len = lstStorageAttachments.size();
        for (int i = 0; i < len; ++i) {
            Object objSas = lstStorageAttachments.get(i);
            if (objSas instanceof StorageAttachment[] || objSas instanceof StorageAttachment || objSas instanceof List) continue;
            throw new HorizonException("lstStorageAttachments\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u5bf9\u8c61\u4e0d\u662f \u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u3001\u6216\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u6570\u7ec4\u3001\u6216\u5305\u542b\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u7684\u5217\u8868\u5bf9\u8c61\u3002index: " + i);
        }
        boolean oldAutoCommit = true;
        Connection conn = null;
        PreparedStatement pstmtInsertSA = null;
        PreparedStatement pstmtUpdateSA = null;
        PreparedStatement pstmtDeleteSB = null;
        try {
            XlobProcessor xlobProcessor = ExeQuery.getLobProcessorClass(dbIdentifier);
            conn = ExeQuery.getConnection(dbIdentifier);
            oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            String tableName = null;
            String columnName = null;
            boolean isInsertSA = false;
            boolean isUpdateSA = false;
            boolean isDeleteSB = false;
            StorageAttachment[] sas = null;
            int len2 = lstStorageAttachments.size();
            for (int i = 0; i < len2; ++i) {
                int k;
                Object objSas = lstStorageAttachments.get(i);
                if (objSas instanceof StorageAttachment[]) {
                    sas = (StorageAttachment[])objSas;
                } else if (objSas instanceof StorageAttachment) {
                    sas = new StorageAttachment[]{(StorageAttachment)objSas};
                } else if (objSas instanceof List) {
                    List lstObjSas = (List)objSas;
                    sas = new StorageAttachment[lstObjSas.size()];
                    lstObjSas.toArray(sas);
                } else {
                    throw new HorizonException("lstStorageAttachments\u53c2\u6570\u5217\u8868\u4e2d\u7684\u5bf9\u8c61\u4e0d\u662f\u9884\u671f\u7684\u5bf9\u8c61\u7c7b\u578b\u3002index: " + i + ", \u5bf9\u8c61\u7c7b\u540d : " + objSas.getClass().getName());
                }
                StorageAttachment sa = null;
                if (sas != null && sas.length > 0) {
                    sa = sas[0];
                }
                if (sa == null) {
                    LOGGER.error("\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u4e3anull\uff0c\u56e0\u6b64\u6574\u4e2a\u6570\u7ec4\u7684\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u8df3\u8fc7\u4e0d\u4fdd\u5b58\u3002index: 0");
                    continue;
                }
                String uploadType = sa.getUploadType();
                if (uploadType == null || uploadType.trim().length() == 0) {
                    LOGGER.error("\u9644\u4ef6\u4e0a\u4f20\u7c7b\u578b\u4e3anull\u6216\u7a7a\u503c\u3002index: 0");
                    continue;
                }
                if ("1".equals(uploadType) || "0".equals(uploadType)) {
                    LOGGER.debug("\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u7684\u4e0a\u4f20\u7c7b\u578b\u4e3a\u6587\u4ef6\u6216\u4e0d\u4fdd\u5b58\u3002index: 0");
                    continue;
                }
                tableName = sa.getTableName();
                columnName = sa.getColumnName();
                String saveType = sa.getSaveType();
                if ("1".equals(saveType)) {
                    if (tableName == null || tableName.trim().length() == 0) {
                        throw new HorizonException("\u7528\u4e8e\u4fdd\u5b58\u9644\u4ef6\u5185\u5bb9\u7684\u8868\u540d\u4e3anull\u6216\u7a7a\u503c\u3002index: 0");
                    }
                    if (columnName == null || columnName.trim().length() == 0) {
                        throw new HorizonException("\u7528\u4e8e\u4fdd\u5b58\u9644\u4ef6\u5185\u5bb9\u7684\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a\u503c\u3002index: 0");
                    }
                }
                isInsertSA = false;
                isUpdateSA = false;
                isDeleteSB = false;
                pstmtInsertSA = conn.prepareStatement(SQL_INSERT_STORAGE_ATTACHMENT);
                pstmtUpdateSA = conn.prepareStatement(SQL_UPDATE_STORAGE_ATTACHMENT);
                if (FILEUPLOAD_TYPE_ATTACH_BLOB_ALL.equals(uploadType) || FILEUPLOAD_TYPE_ATTACH_BLOB.equals(uploadType)) {
                    pstmtDeleteSB = conn.prepareStatement("delete from " + tableName + " where id=?");
                }
                int leng = sas.length;
                for (int j = 0; j < leng; ++j) {
                    boolean isInsert;
                    sa = sas[j];
                    if (sa == null) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u4e3anull\u3002index: " + j);
                        continue;
                    }
                    if ("1".equals(saveType)) {
                        if (!tableName.equals(sa.getTableName())) {
                            throw new HorizonException("\u7528\u4e8e\u4fdd\u5b58\u9644\u4ef6\u5185\u5bb9\u7684\u8868\u540d\u975e\u6cd5\u3002index: " + j);
                        }
                        if (!columnName.equals(sa.getColumnName())) {
                            throw new HorizonException("\u7528\u4e8e\u4fdd\u5b58\u9644\u4ef6\u5185\u5bb9\u7684\u5b57\u6bb5\u540d\u975e\u6cd5\u3002index: " + j);
                        }
                    }
                    uploadType = sa.getUploadType();
                    String contentOperationType = sa.getContentSaveType();
                    if (SAVE_TYPE_INSERT.equals(contentOperationType)) {
                        if (FILEUPLOAD_TYPE_ATTACH_BLOB_ALL.equals(uploadType) || FILEUPLOAD_TYPE_ATTACH_BLOB.equals(uploadType)) {
                            StorageBlob sb = sa.getStorageBlob();
                            if (sb != null) {
                                sb.setId(null);
                                sb.setObjectId(sa.getId());
                                xlobProcessor.saveUpdateBlob(conn, sb);
                                sa.setFileContentId(sb.getId());
                            } else {
                                sa.setFileContentId(null);
                            }
                        }
                        isInsert = true;
                        AttachmentUtil.setPreparedParameters(pstmtInsertSA, sa, isInsert);
                        isInsertSA = true;
                        continue;
                    }
                    if (SAVE_TYPE_UPDATE.equals(contentOperationType) || SAVE_TYPE_RENEW.equals(contentOperationType)) {
                        if (!(sa.getFileName() != null && sa.getFileName().trim().length() != 0 || sa.getFileSize() != null && sa.getFileSize().trim().length() != 0) && sa.isHoldContent()) continue;
                        if (FILEUPLOAD_TYPE_ATTACH_BLOB_ALL.equals(uploadType) || FILEUPLOAD_TYPE_ATTACH_BLOB.equals(uploadType)) {
                            StorageBlob sb;
                            String oldFileContentId = sa.getFileContentId();
                            if (oldFileContentId != null && oldFileContentId.trim().length() > 0) {
                                pstmtDeleteSB.setString(1, oldFileContentId);
                                pstmtDeleteSB.addBatch();
                                isDeleteSB = true;
                            }
                            if ((sb = sa.getStorageBlob()) != null) {
                                sb.setId(null);
                                sb.setObjectId(sa.getId());
                                xlobProcessor.saveUpdateBlob(conn, sb);
                                sa.setFileContentId(sb.getId());
                            } else {
                                sa.setFileContentId(null);
                            }
                        }
                        isInsert = false;
                        AttachmentUtil.setPreparedParameters(pstmtUpdateSA, sa, isInsert);
                        isUpdateSA = true;
                        continue;
                    }
                    String msg = "\u672a\u77e5\u7684\u9644\u4ef6\u4fdd\u5b58\u7c7b\u578b\uff1a" + contentOperationType + "\uff08\u7d22\u5f15: \u5185\uff1a" + i + "/\u5916:" + j + "\uff09\u3002\u76ee\u524d\u4ec5\u652f\u6301 insert,update,renew\uff0c" + "\u8bf7\u5728\u8c03\u7528sa.setContentSaveType(String contentSaveType)\u65f6\u4f7f\u7528\u6b63\u786e\u7684\u503c\u3002";
                    throw new HorizonException(msg);
                }
                if (isInsertSA) {
                    int[] rs = pstmtInsertSA.executeBatch();
                    if (LOGGER.isDebugEnabled()) {
                        if (rs != null && rs.length > 0) {
                            int length = rs.length;
                            for (k = 0; k < length; ++k) {
                                LOGGER.debug(k + ". Insert attachment, code: " + rs[k]);
                            }
                        } else {
                            LOGGER.debug("Insert attachment: no code.");
                        }
                    }
                }
                if (isDeleteSB) {
                    int[] rs = pstmtDeleteSB.executeBatch();
                    if (LOGGER.isDebugEnabled()) {
                        if (rs != null && rs.length > 0) {
                            int length = rs.length;
                            for (k = 0; k < length; ++k) {
                                LOGGER.debug(k + ". Delete attachment content, code: " + rs[k]);
                            }
                        } else {
                            LOGGER.debug("Delete attachment content: no code.");
                        }
                    }
                }
                if (!isUpdateSA) continue;
                int[] rs = pstmtUpdateSA.executeBatch();
                if (!LOGGER.isDebugEnabled()) continue;
                if (rs != null && rs.length > 0) {
                    int length = rs.length;
                    for (k = 0; k < length; ++k) {
                        LOGGER.debug(k + ". Update attachment, code: " + rs[k]);
                    }
                    continue;
                }
                LOGGER.debug("Update attachment: no code.");
            }
            conn.commit();
        }
        catch (InvalidIdentifierException e) {
            e.printStackTrace();
            boolean tableName = Boolean.FALSE;
            return tableName;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (SQLException sqlEx) {
                    LOGGER.error("\u6570\u636e\u5e93\u56de\u6eda\u64cd\u4f5c\u65f6\u4ea7\u751f\u5f02\u5e38\uff1a");
                    sqlEx.printStackTrace();
                }
            }
            LOGGER.error("\u6570\u636e\u5e93\u64cd\u4f5c\u65f6\u4ea7\u751f\u5f02\u5e38\uff1a");
            e.printStackTrace();
            boolean bl = Boolean.FALSE;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(oldAutoCommit);
                }
                catch (SQLException e) {
                    LOGGER.debug("\u8bbe\u7f6e\u8fd8\u539f\u6570\u636e\u5e93\u8fde\u63a5\u7684 commit\u72b6\u6001\u65f6\u53d1\u751f\u5f02\u5e38\uff1a");
                    e.printStackTrace();
                }
                ExeQuery.releaseDbResource(null, pstmtDeleteSB, null);
                ExeQuery.releaseDbResource(null, pstmtUpdateSA, null);
                ExeQuery.releaseDbResource(conn, pstmtInsertSA, null);
            }
        }
        return Boolean.TRUE;
    }

    private static void setPreparedParameters(PreparedStatement pstmt, StorageAttachment sa, boolean isInsert) throws SQLException {
        if (isInsert) {
            pstmt.setString(1, sa.getId());
            pstmt.setString(2, sa.getFileName());
            pstmt.setString(3, sa.getSaveName());
            pstmt.setString(4, sa.getExtention());
            pstmt.setString(5, sa.getFileSize());
            pstmt.setInt(6, sa.getOrderNo());
            pstmt.setString(7, sa.getObjectId());
            pstmt.setString(8, sa.getActive());
            pstmt.setString(9, sa.getSaveType());
            pstmt.setString(10, sa.getSaveTime());
            pstmt.setString(11, sa.getSavePath());
            pstmt.setString(12, sa.getViewFileName());
            pstmt.setString(13, sa.getComments());
            pstmt.setString(14, sa.getUserId());
            pstmt.setString(15, sa.getTableName());
            pstmt.setString(16, sa.getColumnName());
            pstmt.setString(17, sa.getFileContentId());
            pstmt.setString(18, sa.getFieldName());
            pstmt.setString(19, sa.getStatus());
            pstmt.addBatch();
        } else {
            pstmt.setString(1, sa.getFileName());
            pstmt.setString(2, sa.getSaveName());
            pstmt.setString(3, sa.getExtention());
            pstmt.setString(4, sa.getFileSize());
            pstmt.setInt(5, sa.getOrderNo());
            pstmt.setString(6, sa.getObjectId());
            pstmt.setString(7, sa.getActive());
            pstmt.setString(8, sa.getSaveType());
            pstmt.setString(9, sa.getSaveTime());
            pstmt.setString(10, sa.getSavePath());
            pstmt.setString(11, sa.getViewFileName());
            pstmt.setString(12, sa.getComments());
            pstmt.setString(13, sa.getUserId());
            pstmt.setString(14, sa.getTableName());
            pstmt.setString(15, sa.getColumnName());
            pstmt.setString(16, sa.getFileContentId());
            pstmt.setString(17, sa.getFieldName());
            pstmt.setString(18, sa.getStatus());
            pstmt.setString(19, sa.getId());
            pstmt.addBatch();
        }
    }

    public static StorageAttachment getSingleStorageAttachment(String objectId) {
        StorageAttachment sa = AttachmentUtil.getSingleStorageAttachment(objectId, DataSourceContextHolder.getDataSourceName());
        return sa;
    }

    public static StorageAttachment getSingleStorageAttachment(String objectId, String dbIdentifier) {
        List<StorageAttachment> lst = AttachmentUtil.getSingleStorageAttachments(objectId, dbIdentifier);
        if (lst == null || lst.isEmpty()) {
            return null;
        }
        StorageAttachment sa = lst.get(0);
        return sa;
    }

    public static List<StorageAttachment> getSingleStorageAttachments(String objectId) {
        List<StorageAttachment> lst = AttachmentUtil.getSingleStorageAttachments(objectId, DataSourceContextHolder.getDataSourceName());
        return lst;
    }

    public static List<StorageAttachment> getSingleStorageAttachments(String objectId, String dbIdentifier) {
        List<StorageAttachment> lst;
        block2: {
            Map<String, List<StorageAttachment>> m = AttachmentUtil.getStorageAttachments(objectId, dbIdentifier);
            if (m == null) {
                return null;
            }
            if (m.isEmpty()) {
                return new ArrayList<StorageAttachment>(0);
            }
            lst = null;
            Iterator<String> it = m.keySet().iterator();
            if (!it.hasNext()) break block2;
            String key = it.next();
            lst = m.get(key);
        }
        return lst;
    }

    public static Map<String, List<StorageAttachment>> getStorageAttachments(String objectId) {
        Map<String, List<StorageAttachment>> mapSas = AttachmentUtil.getStorageAttachments(objectId, DataSourceContextHolder.getDataSourceName());
        return mapSas;
    }

    public static Map<String, List<StorageAttachment>> getStorageAttachments(String objectId, String dbIdentifier) {
        if (objectId == null) {
            LOGGER.error("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5bf9\u8c61Id\u4e3anull(Invalid parameter: objectId is null)");
            return null;
        }
        if ((objectId = objectId.trim()).length() == 0) {
            LOGGER.error("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5bf9\u8c61Id\u4e3a\u7a7a(The objectId is empty).");
            return null;
        }
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            LOGGER.error("\u975e\u6cd5\u7684\u53c2\u6570\uff1adbIdentifier\u4e3anull\u6216\u7a7a(Invalid parameter: dbIdentifier is null or empty)");
            return null;
        }
        String sql = "select * from TA_HORIZON_INFO where object_id=? order by field_name, save_time, order_no";
        ArrayList<String> lstConditions = new ArrayList<String>(1);
        lstConditions.add(objectId);
        List<StorageAttachment> lstStorageAttachments = Access.getMultiObject(sql, lstConditions, StorageAttachment.class, dbIdentifier);
        if (lstStorageAttachments == null || lstStorageAttachments.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6ca1\u6709\u9644\u4ef6\u8bb0\u5f55\u3002(\u6570\u636e)\u5bf9\u8c61Id: " + objectId);
            }
            return new HashMap<String, List<StorageAttachment>>(0);
        }
        int len = lstStorageAttachments.size();
        HashMap<String, List<StorageAttachment>> m = new HashMap<String, List<StorageAttachment>>(len);
        for (int i = 0; i < len; ++i) {
            ArrayList<StorageAttachment> lst;
            StorageAttachment sa = lstStorageAttachments.get(i);
            String fieldName = sa.getFieldName();
            Object objList = m.get(fieldName);
            if (objList != null) {
                lst = (ArrayList<StorageAttachment>)objList;
                lst.add(sa);
                continue;
            }
            lst = new ArrayList<StorageAttachment>(5);
            lst.add(sa);
            m.put(fieldName, lst);
        }
        lstStorageAttachments.clear();
        return m;
    }

    public static StorageAttachment getStorageAttachmentAndContent(String attachmentId) {
        StorageAttachment sa = AttachmentUtil.getStorageAttachmentAndContent(attachmentId, DataSourceContextHolder.getDataSourceName());
        return sa;
    }

    /*
     * Exception decompiling
     */
    public static StorageAttachment getStorageAttachmentAndContent(String attachmentId, String dbIdentifier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void putUpdateObjectIdCondition(LinkedHashMap mapSqlParameters, StorageAttachment[] sas, String objectId) {
        if (mapSqlParameters == null) {
            LOGGER.error("LinkedHashMap mapSqlParameters\u5bf9\u8c61\u4e3anull (mapSqlParameters is null)");
            return;
        }
        if (sas == null) {
            LOGGER.debug("\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u6570\u7ec4\u4e3anull (attachment-info-object array is null)");
            return;
        }
        int len = sas.length;
        if (len == 0) {
            LOGGER.debug("\u6ca1\u6709\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61(no element)");
            return;
        }
        if (objectId == null) {
            LOGGER.error("\u53c2\u6570objectId\u4e3anull (objectId is null)");
            return;
        }
        if ((objectId = objectId.trim()).length() == 0) {
            LOGGER.error("\u53c2\u6570objectId\u4e3a\u7a7a (objectId is empty)");
            return;
        }
        ArrayList lstConditions = (ArrayList)mapSqlParameters.get(SQL_ATTACHMENT_UPDATET_OBJECT_ID);
        if (lstConditions == null) {
            lstConditions = new ArrayList(len);
        }
        for (int i = 0; i < len; ++i) {
            StorageAttachment sa = sas[i];
            if (sa == null) {
                LOGGER.error("\u9644\u4ef6\u5bf9\u8c61\u4e3anull (attachment-object is null) index: " + i);
                continue;
            }
            String saId = sa.getId();
            if (saId == null) {
                LOGGER.error("\u9644\u4ef6Id\u4e3anull (attachment-id is null) index: " + i);
                continue;
            }
            if ((saId = saId.trim()).length() == 0) {
                LOGGER.error("\u9644\u4ef6Id\u4e3a\u7a7a (attachment-id is empty) index: " + i);
                continue;
            }
            ArrayList<String> lstParameters = new ArrayList<String>(2);
            lstParameters.add(objectId);
            lstParameters.add(saId);
            lstConditions.add(lstParameters);
        }
        if (!lstConditions.isEmpty()) {
            mapSqlParameters.put(SQL_ATTACHMENT_UPDATET_OBJECT_ID, lstConditions);
        }
    }

    public static void putUpdateObjectId(LinkedHashMap mapSqlParameters, StorageAttachment[] sas, String objectId) {
        if (mapSqlParameters == null) {
            LOGGER.error("LinkedHashMap mapSqlParameters\u5bf9\u8c61\u4e3anull (mapSqlParameters is null)");
            return;
        }
        if (sas == null) {
            LOGGER.debug("\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61\u6570\u7ec4\u4e3anull (attachment-info-object array is null)");
            return;
        }
        int len = sas.length;
        if (len == 0) {
            LOGGER.debug("\u6ca1\u6709\u9644\u4ef6\u4fe1\u606f\u5bf9\u8c61(no element)");
            return;
        }
        if (objectId == null) {
            LOGGER.error("\u53c2\u6570objectId\u4e3anull (objectId is null)");
            return;
        }
        if ((objectId = objectId.trim()).length() == 0) {
            LOGGER.error("\u53c2\u6570objectId\u4e3a\u7a7a (objectId is empty)");
            return;
        }
        for (int i = 0; i < len; ++i) {
            StorageAttachment sa = sas[i];
            if (sa == null) {
                LOGGER.error("\u9644\u4ef6\u5bf9\u8c61\u4e3anull(attachment-object is null) index: " + i);
                continue;
            }
            sa.setObjectId(objectId);
        }
        mapSqlParameters.put("TA_HORIZON_INFO", sas);
    }

    public static boolean deleteAttachment(String[] attachmentIds) {
        boolean isOk = AttachmentUtil.deleteAttachment(attachmentIds, DataSourceContextHolder.getDataSourceName());
        return isOk;
    }

    public static boolean deleteAttachment(String[] attachmentIds, String dbIdentifier) {
        if (attachmentIds == null || attachmentIds.length == 0) {
            LOGGER.error("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u9644\u4ef6ID\u6570\u7ec4\u4e3anull\u6216\u7a7a\u3002");
            return false;
        }
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            LOGGER.error("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5e93\u6807\u8bc6\u4e3anull\u6216\u7a7a\u3002");
            return false;
        }
        ArrayList<String> lstConditions = new ArrayList<String>(1);
        int size = attachmentIds.length;
        StorageAttachment[] sas = new StorageAttachment[size];
        int idx = 0;
        for (int i = 0; i < size; ++i) {
            String id = attachmentIds[i];
            if (id != null && id.trim().length() > 0) {
                lstConditions.add(id);
                StorageAttachment obj = Access.getSingleObject(SQL_ATTACHMENT_SELECT, lstConditions, StorageAttachment.class, dbIdentifier);
                lstConditions.clear();
                if (obj != null) {
                    sas[idx] = obj;
                    ++idx;
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9644\u4ef6\u4fe1\u606f\u3002ID: " + id + " , \u7d22\u5f15: " + i);
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("\u6ca1\u6709\u9644\u4ef6ID\u503c\uff0c\u56e0\u6b64\u88ab\u5ffd\u7565\u3002\u7d22\u5f15\uff1a" + i);
        }
        String sqlDeleteSB = null;
        LinkedHashMap mapSqlParameters = new LinkedHashMap(size);
        ArrayList<StorageAttachment> lstDeleteFiles = new ArrayList<StorageAttachment>(size);
        for (int i = 0; i < size; ++i) {
            StorageAttachment sa = sas[i];
            if (sa == null) continue;
            ArrayList lstDeleteSA = (ArrayList)mapSqlParameters.get(SQL_DELETE_STORAGE_ATTACHMENT);
            if (lstDeleteSA == null) {
                lstDeleteSA = new ArrayList(size);
                mapSqlParameters.put(SQL_DELETE_STORAGE_ATTACHMENT, lstDeleteSA);
            }
            ArrayList<String> lstDelConditionsSA = new ArrayList<String>(1);
            lstDelConditionsSA.add(sa.getId());
            lstDeleteSA.add(lstDelConditionsSA);
            String saveType = sa.getSaveType();
            if ("0".equals(saveType)) {
                lstDeleteFiles.add(sa);
                continue;
            }
            if ("1".equals(saveType)) {
                List lstDeleteSB;
                String sbTableName = sa.getTableName();
                if (sbTableName == null || sbTableName.trim().length() == 0 || (lstDeleteSB = (List)mapSqlParameters.get(sqlDeleteSB = "delete from " + sbTableName + " where object_id=?")) != null) continue;
                mapSqlParameters.put(sqlDeleteSB, lstDeleteSA);
                continue;
            }
            LOGGER.error("\u672a\u77e5\u7684\u4fdd\u5b58\u7c7b\u578b\uff08" + saveType + "\uff09Unknown save type, saveType: " + saveType);
        }
        boolean isOk = Access.executeMultiUpdate(mapSqlParameters, dbIdentifier);
        if (isOk && !lstDeleteFiles.isEmpty()) {
            String slash = "/";
            String dot = DOT;
            size = lstDeleteFiles.size();
            for (int i = 0; i < size; ++i) {
                StorageAttachment sa = (StorageAttachment)lstDeleteFiles.get(i);
                String savePath = sa.getSavePath();
                String saveName = sa.getSaveName();
                String extention = sa.getExtention();
                if (savePath.endsWith(slash)) {
                    while (saveName.startsWith(slash)) {
                        saveName = saveName.substring(1);
                    }
                } else if (!saveName.startsWith(slash)) {
                    saveName = slash + saveName;
                }
                StringBuffer sb = new StringBuffer();
                sb.append(savePath);
                sb.append(saveName);
                if (extention != null && extention.trim().length() > 0) {
                    sb.append(dot);
                    sb.append(extention.trim());
                }
                String filePath = sb.toString();
                try {
                    File deleteFile = new File(filePath);
                    if (deleteFile.exists()) {
                        if (deleteFile.isFile()) {
                            deleteFile.delete();
                            continue;
                        }
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("\u6240\u5220\u9664\u7684\u4e0d\u662f\u6587\u4ef6\uff1a" + filePath);
                        continue;
                    }
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + filePath);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOGGER.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff1a" + filePath);
                }
            }
        }
        return isOk;
    }

    public static boolean deleteAttachmentByObjectId(String[] objectIds, String dbIdentifier) {
        LinkedHashMap map = new LinkedHashMap();
        File[] files = AttachmentUtil.deleteAttachmentByObjectId(map, objectIds, dbIdentifier);
        boolean isOk = Access.executeMultiUpdate(map);
        if (isOk && files != null) {
            for (File file : files) {
                file.delete();
            }
        }
        return isOk;
    }

    public static boolean deleteAttachmentByObjectId(String[] objectIds) {
        return AttachmentUtil.deleteAttachmentByObjectId(objectIds, DataSourceContextHolder.getDataSourceName());
    }

    public static File[] deleteAttachmentByObjectId(LinkedHashMap mapSqlParameters, String[] objectIds) {
        File[] files = AttachmentUtil.deleteAttachmentByObjectId(mapSqlParameters, objectIds, DataSourceContextHolder.getDataSourceName());
        return files;
    }

    public static File[] deleteAttachmentByObjectId(LinkedHashMap mapSqlParameters, String[] objectIds, String dbIdentifier) {
        String[] dataIds;
        if (mapSqlParameters == null) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1amapSqlParameters\u4e3anull\u3002");
        }
        if (objectIds == null || objectIds.length == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e3anull\u6216\u7a7a\u3002");
        }
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5e93\u6807\u8bc6\u4e3anull\u6216\u7a7a\u3002");
        }
        int idNumber = objectIds.length;
        ArrayList<String> lstValidObjectIds = new ArrayList<String>(idNumber);
        for (int i = 0; i < idNumber; ++i) {
            if (objectIds[i] == null || objectIds[i].trim().length() <= 0) continue;
            lstValidObjectIds.add(objectIds[i]);
        }
        if (lstValidObjectIds.isEmpty()) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e2d\u4e0d\u5b58\u5728\u6709\u6548\u7684\u503c\u3002");
        }
        if (idNumber == lstValidObjectIds.size()) {
            dataIds = objectIds;
        } else {
            dataIds = new String[lstValidObjectIds.size()];
            lstValidObjectIds.toArray(dataIds);
        }
        ArrayList lstFile = new ArrayList();
        String sqlQuery = "select * from TA_HORIZON_INFO where object_id=?";
        ArrayList<String> lstConditions = new ArrayList<String>(1);
        int len = dataIds.length;
        for (int i = 0; i < len; ++i) {
            lstConditions.add(dataIds[i]);
            List<StorageAttachment> lstSas = Access.getMultiObject(sqlQuery, lstConditions, StorageAttachment.class, dbIdentifier);
            lstConditions.clear();
            if (lstSas == null || lstSas.isEmpty()) continue;
            int leng = lstSas.size();
            for (int j = 0; j < leng; ++j) {
                String id;
                String tableName;
                StorageAttachment sa = lstSas.get(j);
                String saId = sa.getId();
                if (saId == null) {
                    LOGGER.error("\u9644\u4ef6\u4fe1\u606fID\u4e3anull, \u6570\u636e\u5bf9\u8c61ID\uff1a" + dataIds[i]);
                    continue;
                }
                ArrayList<String> lstDeleteSA = new ArrayList<String>(1);
                lstDeleteSA.add(saId);
                ArrayList lstConditionForDeleteSA = (ArrayList)mapSqlParameters.get(SQL_DELETE_STORAGE_ATTACHMENT);
                if (lstConditionForDeleteSA == null) {
                    lstConditionForDeleteSA = new ArrayList();
                    mapSqlParameters.put(SQL_DELETE_STORAGE_ATTACHMENT, lstConditionForDeleteSA);
                }
                lstConditionForDeleteSA.add(lstDeleteSA);
                String saveType = sa.getSaveType();
                if ("1".equals(saveType)) {
                    tableName = sa.getTableName();
                    id = sa.getFileContentId();
                    AttachmentUtil.putDeleteSAContentCondition(mapSqlParameters, tableName, id);
                    continue;
                }
                if ("0".equals(saveType)) {
                    AttachmentUtil.putDeleteFile(sa, lstFile);
                    continue;
                }
                tableName = sa.getTableName();
                id = sa.getFileContentId();
                if (tableName != null && tableName.trim().length() > 0 && id != null && id.trim().length() > 0) {
                    AttachmentUtil.putDeleteSAContentCondition(mapSqlParameters, tableName, id);
                    continue;
                }
                String dirPath = sa.getSavePath();
                String saveName = sa.getSaveName();
                if (dirPath != null && dirPath.trim().length() > 0 && saveName != null && saveName.trim().length() > 0) {
                    AttachmentUtil.putDeleteFile(sa, lstFile);
                    continue;
                }
                LOGGER.error("\u672a\u77e5\u7684\u4fdd\u5b58\u7c7b\u578b\uff1a" + saveType + " , \u9644\u4ef6ID\uff1a" + saId);
            }
        }
        if (lstFile.isEmpty()) {
            return null;
        }
        File[] files = new File[lstFile.size()];
        lstFile.toArray(files);
        return files;
    }

    private static void putDeleteSAContentCondition(Map mapSqlParameters, String tableName, String id) {
        String sqlDeleteSaContent = "delete from " + tableName.toLowerCase() + " where id=?";
        ArrayList lstConditionForDeleteContent = (ArrayList)mapSqlParameters.get(sqlDeleteSaContent);
        if (lstConditionForDeleteContent == null) {
            lstConditionForDeleteContent = new ArrayList();
            mapSqlParameters.put(sqlDeleteSaContent, lstConditionForDeleteContent);
        }
        ArrayList<String> lst = new ArrayList<String>(1);
        lst.add(id);
        lstConditionForDeleteContent.add(lst);
    }

    private static void putDeleteFile(StorageAttachment sa, List lstFile) {
        String fileName;
        File file;
        String dirPath = sa.getSavePath();
        String saveName = sa.getSaveName();
        String extension = sa.getExtention();
        StringBuffer sbFileName = new StringBuffer(saveName);
        if (extension != null && extension.trim().length() > 0) {
            sbFileName.append(DOT).append(extension);
        }
        if ((file = new File(dirPath, fileName = sbFileName.toString())).exists()) {
            lstFile.add(file);
        } else {
            LOGGER.error("\u4e0d\u5b58\u5728\u7684\u9644\u4ef6\u6587\u4ef6\uff1a" + file.getAbsolutePath() + " , \u9644\u4ef6ID\uff1a" + sa.getId());
        }
    }

    public static boolean cloneAttachments(String[] objectIds, String[] newObjectIds, boolean isRenewSaveTime) {
        boolean isOk = AttachmentUtil.cloneAttachments(objectIds, newObjectIds, isRenewSaveTime, DataSourceContextHolder.getDataSourceName());
        return isOk;
    }

    public static boolean cloneAttachments(String[] objectIds, String[] newObjectIds, boolean isRenewSaveTime, String dbIdentifier) {
        if (objectIds == null || objectIds.length == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6e90\u9644\u4ef6\u7684\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e3anull\u6216\u7a7a\u3002");
        }
        if (newObjectIds == null || newObjectIds.length == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u65b0\u9644\u4ef6\u7684\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e3anull\u6216\u7a7a\u3002");
        }
        AttachmentClone ac = new AttachmentClone();
        boolean isOk = ac.cloneAttachments(dbIdentifier, objectIds, newObjectIds, isRenewSaveTime);
        return isOk;
    }

    public static boolean cloneAttachments(Map mapObjectIdAndAttachmentIds, Map mapNewObjectIdAndAttachmentIds, boolean isRenewSaveTime) {
        boolean isOk = AttachmentUtil.cloneAttachments(mapObjectIdAndAttachmentIds, mapNewObjectIdAndAttachmentIds, isRenewSaveTime, DataSourceContextHolder.getDataSourceName());
        return isOk;
    }

    public static boolean cloneAttachments(Map mapObjectIdAndAttachmentIds, Map mapNewObjectIdAndAttachmentIds, boolean isRenewSaveTime, String dbIdentifier) {
        AttachmentClone ac = new AttachmentClone();
        boolean isOk = ac.cloneAttachments(dbIdentifier, mapObjectIdAndAttachmentIds, mapNewObjectIdAndAttachmentIds, isRenewSaveTime);
        return isOk;
    }

    public static boolean updateAttachments(String ids, String objectId, String dbIdentifier) {
        String insertOpinionSql = " UPDATE TA_HORIZON_INFO SET OBJECT_ID=? WHERE ID=?";
        List results = Lists.newArrayList();
        Splitter splitter = Splitter.on((String)";").omitEmptyStrings().trimResults();
        results = splitter.splitToList((CharSequence)ids);
        ArrayList lstConditions = Lists.newArrayList();
        for (String id : results) {
            ArrayList list = Lists.newArrayList();
            list.add(objectId);
            list.add(id);
            lstConditions.add(list);
        }
        HashMap dataMap = Maps.newHashMap();
        dataMap.put(insertOpinionSql, lstConditions);
        return Access.executeMultiUpdate(dataMap, dbIdentifier);
    }

    public static boolean updateAttachments(String ids, String objectId) {
        return AttachmentUtil.updateAttachments(ids, objectId, DataSourceContextHolder.getDataSourceName());
    }

    public static List<StorageAttachment> getAttacmemntByObjIdAndField(String objectId, String fieldName, String dbIdentifier) {
        String sql = "SELECT * FROM TA_HORIZON_INFO WHERE OBJECT_ID=? AND FIELD_NAME=? ORDER BY FIELD_NAME, SAVE_TIME, ORDER_NO";
        ArrayList lstConditions = Lists.newArrayList((Object[])new String[]{objectId, fieldName});
        List<StorageAttachment> lstStorageAttachments = Access.getMultiObject(sql, lstConditions, StorageAttachment.class, dbIdentifier);
        return lstStorageAttachments;
    }

    public static List<StorageAttachment> getAttacmemntByObjIdAndField(String objectId, String fieldName) {
        return AttachmentUtil.getAttacmemntByObjIdAndField(objectId, fieldName, DataSourceContextHolder.getDataSourceName());
    }

    public static List<StorageAttachment> getAttacmemnts(StorageAttachment storageAttachment, String dbIdentifier) {
        String sql = "SELECT * FROM TA_HORIZON_INFO WHERE OBJECT_ID=? AND FIELD_NAME=? AND FILE_NAME=? AND EXTENTION=?  ORDER BY FIELD_NAME, SAVE_TIME, ORDER_NO";
        ArrayList lstConditions = Lists.newArrayList();
        lstConditions.add(storageAttachment.getObjectId());
        lstConditions.add(storageAttachment.getFieldName());
        lstConditions.add(storageAttachment.getFileName());
        lstConditions.add(storageAttachment.getExtention());
        List<StorageAttachment> lstStorageAttachments = Access.getMultiObject(sql, lstConditions, StorageAttachment.class, dbIdentifier);
        return lstStorageAttachments;
    }

    public static List<StorageAttachment> getAttacmemnts(StorageAttachment storageAttachment) {
        return AttachmentUtil.getAttacmemnts(storageAttachment, DataSourceContextHolder.getDataSourceName());
    }
}

