/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.file;

import com.horizon.db.Access;
import com.horizon.db.access.def.ExeQuery;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xlob.XlobProcessor;
import com.horizon.exception.HorizonException;
import com.horizon.file.entity.StorageAttachment;
import com.horizon.file.service.FileNameGenerator;
import com.horizon.file.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentClone {
    private static Logger LOGGER = LoggerFactory.getLogger(AttachmentClone.class);
    private String dbIdentifier;
    private FileNameGenerator fileNameGen;
    private DateFormat dateFormat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cloneAttachments(String dbIdentifier, String[] objectIds, String[] newObjectIds, boolean isRenewSaveTime) {
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1adbIdentifier\u4e3anull\u6216\u7a7a (Invalid parameter: dbIdentifier is null or empty)");
        }
        boolean isValidParameter = this.checkDataObjectIds(objectIds, newObjectIds);
        if (!isValidParameter) {
            return false;
        }
        this.dbIdentifier = dbIdentifier;
        if (isRenewSaveTime) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        }
        int len = objectIds.length;
        ArrayList<StorageAttachment> lstClonedAttachments = new ArrayList<StorageAttachment>(len);
        LinkedHashMap mapClonedBlobInfo = new LinkedHashMap(len);
        ArrayList lstClonedFiles = new ArrayList(len);
        ArrayList lstNeedUpdateSaveTypeAttachments = new ArrayList(len);
        boolean isOk = false;
        try {
            StorageAttachment sa = null;
            for (int i = 0; i < len; ++i) {
                List lstStorageAttachments;
                String objectId = objectIds[i];
                String newObjectId = newObjectIds[i];
                if (objectId == null || objectId.trim().length() == 0) {
                    LOGGER.warn("(\u88ab\u5ffd\u7565\u7684)\u6e90\u6570\u636e\u5bf9\u8c61ID\u4e3anull\u6216\u7a7a\u3002\u4e0b\u6807\u7d22\u5f15\uff1a" + i);
                    continue;
                }
                if (newObjectId == null || newObjectId.trim().length() == 0) {
                    LOGGER.warn("(\u88ab\u5ffd\u7565\u7684)\u65b0\u6570\u636e\u5bf9\u8c61ID\u4e3anull\u6216\u7a7a\u3002\u4e0b\u6807\u7d22\u5f15\uff1a" + i);
                    continue;
                }
                if ((objectId = objectId.trim()).equals(newObjectId = newObjectId.trim())) {
                    LOGGER.warn("\u6e90\u6570\u636e\u5bf9\u8c61ID\u4e0e\u65b0\u6570\u636e\u5bf9\u8c61ID\u76f8\u540c(" + objectId + ")\u3002\u4e0b\u6807\u7d22\u5f15\uff1a" + i);
                }
                if ((lstStorageAttachments = this.getAttachmentsByObjectId(objectId)) == null || lstStorageAttachments.isEmpty()) {
                    LOGGER.warn("(\u88ab\u5ffd\u7565\u7684)\u6ca1\u6709\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u3002\u6570\u636e\u5bf9\u8c61Id\uff1a" + objectId + " ,\u4e0b\u6807\u7d22\u5f15\uff1a" + i);
                    continue;
                }
                int leng = lstStorageAttachments.size();
                for (int j = 0; j < leng; ++j) {
                    sa = (StorageAttachment)lstStorageAttachments.get(j);
                    if (sa == null) continue;
                    String newSaId = Access.getUUID();
                    StorageAttachment newSa = this.cloneAttachment(sa, newObjectId, newSaId, isRenewSaveTime, mapClonedBlobInfo, lstClonedFiles, lstNeedUpdateSaveTypeAttachments);
                    if (newSa == null) {
                        boolean bl = false;
                        return bl;
                    }
                    lstClonedAttachments.add(newSa);
                }
            }
            sa = null;
            len = lstClonedAttachments.size();
            if (len == 0) {
                StringBuffer sbId = new StringBuffer();
                int idnum = objectIds.length;
                for (int i = 0; i < idnum; ++i) {
                    if (sbId.length() > 0) {
                        sbId.append(" , ");
                    }
                    sbId.append(objectIds[i]);
                }
                LOGGER.warn("\u6ca1\u6709\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\uff0c\u4f46\u4ecd\u7136\u8ba4\u4e3a\u662f\u6210\u529f\u7684\u6267\u884c\u4e86\u9644\u4ef6\u514b\u9686\u64cd\u4f5c\u3002\u6570\u636e\u5bf9\u8c61Id\uff1a" + sbId.toString());
                boolean bl = isOk = true;
                return bl;
            }
            isOk = this.saveAttachmentInfo(lstClonedAttachments, lstNeedUpdateSaveTypeAttachments);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isOk = false;
        }
        finally {
            boolean isDeleted;
            if (!isOk && !(isDeleted = this.deleteClonedFileAndAttachmentInfo(lstClonedFiles, mapClonedBlobInfo))) {
                LOGGER.error("\u5728\u514b\u9686\u9644\u4ef6\u5931\u8d25\u7684\u60c5\u51b5\u4e0b\uff0c\u5220\u9664\u5df2\u514b\u9686\u9644\u4ef6\u4fe1\u606f\u65f6\u4e5f\u5931\u8d25\u4e86\u3002");
            }
        }
        return isOk;
    }

    private boolean saveAttachmentInfo(List lstClonedAttachments, List lstNeedUpdateSaveTypeAttachments) {
        LinkedHashMap<String, List> m = new LinkedHashMap<String, List>(2);
        String SQL_INSERT_STORAGE_ATTACHMENT = "insert into TA_HORIZON_INFO(id, file_name, save_name, extention, file_size, order_no, object_id, active, save_type, save_time, save_path, view_file_name, comments, user_id, table_name, column_name, file_content_id, field_name) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        StorageAttachment sa = null;
        int len = lstClonedAttachments.size();
        ArrayList<List> lstAttachmentInfos = new ArrayList<List>(len);
        for (int i = 0; i < len; ++i) {
            sa = (StorageAttachment)lstClonedAttachments.get(i);
            List lst = this.getInsertSqlParameters(sa);
            lstAttachmentInfos.add(lst);
        }
        m.put(SQL_INSERT_STORAGE_ATTACHMENT, lstAttachmentInfos);
        len = lstNeedUpdateSaveTypeAttachments.size();
        if (len > 0) {
            String sql = "update TA_HORIZON_INFO set save_type=? where id=?";
            m.put(sql, lstNeedUpdateSaveTypeAttachments);
        }
        boolean isOk = Access.executeMultiUpdate(m, this.dbIdentifier);
        return isOk;
    }

    private boolean deleteClonedFileAndAttachmentInfo(List lstClonedFiles, Map mapClonedBlobInfo) {
        int len;
        if (!lstClonedFiles.isEmpty()) {
            len = lstClonedFiles.size();
            for (int i = 0; i < len; ++i) {
                File f = (File)lstClonedFiles.get(i);
                try {
                    if (!f.exists()) continue;
                    f.delete();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (mapClonedBlobInfo.isEmpty()) {
            return true;
        }
        try {
            len = mapClonedBlobInfo.size();
            StringBuffer sbIds = new StringBuffer();
            LinkedHashMap m = new LinkedHashMap(len);
            HashMap<String, String> tmpMap = new HashMap<String, String>(len);
            for (String id : mapClonedBlobInfo.keySet()) {
                ArrayList lstConditions;
                String sql;
                String tableName = (String)mapClonedBlobInfo.get(id);
                if (tmpMap.containsKey(tableName = tableName.toLowerCase())) {
                    sql = (String)tmpMap.get(tableName);
                    lstConditions = (ArrayList)m.get(sql);
                } else {
                    sql = "delete from " + tableName + " where id=?";
                    tmpMap.put(tableName, sql);
                    lstConditions = new ArrayList(len);
                    m.put(sql, lstConditions);
                }
                ArrayList<String> lst = new ArrayList<String>(1);
                lst.add(id);
                lstConditions.add(lst);
                sbIds.append("[tableName: ").append(tableName).append("; id: ").append(id).append("]");
            }
            boolean r = Access.executeMultiUpdate(m, this.dbIdentifier);
            if (!r) {
                LOGGER.error("\u5728\u590d\u5236\u9644\u4ef6\u5931\u8d25\u7684\u60c5\u51b5\u4e0b\uff0c\u5220\u9664\u5df2\u590d\u5236\u7684\u9644\u4ef6\u5185\u5bb9\u5931\u8d25\u3002tableName & ID: " + sbIds.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private List getInsertSqlParameters(StorageAttachment sa) {
        ArrayList<Object> lst = new ArrayList<Object>(18);
        lst.add(sa.getId());
        lst.add(sa.getFileName());
        lst.add(sa.getSaveName());
        lst.add(sa.getExtention());
        lst.add(sa.getFileSize());
        lst.add(sa.getOrderNo());
        lst.add(sa.getObjectId());
        lst.add(sa.getActive());
        lst.add(sa.getSaveType());
        lst.add(sa.getSaveTime());
        lst.add(sa.getSavePath());
        lst.add(sa.getViewFileName());
        lst.add(sa.getComments());
        lst.add(sa.getUserId());
        lst.add(sa.getTableName());
        lst.add(sa.getColumnName());
        lst.add(sa.getFileContentId());
        lst.add(sa.getFieldName());
        return lst;
    }

    private StorageAttachment cloneAttachment(StorageAttachment sa, String newObjectId, String newSaId, boolean isRenewSaveTime, Map mapClonedBlobInfo, List lstClonedFiles, List lstNeedUpdateSaveTypeAttachments) {
        boolean isOk = false;
        StorageAttachment newSa = new StorageAttachment();
        newSa.setId(newSaId);
        String saId = sa.getId();
        String saveType = sa.getSaveType();
        if ("1".equals(saveType)) {
            isOk = this.cloneAttachmentInfoAndBlob(sa, isRenewSaveTime, newSa, mapClonedBlobInfo);
        } else if ("0".equals(saveType)) {
            isOk = this.cloneAttachmentInfoAndFile(sa, isRenewSaveTime, newSa, lstClonedFiles);
        } else {
            String sbId = sa.getFileContentId();
            String saveName = sa.getSaveName();
            if (sbId != null && sbId.trim().length() > 0) {
                sa.setSaveType("1");
                ArrayList<String> lst = new ArrayList<String>(2);
                lst.add(sa.getSaveType());
                lst.add(sa.getId());
                lstNeedUpdateSaveTypeAttachments.add(lst);
                isOk = this.cloneAttachmentInfoAndBlob(sa, isRenewSaveTime, newSa, mapClonedBlobInfo);
            } else if (saveName != null && saveName.trim().length() > 0) {
                sa.setSaveType("0");
                ArrayList<String> lst = new ArrayList<String>(2);
                lst.add(sa.getSaveType());
                lst.add(sa.getId());
                lstNeedUpdateSaveTypeAttachments.add(lst);
                isOk = this.cloneAttachmentInfoAndFile(sa, isRenewSaveTime, newSa, lstClonedFiles);
            } else {
                LOGGER.error("\u672a\u77e5\u7684\u4fdd\u5b58\u7c7b\u578b\uff08" + saveType + "\uff09Unknown save type, attachmentId: " + saId + " , saveType: " + saveType);
            }
        }
        if (isOk) {
            newSa.setObjectId(newObjectId);
            return newSa;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cloneAttachmentInfoAndBlob(StorageAttachment sa, boolean isNewSaveTime, StorageAttachment newSa, Map mapClonedBlobInfo) {
        boolean isOk = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = ExeQuery.getConnection(this.dbIdentifier);
            XlobProcessor xlobProcessor = ExeQuery.getLobProcessorClass(this.dbIdentifier);
            String tableName = sa.getTableName();
            String columnName = sa.getColumnName();
            String fileContentId = sa.getFileContentId();
            if (tableName == null || tableName.trim().length() == 0 || columnName == null || columnName.trim().length() == 0 || fileContentId == null || fileContentId.trim().length() == 0) {
                LOGGER.error("\u6240\u67e5\u770b\u7684\u9644\u4ef6\u6ca1\u6709\u4e0a\u4f20\u5185\u5bb9\uff08\u9644\u4ef6\u4fe1\u606fId: " + sa.getId() + "\uff09\uff0c\u8bf7\u68c0\u67e5\u9644\u4ef6\u8868\u540d\u3001\u9644\u4ef6\u5b57\u6bb5\u540d\u3001\u9644\u4ef6\u5185\u5bb9ID\u503c\u3002");
                boolean bl = false;
                return bl;
            }
            StringBuffer sbSql = new StringBuffer();
            sbSql.append("select ").append(columnName);
            sbSql.append(" from ").append(tableName);
            sbSql.append(" where id=?");
            String sql = sbSql.toString();
            ArrayList<String> lstConditions = new ArrayList<String>(1);
            lstConditions.add(fileContentId);
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, fileContentId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Blob blob = rs.getBlob(1);
                InputStream inputStream = blob.getBinaryStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                StreamUtil.exchangeStream(inputStream, baos);
                byte[] bytes = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                String newSaId = newSa.getId();
                StorageBlob sb = new StorageBlob();
                sb.setId(null);
                sb.setObjectId(newSaId);
                sb.setColumnName(columnName);
                sb.setTableName(tableName);
                sb.setContent(bais);
                xlobProcessor.saveUpdateBlob(conn, sb);
                bytes = null;
                bais = null;
                this.copyStorageAttachmentProperties(sa, newSa);
                String sbId = sb.getId();
                newSa.setFileContentId(sbId);
                mapClonedBlobInfo.put(sbId, tableName);
                if (isNewSaveTime) {
                    String dt = this.dateFormat.format(new Date());
                    newSa.setSaveTime(dt);
                }
                isOk = true;
            } else {
                isOk = false;
                LOGGER.warn("\u4e0d\u5b58\u5728\u9644\u4ef6\u5185\u5bb9\u3002\u9644\u4ef6\u4fe1\u606fID\uff1a" + sa.getId() + " ,\u9644\u4ef6\u5185\u5bb9\u8868\uff1a" + tableName + " ,\u9644\u4ef6\u5185\u5bb9ID\uff1a" + fileContentId);
            }
            ExeQuery.releaseDbResource(conn, pstmt, rs);
        }
        catch (InvalidIdentifierException ex) {
            ex.printStackTrace();
            isOk = false;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            isOk = false;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            isOk = false;
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            isOk = false;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            isOk = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isOk = false;
        }
        finally {
            ExeQuery.releaseDbResource(conn, pstmt, rs);
        }
        return isOk;
    }

    private boolean cloneAttachmentInfoAndFile(StorageAttachment sa, boolean isNewSaveTime, StorageAttachment newSa, List lstClonedFiles) {
        String newFilePath;
        File newFile;
        boolean isOk;
        String newFileName;
        String fileName;
        File file;
        String slash = "/";
        String dot = ".";
        String savePath = sa.getSavePath();
        String saveName = sa.getSaveName();
        String extension = sa.getExtention();
        if (savePath.endsWith("/")) {
            while (saveName.startsWith("/")) {
                saveName = saveName.substring(1);
            }
        } else if (!saveName.startsWith("/")) {
            saveName = "/" + saveName;
        }
        StringBuffer sbFileName = new StringBuffer(saveName);
        if (extension != null && extension.trim().length() > 0) {
            sbFileName.append(".").append(extension);
        }
        if (!(file = new File(savePath, fileName = sbFileName.toString())).exists()) {
            LOGGER.error("\u4e0d\u5b58\u5728\u7684\u6e90\u9644\u4ef6\u6587\u4ef6\uff0c\u590d\u5236\u9644\u4ef6\u6587\u4ef6\u5931\u8d25\u3002\u9644\u4ef6ID\uff1a" + sa.getId());
            return false;
        }
        if (this.fileNameGen != null) {
            newFileName = this.fileNameGen.generateFileName("hz");
        } else {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            newFileName = "hz" + df.format(new Date());
        }
        StringBuffer sbNewFileName = new StringBuffer();
        sbNewFileName.append(newFileName);
        if (extension != null && extension.trim().length() > 0) {
            sbNewFileName.append(".").append(extension);
        }
        if (isOk = this.copyFile(file, newFile = new File(savePath, newFilePath = sbNewFileName.toString()))) {
            this.copyStorageAttachmentProperties(sa, newSa);
            newSa.setSaveName(newFileName);
            lstClonedFiles.add(newFile);
            if (isNewSaveTime) {
                String dt = this.dateFormat.format(new Date());
                newSa.setSaveTime(dt);
            }
        }
        return isOk;
    }

    private void copyStorageAttachmentProperties(StorageAttachment sa, StorageAttachment newSa) {
        newSa.setActive(sa.getActive());
        newSa.setColumnName(sa.getColumnName());
        newSa.setContentSaveType(sa.getContentSaveType());
        newSa.setExtention(sa.getExtention());
        newSa.setFieldName(sa.getFieldName());
        newSa.setComments(sa.getComments());
        newSa.setFileContentId(sa.getFileContentId());
        newSa.setFileName(sa.getFileName());
        newSa.setFileSize(sa.getFileSize());
        newSa.setIsHoldContent(sa.isHoldContent());
        newSa.setObjectId(sa.getObjectId());
        newSa.setOrderNo(sa.getOrderNo());
        newSa.setSaveName(sa.getSaveName());
        newSa.setSavePath(sa.getSavePath());
        newSa.setSaveTime(sa.getSaveTime());
        newSa.setSaveType(sa.getSaveType());
        newSa.setTableName(sa.getTableName());
        newSa.setUploadType(sa.getUploadType());
        newSa.setUserId(sa.getUserId());
        newSa.setViewFileName(sa.getViewFileName());
    }

    private boolean copyFile(File file, File newFile) {
        boolean isOk = false;
        try {
            boolean isCreated = newFile.createNewFile();
            if (isCreated) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(newFile));
                StreamUtil.exchangeStream(is, os);
                isOk = true;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return isOk;
    }

    private List getAttachmentsByObjectId(String objectId) {
        String sql = "select * from TA_HORIZON_INFO where object_id=? order by field_name, save_time, order_no";
        ArrayList<String> lstConditions = new ArrayList<String>(1);
        lstConditions.add(objectId);
        List<StorageAttachment> lstStorageAttachments = Access.getMultiObject(sql, lstConditions, StorageAttachment.class, this.dbIdentifier);
        return lstStorageAttachments;
    }

    private StorageAttachment getAttachmentById(String attachmentId) {
        String sql = "select * from TA_HORIZON_INFO where id=?";
        ArrayList<String> lstConditions = new ArrayList<String>(1);
        lstConditions.add(attachmentId);
        StorageAttachment sa = Access.getSingleObject(sql, lstConditions, StorageAttachment.class, this.dbIdentifier);
        return sa;
    }

    private boolean checkDataObjectIds(String[] objectIds, String[] newObjectIds) {
        if (objectIds == null) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6e90\u5bf9\u8c61ID\u6570\u7ec4\u4e3anull (objectIds array is null)");
        }
        if (newObjectIds == null) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u65b0\u5bf9\u8c61ID\u6570\u7ec4\u4e3anull (newObjectIds array is null)");
        }
        int len = objectIds.length;
        int leng = newObjectIds.length;
        if (len != leng) {
            throw new HorizonException("\u6e90\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e0e\u65b0\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u7684\u6570\u7ec4\u957f\u5ea6\u4e0d\u76f8\u7b49\u3002(The objectIds array's length is NOT equal with newObjectIds array's.)");
        }
        int oldValidIdNum = 0;
        int newValidIdNum = 0;
        for (int i = 0; i < len; ++i) {
            if (objectIds[i] != null && objectIds[i].trim().length() > 0) {
                ++oldValidIdNum;
            }
            if (newObjectIds[i] == null || newObjectIds[i].trim().length() <= 0) continue;
            ++newValidIdNum;
        }
        if (oldValidIdNum == 0) {
            throw new HorizonException("\u6e90\u6570\u5bf9\u8c61ID\u6570\u7ec4\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u6570\u636eID (Not exist valid value with objectIds array)");
        }
        if (newValidIdNum == 0) {
            throw new HorizonException("\u65b0\u6570\u5bf9\u8c61ID\u6570\u7ec4\u4e2d\u6ca1\u6709\u6709\u6548\u7684\u6570\u636eID (Not exist valid value with newObjectIds array)");
        }
        if (oldValidIdNum != newValidIdNum) {
            throw new HorizonException("\u6e90\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e0e\u65b0\u6570\u636e\u5bf9\u8c61ID\u6570\u7ec4\u4e2d\u6709\u6548\u7684\u6570\u636e\u5bf9\u8c61ID\u7684\u6570\u91cf\u4e0d\u76f8\u7b49\u3002(Not equal with valid objectIds and newObjectIds number)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cloneAttachments(String dbIdentifier, Map mapObjectIdAndAttachmentIds, Map mapNewObjectIdAndAttachmentIds, boolean isRenewSaveTime) {
        boolean isValidParameter = this.checkDataObjectIds(mapObjectIdAndAttachmentIds, mapNewObjectIdAndAttachmentIds);
        if (!isValidParameter) {
            return false;
        }
        this.dbIdentifier = dbIdentifier;
        if (isRenewSaveTime) {
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        }
        ArrayList<StorageAttachment> lstClonedAttachments = new ArrayList<StorageAttachment>();
        LinkedHashMap mapClonedBlobInfo = new LinkedHashMap();
        ArrayList lstClonedFiles = new ArrayList();
        ArrayList lstNeedUpdateSaveTypeAttachments = new ArrayList();
        boolean isOk = false;
        try {
            StorageAttachment sa = null;
            Iterator itObjectIds = mapObjectIdAndAttachmentIds.keySet().iterator();
            Iterator itNewObjectIds = mapNewObjectIdAndAttachmentIds.keySet().iterator();
            while (itObjectIds.hasNext() && itNewObjectIds.hasNext()) {
                String sObjectId = (String)itObjectIds.next();
                if (sObjectId == null || sObjectId.trim().length() == 0) {
                    LOGGER.warn("\u88ab\u5ffd\u7565\u7684\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId);
                    continue;
                }
                String sNewObjectId = (String)itNewObjectIds.next();
                if (sNewObjectId == null || sNewObjectId.trim().length() == 0) {
                    throw new HorizonException("\u65b0\u6570\u636e\u5bf9\u8c61ID\u4e3anull\u6216\u7a7a\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId);
                }
                List lstAttachmentIds = (List)mapObjectIdAndAttachmentIds.get(sObjectId);
                if (lstAttachmentIds == null || lstAttachmentIds.isEmpty()) {
                    LOGGER.warn("\u6e90\u9644\u4ef6ID\u5217\u8868\u4e3anull\u6216\u7a7a\uff0c\u5c06\u88ab\u5ffd\u7565\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId);
                    continue;
                }
                List lstNewAttachmentIds = (List)mapNewObjectIdAndAttachmentIds.get(sNewObjectId);
                if (lstNewAttachmentIds == null || lstNewAttachmentIds.isEmpty()) {
                    throw new HorizonException("\u65b0\u6570\u636e\u5bf9\u8c61ID\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u4e3anull\u6216\u7a7a\u3002\u65b0\u6570\u636e\u5bf9\u8c61ID\uff1a" + sNewObjectId + "\uff0c\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId);
                }
                if (lstAttachmentIds.size() != lstNewAttachmentIds.size()) {
                    throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u9644\u4ef6\u4fe1\u606fID\u5217\u8868\u957f\u5ea6\u4e0d\u76f8\u540c\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId + "\uff0c\u65b0\u6570\u636e\u5bf9\u8c61ID\uff1a" + sNewObjectId);
                }
                int len = lstAttachmentIds.size();
                for (int i = 0; i < len; ++i) {
                    String sAttachmentId = (String)lstAttachmentIds.get(i);
                    if (sAttachmentId == null || sAttachmentId.trim().length() == 0) {
                        LOGGER.warn("\u6e90\u9644\u4ef6ID\u4e3anull\u6216\u7a7a\uff0c\u5c06\u88ab\u5ffd\u7565\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId + "\uff0c\u7d22\u5f15\uff1a" + i);
                        continue;
                    }
                    String sNewAttachmentId = (String)lstNewAttachmentIds.get(i);
                    if (sNewAttachmentId == null || sNewAttachmentId.trim().length() == 0) {
                        throw new HorizonException("\u65b0\u9644\u4ef6ID\u4e3anull\u6216\u7a7a\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId + "\uff0c\u7d22\u5f15\uff1a" + i);
                    }
                    sa = this.getAttachmentById(sAttachmentId);
                    if (sa == null) {
                        LOGGER.warn("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9644\u4ef6\u4fe1\u606f\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + sObjectId + "\uff0c\u9644\u4ef6ID\uff1a" + sAttachmentId + "\uff0c\u7d22\u5f15\uff1a" + i);
                        continue;
                    }
                    StorageAttachment newSa = this.cloneAttachment(sa, sNewObjectId, sNewAttachmentId, isRenewSaveTime, mapClonedBlobInfo, lstClonedFiles, lstNeedUpdateSaveTypeAttachments);
                    if (newSa == null) {
                        boolean bl = false;
                        return bl;
                    }
                    lstClonedAttachments.add(newSa);
                }
            }
            sa = null;
            int len = lstClonedAttachments.size();
            if (len == 0) {
                StringBuffer sbId = new StringBuffer();
                for (Object id : mapObjectIdAndAttachmentIds.keySet()) {
                    if (sbId.length() > 0) {
                        sbId.append("; ");
                    }
                    sbId.append(id);
                    List lstSaIds = (List)mapObjectIdAndAttachmentIds.get(id);
                    if (lstSaIds == null || lstSaIds.isEmpty()) {
                        sbId.append("[\u65e0\u9644\u4ef6\u4fe1\u606fID]");
                        continue;
                    }
                    sbId.append("[\u9644\u4ef6\u4fe1\u606fID\uff1a");
                    sbId.append(lstSaIds.get(0));
                    int leng = lstSaIds.size();
                    for (int i = 1; i < leng; ++i) {
                        sbId.append(", " + lstSaIds.get(i));
                    }
                    sbId.append("]");
                }
                LOGGER.warn("\u6ca1\u6709\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\uff0c\u4f46\u4ecd\u7136\u8ba4\u4e3a\u662f\u6210\u529f\u7684\u6267\u884c\u4e86\u9644\u4ef6\u514b\u9686\u64cd\u4f5c\u3002\u6570\u636e\u5bf9\u8c61Id\uff1a" + sbId.toString());
                boolean bl = isOk = true;
                return bl;
            }
            isOk = this.saveAttachmentInfo(lstClonedAttachments, lstNeedUpdateSaveTypeAttachments);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isOk = false;
        }
        finally {
            boolean isDeleted;
            if (!isOk && !(isDeleted = this.deleteClonedFileAndAttachmentInfo(lstClonedFiles, mapClonedBlobInfo))) {
                LOGGER.error("\u5728\u514b\u9686\u9644\u4ef6\u5931\u8d25\u7684\u60c5\u51b5\u4e0b\uff0c\u5220\u9664\u5df2\u514b\u9686\u9644\u4ef6\u4fe1\u606f\u65f6\u4e5f\u5931\u8d25\u4e86\u3002");
            }
        }
        return isOk;
    }

    private boolean checkDataObjectIds(Map mapObjectIdAndAttachmentIds, Map mapNewObjectIdAndAttachmentIds) {
        if (mapObjectIdAndAttachmentIds == null) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u6e90\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e3anull (The map object is null, which is include the objectId and attachmentIds array)");
        }
        if (mapNewObjectIdAndAttachmentIds == null) {
            throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u65b0\u6570\u636e\u5bf9\u8c61ID\u53ca\u65b0\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e3anull (The map object is null, which is include the NEW objectId and attachmentIds array)");
        }
        if (mapObjectIdAndAttachmentIds.size() != mapNewObjectIdAndAttachmentIds.size()) {
            throw new HorizonException("\u5305\u542b\u201c\u6e90\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201dMap\u5bf9\u8c61 \u4e0e \u5305\u542b\u201c\u65b0\u6570\u636e\u5bf9\u8c61ID\u53ca\u65b0\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201dMap\u5bf9\u8c61\u7684\u5143\u7d20\u6570\u91cf\u4e0d\u76f8\u7b49\u3002(The mapObjectIdAndAttachmentIds's element number is NOT equal with mapNewObjectIdAndAttachmentIds's.)");
        }
        Iterator itObjectIds = mapObjectIdAndAttachmentIds.keySet().iterator();
        Iterator itNewObjectIds = mapNewObjectIdAndAttachmentIds.keySet().iterator();
        while (itObjectIds.hasNext() && itNewObjectIds.hasNext()) {
            Object kObjectId = itObjectIds.next();
            if (!(kObjectId instanceof String)) {
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u6e90\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e2d\u7684\u4e3b\u952e\u4e0d\u662fString\u7c7b\u578b");
            }
            Object kNewObjectId = itNewObjectIds.next();
            if (!(kNewObjectId instanceof String)) {
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u65b0\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e2d\u7684\u4e3b\u952e\u4e0d\u662fString\u7c7b\u578b");
            }
            Object vAttachmentIds = mapObjectIdAndAttachmentIds.get(kObjectId);
            if (vAttachmentIds == null) {
                LOGGER.warn("\u6e90\u6570\u636e\u5bf9\u8c61ID(" + kObjectId + ")\u6240\u5bf9\u5e94\u7684\u503c(\u5305\u542bString\u503c\u7684List\u5bf9\u8c61)\u4e3anull\uff0c\u56e0\u6b64\u5c06\u88ab\u5ffd\u7565\u3002");
                continue;
            }
            if (!(vAttachmentIds instanceof List)) {
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u65b0\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e2d\u7684\u503c\u4e0d\u662fList\u7c7b\u578b");
            }
            Object vNewAttachmentIds = mapNewObjectIdAndAttachmentIds.get(kNewObjectId);
            if (vNewAttachmentIds == null) {
                throw new HorizonException("\u65b0\u6570\u636e\u5bf9\u8c61ID(" + kNewObjectId + ")\u6240\u5bf9\u5e94\u7684\u503c(\u5305\u542bString\u503c\u7684List\u5bf9\u8c61)\u4e3anull");
            }
            if (!(vNewAttachmentIds instanceof List)) {
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u5305\u542b\u201c\u65b0\u6570\u636e\u5bf9\u8c61ID\u53ca\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u201d\u7684Map\u5bf9\u8c61\u4e2d\u7684\u503c\u4e0d\u662fList\u7c7b\u578b");
            }
            List lstAttachmentIds = (List)vAttachmentIds;
            List lstNewAttachmentIds = (List)vNewAttachmentIds;
            if (lstAttachmentIds.size() != lstNewAttachmentIds.size()) {
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u9644\u4ef6\u4fe1\u606fID\u5217\u8868\u957f\u5ea6\u4e0d\u76f8\u540c\u3002\u6e90\u6570\u636e\u5bf9\u8c61ID\uff1a" + kObjectId + "\uff0c\u65b0\u6570\u636e\u5bf9\u8c61ID\uff1a" + kNewObjectId);
            }
            int len = lstAttachmentIds.size();
            for (int i = 0; i < len; ++i) {
                Object vNewAttachmentId;
                Object vAttachmentId = lstAttachmentIds.get(i);
                if (vAttachmentId == null) {
                    LOGGER.warn("\u6e90\u6570\u636e\u5bf9\u8c61ID(" + kObjectId + ")\u6240\u5bf9\u5e94\u7684\u503cList\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e3anull\uff0c\u5c06\u88ab\u5ffd\u7565\u3002\u7d22\u5f15\uff1a" + i);
                    continue;
                }
                if (!(vAttachmentId instanceof String)) {
                    throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u6e90\u6570\u636e\u5bf9\u8c61ID(" + kObjectId + ")\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e0d\u662fString\u7c7b\u578b\u3002\u7d22\u5f15\uff1a" + i);
                }
                String sAttachmentId = (String)vAttachmentId;
                if (sAttachmentId.trim().length() == 0) {
                    LOGGER.warn("\u6e90\u6570\u636e\u5bf9\u8c61ID(" + kObjectId + ")\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e3a\u7a7a\uff0c\u5c06\u88ab\u5ffd\u7565\u3002\u7d22\u5f15\uff1a" + i);
                }
                if ((vNewAttachmentId = lstNewAttachmentIds.get(i)) == null) {
                    throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u65b0\u6570\u636e\u5bf9\u8c61ID(" + vNewAttachmentId + ")\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e3anull\u3002\u7d22\u5f15\uff1a" + i);
                }
                if (!(vNewAttachmentId instanceof String)) {
                    throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u65b0\u6570\u636e\u5bf9\u8c61ID(" + vNewAttachmentId + ")\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e0d\u662fString\u7c7b\u578b\u3002\u7d22\u5f15\uff1a" + i);
                }
                String sNewAttachmentId = (String)vNewAttachmentId;
                if (sNewAttachmentId.trim().length() != 0) continue;
                throw new HorizonException("\u975e\u6cd5\u7684\u53c2\u6570\uff1a\u65b0\u6570\u636e\u5bf9\u8c61ID(" + vNewAttachmentId + ")\u6240\u5bf9\u5e94\u7684\u9644\u4ef6ID\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u9644\u4ef6ID\u503c\u4e3a\u7a7a\u3002\u7d22\u5f15\uff1a" + i);
            }
        }
        return true;
    }
}

