/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xlob;

import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.module.StorageClob;
import com.horizon.db.xlob.CommonXlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlobProcessorImpl4SqlServer
extends CommonXlobProcessor {
    private static Logger logger = LoggerFactory.getLogger(XlobProcessorImpl4SqlServer.class);

    @Override
    public void saveUpdateClob(Connection conn, StorageClob storageClob) throws Exception {
        this.saveUpdateClobByString(conn, storageClob);
    }

    @Override
    public void saveUpdateBlob(Connection conn, StorageBlob storageBlob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageBlob == null) {
            throw new HorizonException("\u53c2\u6570storageBlob\u4e3anull.[the parameter storageBlob is null.]");
        }
        String tableName = storageBlob.getTableName();
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u8868\u540d.[the StorageBlob object hasn't the table name.]");
        }
        String columnName = storageBlob.getColumnName();
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6eBlob\u5b57\u6bb5\u540d.[the StorageBlob object hasn't the blob column name.]");
        }
        InputStream inputStream = storageBlob.getContent();
        if (inputStream == null) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9\uff08InputStream\u5bf9\u8c61\uff09.[the StorageBlob object hasn't content(An InputStream object).]");
        }
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc = 0;
        while ((rc = inputStream.read(buff)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] bytes = swapStream.toByteArray();
        ByteArrayInputStream bytestream = new ByteArrayInputStream(bytes);
        Statement pstmt = null;
        try {
            if (storageBlob.isNew()) {
                String objectId = storageBlob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null value.]");
                }
                String primaryId = storageBlob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageBlob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + tableName + "(ID,OBJECT_ID," + columnName + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setBinaryStream(3, bytestream, bytestream.available());
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
                pstmt.setBinaryStream(1, bytestream, bytestream.available());
                pstmt.setString(2, storageBlob.getId());
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                inputStream = null;
            }
        }
    }

    @Override
    public boolean updateClob(Connection conn, String tableName, String columnName, List lstParameters) throws SQLException {
        boolean flag = false;
        try {
            flag = this.updateClobByString(conn, tableName, columnName, lstParameters);
        }
        catch (Exception ex) {
            flag = false;
        }
        return flag;
    }
}

