/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xlob;

import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.module.StorageClob;
import com.horizon.db.xlob.CommonXlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlobProcessorImpl4Postgresql
extends CommonXlobProcessor {
    private static Logger logger = LoggerFactory.getLogger(XlobProcessorImpl4Postgresql.class);

    @Override
    public void saveUpdateBlob(Connection conn, StorageBlob storageBlob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageBlob == null) {
            throw new HorizonException("\u53c2\u6570storageBlob\u4e3anull.[the parameter storageBlob is null.]");
        }
        String tableName = storageBlob.getTableName();
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u8868\u540d.[the StorageBlob object hasn't the table name.]");
        }
        String columnName = storageBlob.getColumnName();
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6eBlob\u5b57\u6bb5\u540d.[the StorageBlob object hasn't the blob column name.]");
        }
        InputStream inputStream = storageBlob.getContent();
        if (inputStream == null) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9\uff08InputStream\u5bf9\u8c61\uff09.[the StorageBlob object hasn't content(An InputStream object).]");
        }
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc = 0;
        while ((rc = inputStream.read(buff)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] bytes = swapStream.toByteArray();
        Statement pstmt = null;
        try {
            if (storageBlob.isNew()) {
                String objectId = storageBlob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null value.]");
                }
                String primaryId = storageBlob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageBlob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + tableName + "(ID,OBJECT_ID," + columnName + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setBytes(3, bytes);
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
                pstmt.setBytes(1, bytes);
                pstmt.setString(2, storageBlob.getId());
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                inputStream = null;
            }
        }
    }

    @Override
    public void saveUpdateClob(Connection conn, StorageClob storageClob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageClob == null) {
            throw new HorizonException("\u53c2\u6570storageClob\u4e3anull.[the parameter storageClob is null.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("CLOB_CONTENT");
            if (logger.isDebugEnabled()) {
                logger.debug("use the default clob table name [TA_HORIZON_CLOB] and column name [CLOB_CONTENT].");
            }
        }
        Statement pstmt = null;
        try {
            if (storageClob.isNew()) {
                String objectId = storageClob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null value.]");
                }
                byte[] bytes = storageClob.getClobContent().getBytes("utf-8");
                ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
                int length = bytes.length;
                String primaryId = storageClob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageClob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + storageClob.getTableName() + "(ID,OBJECT_ID," + storageClob.getColumnName() + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setAsciiStream(3, inputstream, length);
                pstmt.executeUpdate();
            } else {
                byte[] bytes = storageClob.getClobContent().getBytes("utf-8");
                ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
                int length = bytes.length;
                pstmt = conn.prepareStatement("UPDATE " + storageClob.getTableName() + " SET " + storageClob.getColumnName() + "=? WHERE ID=?");
                pstmt.setAsciiStream(1, inputstream, length);
                pstmt.setString(2, storageClob.getId());
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[can not save the clob success.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
    }
}

