/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xlob;

import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.module.StorageClob;
import com.horizon.db.xlob.CommonXlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.sql.CLOB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlobProcessorImpl4Oracle
extends CommonXlobProcessor {
    private static Logger logger = LoggerFactory.getLogger(XlobProcessorImpl4Oracle.class);

    @Override
    public void saveUpdateBlob(Connection conn, StorageBlob storageBlob) throws SQLException, IOException {
        block24: {
            if (conn == null) {
                throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
            }
            if (storageBlob == null) {
                throw new HorizonException("\u53c2\u6570storageBlob\u4e3anull.[the parameter storageBlob is null.]");
            }
            if (storageBlob.getTableName() == null) {
                storageBlob.setTableName("TA_HORIZON_BLOB");
                storageBlob.setColumnName("BLOB_CONTENT");
            }
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                String sql;
                if (storageBlob.isNew()) {
                    String objectId = storageBlob.getObjectId();
                    if (this.isNullOrEmpty(objectId)) {
                        throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null or empty value.]");
                    }
                    String primaryId = storageBlob.getId();
                    if (primaryId == null || primaryId.trim().length() == 0) {
                        primaryId = Access.getUUID();
                        storageBlob.setId(primaryId);
                    }
                    sql = "INSERT INTO " + storageBlob.getTableName() + "(ID,OBJECT_ID," + storageBlob.getColumnName() + ") VALUES(?,?,empty_blob())";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, primaryId);
                    pstmt.setString(2, objectId);
                    pstmt.executeUpdate();
                    pstmt.close();
                } else {
                    sql = "UPDATE " + storageBlob.getTableName() + " SET " + storageBlob.getColumnName() + "=empty_blob() WHERE ID=?";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, storageBlob.getId());
                    pstmt.executeUpdate();
                    pstmt.close();
                }
                sql = "SELECT " + storageBlob.getColumnName() + " FROM " + storageBlob.getTableName() + " WHERE ID=? FOR UPDATE";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, storageBlob.getId());
                rs = pstmt.executeQuery();
                if (!rs.next()) break block24;
                InputStream contentStream = storageBlob.getContent();
                this.saveBlob(rs.getBlob(1), contentStream);
                if (contentStream == null) break block24;
                try {
                    contentStream.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                contentStream = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage());
                throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[can not save the blob success.]");
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    rs = null;
                }
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    pstmt = null;
                }
            }
        }
    }

    @Override
    public boolean updateBlob(Connection conn, String tableName, String columnName, InputStream inputStream, String idValue) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u6570\u636e\u5e93\u8868\u540d\u4e3anull\u6216\u7a7a.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a.[columnName is null or empty.]");
        }
        if (inputStream == null) {
            throw new HorizonException("\u8f93\u5165\u6d41\u5bf9\u8c61\u4e3anull.[inputStream is null.]");
        }
        if (this.isNullOrEmpty(idValue)) {
            throw new HorizonException("\u6570\u636e\u8bb0\u5f55\u7684\u4e3b\u952e\u503c\u4e3anull\u6216\u7a7a.[idValue is null or empty.]");
        }
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select count(id) from " + tableName + " where id=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, idValue);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new HorizonException("\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u8bb0\u5f55\u3002\u8868\u540d\uff1a" + tableName + "\uff0c\u4e3b\u952e\u503c\uff1a" + idValue);
            }
            rs.close();
            pstmt.close();
            sql = "UPDATE " + tableName + " SET " + columnName + "=empty_blob() WHERE ID=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, idValue);
            pstmt.executeUpdate();
            pstmt.close();
            sql = "SELECT " + columnName + " FROM " + tableName + " WHERE ID=? FOR UPDATE";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, idValue);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.saveBlob(rs.getBlob(1), inputStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return true;
    }

    @Override
    public void saveUpdateClob(Connection conn, StorageClob storageClob) throws SQLException, IOException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageClob == null) {
            throw new HorizonException("\u53c2\u6570storageClob\u4e3anull.[the parameter storageClob is null.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("CLOB_CONTENT");
            if (logger.isDebugEnabled()) {
                logger.debug("use the default clob table name [TA_HORIZON_CLOB] and column name [CLOB_CONTENT].");
            }
        }
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String sql;
            if (storageClob.isNew()) {
                String objectId = storageClob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can't be a null value.]");
                }
                sql = "insert into " + storageClob.getTableName() + "(ID,OBJECT_ID," + storageClob.getColumnName() + ") values(?,?,empty_clob())";
                String primaryId = Access.getUUID();
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.executeUpdate();
                pstmt.close();
                storageClob.setId(primaryId);
            } else {
                sql = "UPDATE " + storageClob.getTableName() + " SET " + storageClob.getColumnName() + "=empty_clob() WHERE ID=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, storageClob.getId());
                pstmt.executeUpdate();
                pstmt.close();
            }
            sql = "SELECT " + storageClob.getColumnName() + " FROM " + storageClob.getTableName() + " WHERE ID=? FOR UPDATE";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, storageClob.getId());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.saveClobContent(rs.getClob(1), storageClob.getClobContent());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[can not save the clob success.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
    }

    @Override
    public boolean updateClob(Connection conn, String tableName, String columnName, List lstParameters) throws SQLException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u8868\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("Clob\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[columnName is null or empty.]");
        }
        if (lstParameters == null || lstParameters.isEmpty()) {
            throw new HorizonException("\u5305\u542b\u53c2\u6570\u7684\u5217\u8868\u5bf9\u8c61\u4e3anull\u6216\u7a7a.[lstParameters is null or empty.]");
        }
        String id = (String)lstParameters.get(0);
        String content = (String)lstParameters.get(1);
        if (this.isNullOrEmpty(id)) {
            throw new HorizonException("\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u7b2c1\u4e2a\u5143\u7d20(ID\u503c)\u4e3a\u7a7a\u5b57\u7b26\u4e32.[The first element of the List (ID) is an empty string.]");
        }
        boolean flag = false;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String updateEmpty = "UPDATE " + tableName + " SET " + columnName + "=EMPTY_CLOB() WHERE ID=?";
            pstmt = conn.prepareStatement(updateEmpty);
            pstmt.setString(1, id);
            pstmt.executeUpdate();
            pstmt.close();
            String updateEmpty1 = "UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?";
            pstmt = conn.prepareStatement(updateEmpty1);
            StringReader clobReader = new StringReader(content);
            pstmt.setString(2, id);
            pstmt.setCharacterStream(1, clobReader, content.length());
            pstmt.executeUpdate();
            pstmt.close();
            flag = true;
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the clob column.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveClobContent(Clob clob, String clobContent) throws SQLException {
        block15: {
            Writer writer;
            if (clob == null) {
                return;
            }
            if (clobContent == null) {
                clobContent = "";
            }
            int clobLength = clobContent.length();
            if (clob instanceof CLOB) {
                CLOB oracleClob = (CLOB)clob;
                writer = oracleClob.getCharacterOutputStream();
            } else {
                writer = clob.setCharacterStream(clobLength);
            }
            SQLException sqlEx = null;
            BufferedWriter out = new BufferedWriter(writer);
            try {
                out.write(clobContent);
            }
            catch (IOException ex) {
                sqlEx = new SQLException(ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    sqlEx = new SQLException(ex.getMessage());
                }
                if (sqlEx == null) break block15;
                throw sqlEx;
            }
        }
    }
}

