/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xlob;

import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.module.StorageClob;
import com.horizon.db.xlob.CommonXlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlobProcessorImpl4KingBase
extends CommonXlobProcessor {
    private static Logger logger = LoggerFactory.getLogger(XlobProcessorImpl4KingBase.class);

    @Override
    public void saveUpdateBlob(Connection conn, StorageBlob storageBlob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageBlob == null) {
            throw new HorizonException("\u53c2\u6570storageBlob\u4e3anull.[the parameter storageBlob is null.]");
        }
        String tableName = storageBlob.getTableName();
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u8868\u540d.[the StorageBlob object hasn't the table name.]");
        }
        String columnName = storageBlob.getColumnName();
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6eBlob\u5b57\u6bb5\u540d.[the StorageBlob object hasn't the blob column name.]");
        }
        InputStream inputStream = storageBlob.getContent();
        if (inputStream == null) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9\uff08InputStream\u5bf9\u8c61\uff09.[the StorageBlob object hasn't content(An InputStream object).]");
        }
        Statement pstmt = null;
        try {
            if (storageBlob.isNew()) {
                String objectId = storageBlob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null value.]");
                }
                String primaryId = storageBlob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageBlob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + tableName + "(ID,OBJECT_ID," + columnName + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setBinaryStream(3, inputStream, inputStream.available());
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
                pstmt.setBinaryStream(1, inputStream, inputStream.available());
                pstmt.setString(2, storageBlob.getId());
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
    }

    @Override
    public void saveUpdateClob(Connection conn, StorageClob storageClob) throws SQLException, IOException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageClob == null) {
            throw new HorizonException("\u53c2\u6570storageClob\u4e3anull.[the parameter storageClob is null.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("CLOB_CONTENT");
            if (logger.isDebugEnabled()) {
                logger.debug("use the default clob table name [TA_HORIZON_CLOB] and column name [CLOB_CONTENT].");
            }
        }
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String sql;
            if (storageClob.isNew()) {
                String objectId = storageClob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can't be a null value.]");
                }
                sql = "insert into " + storageClob.getTableName() + "(ID,OBJECT_ID," + storageClob.getColumnName() + ") values(?,?,empty_clob())";
                String primaryId = Access.getUUID();
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.executeUpdate();
                pstmt.close();
                storageClob.setId(primaryId);
            } else {
                sql = "UPDATE " + storageClob.getTableName() + " SET " + storageClob.getColumnName() + "=empty_clob() WHERE ID=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, storageClob.getId());
                pstmt.executeUpdate();
                pstmt.close();
            }
            sql = "SELECT " + storageClob.getColumnName() + " FROM " + storageClob.getTableName() + " WHERE ID=? FOR UPDATE";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, storageClob.getId());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.saveClobContent(rs.getClob(1), storageClob.getClobContent());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[can not save the clob success.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
    }

    @Override
    public boolean updateClob(Connection conn, String tableName, String columnName, List lstParameters) throws SQLException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u8868\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("Clob\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[columnName is null or empty.]");
        }
        if (lstParameters == null || lstParameters.isEmpty()) {
            throw new HorizonException("\u5305\u542b\u53c2\u6570\u7684\u5217\u8868\u5bf9\u8c61\u4e3anull\u6216\u7a7a.[lstParameters is null or empty.]");
        }
        String id = (String)lstParameters.get(0);
        String content = (String)lstParameters.get(1);
        if (this.isNullOrEmpty(id)) {
            throw new HorizonException("\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u7b2c1\u4e2a\u5143\u7d20(ID\u503c)\u4e3a\u7a7a\u5b57\u7b26\u4e32.[The first element of the List (ID) is an empty string.]");
        }
        boolean flag = false;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String updateEmpty = "UPDATE " + tableName + " SET " + columnName + "=EMPTY_CLOB() WHERE ID=?";
            pstmt = conn.prepareStatement(updateEmpty);
            pstmt.setString(1, id);
            pstmt.executeUpdate();
            pstmt.close();
            String updateEmpty1 = "UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?";
            pstmt = conn.prepareStatement(updateEmpty1);
            StringReader clobReader = new StringReader(content);
            pstmt.setString(2, id);
            pstmt.setCharacterStream(1, clobReader, content.length());
            pstmt.executeUpdate();
            pstmt.close();
            flag = true;
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the clob column.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveClobContent(Clob clob, String clobContent) throws SQLException {
        block13: {
            if (clob == null) {
                return;
            }
            if (clobContent == null) {
                clobContent = "";
            }
            int clobLength = clobContent.length();
            Writer writer = clob.setCharacterStream(clobLength);
            SQLException sqlEx = null;
            BufferedWriter out = new BufferedWriter(writer);
            try {
                out.write(clobContent);
            }
            catch (IOException ex) {
                sqlEx = new SQLException(ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    sqlEx = new SQLException(ex.getMessage());
                }
                if (sqlEx == null) break block13;
                throw sqlEx;
            }
        }
    }
}

