/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xlob;

import com.horizon.db.Access;
import com.horizon.db.module.StorageBlob;
import com.horizon.db.module.StorageClob;
import com.horizon.db.xlob.XlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonXlobProcessor
implements XlobProcessor {
    private static Logger logger = LoggerFactory.getLogger(CommonXlobProcessor.class);
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize;

    public CommonXlobProcessor() {
        this.setBufferSize(8192);
    }

    public CommonXlobProcessor(int bufferSize) {
        this.setBufferSize(bufferSize);
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 8192) {
            bufferSize = 8192;
        }
        this.bufferSize = bufferSize;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void saveUpdateBlob(Connection conn, StorageBlob storageBlob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageBlob == null) {
            throw new HorizonException("\u53c2\u6570storageBlob\u4e3anull.[the parameter storageBlob is null.]");
        }
        String tableName = storageBlob.getTableName();
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u8868\u540d.[the StorageBlob object hasn't the table name.]");
        }
        String columnName = storageBlob.getColumnName();
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6eBlob\u5b57\u6bb5\u540d.[the StorageBlob object hasn't the blob column name.]");
        }
        InputStream inputStream = storageBlob.getContent();
        if (inputStream == null) {
            throw new HorizonException("StorageBlob\u5bf9\u8c61\u4e2d\u6ca1\u6709\u8bbe\u7f6e\u5185\u5bb9\uff08InputStream\u5bf9\u8c61\uff09.[the StorageBlob object hasn't content(An InputStream object).]");
        }
        StringBuilder build = new StringBuilder();
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            build.append(new String(buffer, 0, len));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(build.toString().getBytes());
        Statement pstmt = null;
        try {
            if (storageBlob.isNew()) {
                String objectId = storageBlob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can not be a null value.]");
                }
                String primaryId = storageBlob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageBlob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + tableName + "(ID,OBJECT_ID," + columnName + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setBinaryStream(3, in, ((InputStream)in).available());
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
                pstmt.setBinaryStream(1, inputStream, inputStream.available());
                pstmt.setString(2, storageBlob.getId());
                pstmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBlob(Connection conn, String keyId, OutputStream outputStream) throws SQLException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull\uff01[The database connection is null.]");
        }
        if (this.isNullOrEmpty(keyId)) {
            throw new HorizonException("keyId\u503c\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32\uff01[The keyId is null or empty.]");
        }
        if (outputStream == null) {
            throw new HorizonException("\u8f93\u51fa\u6d41\u5bf9\u8c61\u4e3anull\uff01[The outputStream object is null.]");
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select BLOB_CONTENT from TA_HORIZON_BLOB where ID=?";
            if (logger.isDebugEnabled()) {
                logger.debug(" \u83b7\u53d6Blob\u5bf9\u8c61\uff1asql=" + sql);
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, keyId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Blob blob = rs.getBlob(1);
                this.getBlob(blob, outputStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }
                pstmt = null;
            }
        }
    }

    @Override
    public void getBlob(Blob blob, OutputStream outputStream) throws SQLException {
        if (blob == null) {
            throw new SQLException("The blob is null.");
        }
        if (outputStream == null) {
            throw new SQLException("The outputStream is null.");
        }
        InputStream inputStream = blob.getBinaryStream();
        this.exchangeStream(inputStream, outputStream);
    }

    @Override
    public void saveBlob(Blob blob, InputStream inputStream) throws SQLException {
        if (blob == null) {
            throw new SQLException("The blob is null.");
        }
        if (inputStream == null) {
            throw new SQLException("The inputStream is null.");
        }
        OutputStream outputStream = blob.setBinaryStream(1L);
        this.exchangeStream(inputStream, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exchangeStream(InputStream inputStream, OutputStream outputStream) throws SQLException {
        if (inputStream == null) {
            return;
        }
        if (outputStream == null) {
            return;
        }
        if (this.bufferSize < 0) {
            this.bufferSize = 8192;
        }
        InputStream input = inputStream instanceof BufferedInputStream ? inputStream : new BufferedInputStream(inputStream);
        OutputStream output = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        int endCondition = -1;
        byte[] tmpBuffer = new byte[this.bufferSize];
        try {
            int readSize = input.read(tmpBuffer);
            while (readSize > -1) {
                output.write(tmpBuffer, 0, readSize);
                readSize = input.read(tmpBuffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                output.flush();
                output.close();
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean updateBlob(Connection conn, String tableName, String columnName, InputStream inputStream, String idValue) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u6570\u636e\u5e93\u8868\u540d\u4e3anull\u6216\u7a7a.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a.[columnName is null or empty.]");
        }
        if (inputStream == null) {
            throw new HorizonException("\u8f93\u5165\u6d41\u5bf9\u8c61\u4e3anull.[inputStream is null.]");
        }
        if (this.isNullOrEmpty(idValue)) {
            throw new HorizonException("\u6570\u636e\u8bb0\u5f55\u7684\u4e3b\u952e\u503c\u4e3anull\u6216\u7a7a.[idValue is null or empty.]");
        }
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select count(id) from " + tableName + " where id=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, idValue);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                logger.error("\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u8bb0\u5f55\u3002\u8868\u540d\uff1a" + tableName + "\uff0c\u4e3b\u952e\u503c\uff1a" + idValue);
                boolean bl = false;
                return bl;
            }
            rs.close();
            pstmt.close();
            pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
            pstmt.setBinaryStream(1, inputStream, inputStream.available());
            pstmt.setString(2, idValue);
            pstmt.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58BLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the blob content.]");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return true;
    }

    @Override
    public void saveUpdateClob(Connection conn, StorageClob storageClob) throws Exception {
        this.saveUpdateClobByBytes(conn, storageClob, "UTF-8");
    }

    protected boolean saveUpdateClobByString(Connection conn, StorageClob storageClob) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageClob == null) {
            throw new HorizonException("\u53c2\u6570storageClob\u4e3anull.[the parameter storageClob is null.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("CLOB_CONTENT");
            if (logger.isDebugEnabled()) {
                logger.debug("use the default clob table name [TA_HORIZON_CLOB] and column name [CLOB_CONTENT].");
            }
        }
        boolean isOk = false;
        Statement pstmt = null;
        try {
            if (storageClob.isNew()) {
                String objectId = storageClob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can't be a null value.]");
                }
                String primaryId = storageClob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageClob.setId(primaryId);
                }
                pstmt = conn.prepareStatement("INSERT INTO " + storageClob.getTableName() + "(ID,OBJECT_ID," + storageClob.getColumnName() + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setString(3, storageClob.getClobContent());
                pstmt.executeUpdate();
            } else {
                pstmt = conn.prepareStatement("UPDATE " + storageClob.getTableName() + " SET " + storageClob.getColumnName() + "=? WHERE ID=?");
                pstmt.setString(1, storageClob.getClobContent());
                pstmt.setString(2, storageClob.getId());
                pstmt.executeUpdate();
            }
            isOk = true;
        }
        catch (Exception ex) {
            isOk = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the clob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return isOk;
    }

    protected boolean saveUpdateClobByBytes(Connection conn, StorageClob storageClob, String charset) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (storageClob == null) {
            throw new HorizonException("\u53c2\u6570storageClob\u4e3anull.[the parameter storageClob is null.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("CLOB_CONTENT");
            if (logger.isDebugEnabled()) {
                logger.debug("use the default clob table name [TA_HORIZON_CLOB] and column name [CLOB_CONTENT].");
            }
        }
        boolean isOk = false;
        Statement pstmt = null;
        try {
            if (storageClob.isNew()) {
                String objectId = storageClob.getObjectId();
                if (this.isNullOrEmpty(objectId)) {
                    throw new HorizonException("\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a\uff01[object id can't be a null value.]");
                }
                String primaryId = storageClob.getId();
                if (primaryId == null || primaryId.trim().length() == 0) {
                    primaryId = Access.getUUID();
                    storageClob.setId(primaryId);
                }
                byte[] bytes = storageClob.getClobContent().getBytes(charset);
                ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
                int length = bytes.length;
                pstmt = conn.prepareStatement("INSERT INTO " + storageClob.getTableName() + "(ID,OBJECT_ID," + storageClob.getColumnName() + ") VALUES(?,?,?)");
                pstmt.setString(1, primaryId);
                pstmt.setString(2, objectId);
                pstmt.setAsciiStream(3, inputstream, length);
                pstmt.executeUpdate();
            } else {
                byte[] bytes = storageClob.getClobContent().getBytes(charset);
                ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
                int length = bytes.length;
                pstmt = conn.prepareStatement("UPDATE " + storageClob.getTableName() + " SET " + storageClob.getColumnName() + "=? WHERE ID=?");
                pstmt.setAsciiStream(1, inputstream, length);
                pstmt.setString(2, storageClob.getId());
                pstmt.executeUpdate();
            }
            isOk = true;
        }
        catch (Exception ex) {
            isOk = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the clob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return isOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClob(Connection conn, StorageClob storageClob) throws SQLException {
        if (storageClob == null) {
            throw new HorizonException("\u65e0\u6cd5\u83b7\u53d6\u5230Clob\u5bf9\u8c61\uff01[can not get the StorageClob object.]");
        }
        if (conn == null) {
            throw new HorizonException("\u65e0\u6cd5\u83b7\u53d6\u5230\u6570\u636e\u5e93\u7684\u8fde\u63a5\uff01[can not get the database connection.]");
        }
        if (storageClob.getTableName() == null) {
            storageClob.setTableName("TA_HORIZON_CLOB");
            storageClob.setColumnName("clob_content");
        }
        Statement pstmt = null;
        ResultSet rs = null;
        String bigText = null;
        try {
            String sql = "select " + storageClob.getColumnName() + " from " + storageClob.getTableName() + " where ID=?";
            if (logger.isDebugEnabled()) {
                logger.debug(" \u83b7\u53d6Clob\u5bf9\u8c61\uff1asql=" + sql);
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, storageClob.getId());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                Clob clob = rs.getClob(1);
                bigText = this.getClobContent(clob);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }
                rs = null;
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }
                pstmt = null;
            }
        }
        return bigText;
    }

    @Override
    public String getClobContent(Clob clob) throws SQLException {
        if (clob == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        try {
            char[] charBuffer = new char[this.getBufferSize()];
            BufferedReader in = new BufferedReader(clob.getCharacterStream());
            int readLen = in.read(charBuffer);
            while (readLen > 0) {
                buf.append(charBuffer, 0, readLen);
                readLen = in.read(charBuffer);
            }
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return buf.toString();
    }

    @Override
    public boolean updateClob(Connection conn, String tableName, String columnName, List lstParameters) throws SQLException {
        boolean flag = false;
        try {
            String charset = this.getClobCharset();
            flag = this.updateClobByBytes(conn, tableName, columnName, lstParameters, charset);
        }
        catch (Exception ex) {
            flag = false;
        }
        return flag;
    }

    protected boolean updateClobByString(Connection conn, String tableName, String columnName, List lstParameters) throws SQLException {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u8868\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("Clob\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[columnName is null or empty.]");
        }
        if (lstParameters == null || lstParameters.isEmpty()) {
            throw new HorizonException("\u5305\u542b\u53c2\u6570\u7684\u5217\u8868\u5bf9\u8c61\u4e3anull\u6216\u7a7a.[lstParameters is null or empty.]");
        }
        String id = (String)lstParameters.get(0);
        if (this.isNullOrEmpty(id)) {
            throw new HorizonException("\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u7b2c1\u4e2a\u5143\u7d20(ID\u503c)\u4e3a\u7a7a\u5b57\u7b26\u4e32.[The first element of the List (ID) is an empty string.]");
        }
        String content = (String)lstParameters.get(1);
        boolean flag = false;
        Statement pstmt = null;
        try {
            String updateClob = "UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?";
            pstmt = conn.prepareStatement(updateClob);
            pstmt.setString(1, content);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
            flag = true;
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u4fdd\u5b58CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to save the clob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    logger.error(ex.getMessage());
                }
                pstmt = null;
            }
        }
        return flag;
    }

    private boolean updateClobByBytes(Connection conn, String tableName, String columnName, List lstParameters, String charset) throws Exception {
        if (conn == null) {
            throw new HorizonException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3anull.[database connection is null.]");
        }
        if (this.isNullOrEmpty(tableName)) {
            throw new HorizonException("\u8868\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[tableName is null or empty.]");
        }
        if (this.isNullOrEmpty(columnName)) {
            throw new HorizonException("Clob\u5b57\u6bb5\u540d\u4e3anull\u6216\u7a7a\u5b57\u7b26\u4e32.[columnName is null or empty.]");
        }
        if (lstParameters == null || lstParameters.isEmpty()) {
            throw new HorizonException("\u5305\u542b\u53c2\u6570\u7684\u5217\u8868\u5bf9\u8c61\u4e3anull\u6216\u7a7a.[lstParameters is null or empty.]");
        }
        if (lstParameters.size() < 2) {
            throw new HorizonException("\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u5305\u542b\u7684\u53c2\u6570\u4e0d\u591f.[lstParameters is null or empty.]");
        }
        String id = (String)lstParameters.get(0);
        if (this.isNullOrEmpty(id)) {
            throw new HorizonException("\u53c2\u6570\u5217\u8868\u5bf9\u8c61\u4e2d\u7684\u7b2c1\u4e2a\u5143\u7d20(ID\u503c)\u4e3a\u7a7a\u5b57\u7b26\u4e32.[The first element of the List (ID) is an empty string.]");
        }
        String content = (String)lstParameters.get(1);
        boolean flag = false;
        Statement pstmt = null;
        try {
            byte[] bytes = content.getBytes(charset);
            ByteArrayInputStream inputstream = new ByteArrayInputStream(bytes);
            int length = bytes.length;
            pstmt = conn.prepareStatement("UPDATE " + tableName + " SET " + columnName + "=? WHERE ID=?");
            pstmt.setAsciiStream(1, inputstream, length);
            pstmt.setString(2, id);
            pstmt.executeUpdate();
            flag = true;
        }
        catch (Exception ex) {
            flag = false;
            ex.printStackTrace();
            logger.error(ex.getMessage());
            throw new HorizonException("\u66f4\u65b0CLOB\u5927\u5b57\u6bb5\u64cd\u4f5c\u5931\u8d25\uff01[failed to update the clob content.]");
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                pstmt = null;
            }
        }
        return flag;
    }

    protected String getClobCharset() {
        return "UTF-8";
    }

    protected boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

