/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xconnection.provider;

import com.horizon.datasource.registry.DataSourceRegistry;
import com.horizon.datasource.registry.DataSourceRegistryFactory;
import com.horizon.db.xconnection.provider.ConnectionProvider;
import com.horizon.exception.HorizonException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

class ConnectionProviderJNDI
implements ConnectionProvider {
    private String dataSourceName;

    ConnectionProviderJNDI() {
    }

    @Override
    public Connection getConnection() {
        DataSource dataSource = this.generateDataSource();
        if (dataSource == null) {
            return null;
        }
        try {
            Connection conn = dataSource.getConnection();
            return conn;
        }
        catch (SQLException sqlEx) {
            throw new HorizonException("\u672a\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5\u3002(Can't get the database connection) dataSourceName: " + this.dataSourceName);
        }
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName.trim();
    }

    private DataSource generateDataSource() {
        DataSourceRegistry registry = DataSourceRegistryFactory.INSTANCE.getDataSourceRegistry();
        return registry.getDataSourceOfTenant(this.dataSourceName);
    }
}

