/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xconnection.provider;

import com.horizon.common.base.Objects;
import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.registry.DataSourceRegistryFactory;
import com.horizon.db.xconnection.provider.ConnectionProvider;
import com.horizon.db.xconnection.provider.ConnectionProviderJNDI;
import com.horizon.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionProviderFactory {
    private static final ConnectionProviderFactory cp = new ConnectionProviderFactory();
    private static final Map<String, ConnectionProvider> mapConnectionProvider = new HashMap<String, ConnectionProvider>();
    private static final Map<String, DatabaseConnectionInfo> mapDatabaseConnectionInfo = new HashMap<String, DatabaseConnectionInfo>();
    private ConnectionProvider defaultConnectionProvider;
    private String defaultConnectionIdentifier;

    public static ConnectionProviderFactory getInstance() {
        return cp;
    }

    public void setDatabaseConnectionInfo(DatabaseConnectionInfo ... connectionInfos) {
        if (connectionInfos == null) {
            return;
        }
        for (DatabaseConnectionInfo connectionInfo : connectionInfos) {
            String identifier = connectionInfo.getIdentifier();
            ConnectionProvider provider = this.createProvider(connectionInfo);
            if (connectionInfo.isDefault()) {
                this.defaultConnectionIdentifier = identifier;
                this.defaultConnectionProvider = provider;
            }
            mapConnectionProvider.put(identifier, provider);
            mapDatabaseConnectionInfo.put(identifier, connectionInfo);
            DataSourceRegistryFactory.INSTANCE.createDataSourceRegistry(connectionInfo);
        }
    }

    private ConnectionProvider createProvider(DatabaseConnectionInfo dbConnInfo) {
        ConnectionProviderJNDI jndiProvider = new ConnectionProviderJNDI();
        jndiProvider.setDataSourceName(dbConnInfo.getIdentifier());
        return jndiProvider;
    }

    public ConnectionProvider getConnectionProvider(String identifier) {
        if (Objects.equal((Object)this.defaultConnectionIdentifier, (Object)identifier)) {
            return this.defaultConnectionProvider;
        }
        return mapConnectionProvider.get(identifier);
    }

    public DatabaseConnectionInfo getDatabaseConnectionInfo(String identifier) {
        return mapDatabaseConnectionInfo.get(identifier);
    }

    public DatabaseConnectionInfo getDefaultDatabaseConnectionInfo() {
        return mapDatabaseConnectionInfo.get(this.defaultConnectionIdentifier);
    }

    public List<DatabaseConnectionInfo> getAllDatabaseConnectionInfo() {
        ArrayList<DatabaseConnectionInfo> list = new ArrayList<DatabaseConnectionInfo>();
        for (Map.Entry<String, DatabaseConnectionInfo> entry : mapDatabaseConnectionInfo.entrySet()) {
            String key = entry.getKey();
            if (!StringUtil.hasValue(key)) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public void distoryDatabaseInfo(String identifier) {
        mapDatabaseConnectionInfo.remove(identifier);
        mapConnectionProvider.remove(identifier);
    }
}

