/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.xconnection;

import com.horizon.db.DBConfigInfoHelper;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xconnection.provider.ConnectionProvider;
import com.horizon.db.xconnection.provider.ConnectionProviderFactory;
import java.sql.Connection;

public class ConnectionFactory {
    private ConnectionFactory() {
    }

    public static Connection getConnection(String identifier) throws InvalidIdentifierException {
        if (identifier == null || identifier.trim().length() == 0) {
            identifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        }
        identifier = identifier.trim();
        ConnectionProviderFactory cpFactory = ConnectionProviderFactory.getInstance();
        ConnectionProvider cp = cpFactory.getConnectionProvider(identifier);
        if (cp != null) {
            return cp.getConnection();
        }
        throw new InvalidIdentifierException("\u6ca1\u6709\u76f8\u5e94\u6807\u8bc6\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u914d\u7f6e\u4fe1\u606f\uff1b\u8bf7\u6ce8\u610f\u8be5\u6807\u8bc6\u533a\u5206\u5927\u5c0f\u5199\u3002(No suited db-config-info with the appointed identifier; Attention: the identifier is sensitive case)\u3002identifier\uff1a" + identifier);
    }

    public static Connection getDefaultConnection() throws InvalidIdentifierException {
        String defaultIdentifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        return ConnectionFactory.getConnection(defaultIdentifier);
    }
}

