/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.sql;

import com.horizon.db.sql.AbstractSQLDiaect;
import com.horizon.db.sql.SqlUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDiaect
extends AbstractSQLDiaect {
    private static Logger logger = LoggerFactory.getLogger(SqlServerDiaect.class);
    private static final String keywordSelect = "select ";
    private static final String keywordFrom = " from ";
    private static final String STAR = "*";
    private static final String COMMA = ",";
    private static final String AS = " as ";
    private static final String SPACE = " ";
    private static final String AS2 = ")as ";
    private static final String rightKh = ")";
    private static final String regexAS = "\\s+as\\s+";
    private static final String regexAS2 = "\\)\\s*as\\s+";
    private static final String regexRightKh = "\\)\\s*";
    private static final String regex_Replace_PreffixColumn_Alias = "[^\\s,]+\\.";
    private static final String regex_union = "\\s+union\\s+";
    private static final String BRACKET_LEFT = "(";
    private static final String BRACKET_RIGHT = ")";
    private static String[] sqlserver = new String[]{" + ", "getdate()", "convert(char(10),HZSQL_TMP_PARA,20)", "convert(char(8),HZSQL_TMP_PARA,108)", "substring", "dateadd(mm,HZSQL_TMP_PARA_NO,HZSQL_TMP_PARA_DATE)", "charindex(HZSQL_TMP_PARA_STR,HZSQL_TMP_PARA_SUBSTR,HZSQL_TMP_PARA_NO)", "len", "replace(HZSQL_TMP_SOURCE_STR,HZSQL_TMP_START_POS,HZSQL_TMP_END_POS,HZSQL_TMP_REPLACEMENT_STR)", "convert(char(7),HZSQL_TMP_PARA,20)", "convert(char(4),HZSQL_TMP_PARA,20)", "convert(char(10),HZSQL_TMP_PARA,20)"};

    @Override
    protected String[] getKey() {
        return sqlserver;
    }

    @Override
    public String deal_HZSQL_REPLACE(String sql) {
        Pattern p = Pattern.compile(this.hzoasqlexp[8]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0).toString());
            if (argm.find() && !(argments = SqlServerDiaect.splitargs(argm.group(0).toString()))[1].equals("")) {
                formula = sqlserver[8].replaceAll("HZSQL_TMP_SOURCE_STR", argments[1]);
                String para1 = argments[1].substring(1, argments[1].length() - 1);
                String para2 = argments[2].substring(1, argments[2].length() - 1);
                formula = formula.replaceAll("HZSQL_TMP_START_POS", String.valueOf(para1.indexOf(para2) + 1));
                formula = formula.replaceAll("HZSQL_TMP_END_POS", String.valueOf(para2.length()));
                formula = formula.replaceAll("HZSQL_TMP_REPLACEMENT_STR", argments[3]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String getPaginationSQL(String strSQL, int iPageNo, int iPageSize, List lstConditions) {
        if (strSQL == null) {
            logger.error("\u975e\u6cd5\u7684SQL\u8bed\u53e5(Invalid sql): null");
            return null;
        }
        if (iPageNo < 1) {
            logger.error("\u975e\u6cd5\u7684\u9875\u53f7(Invalid page number): " + iPageNo);
            return strSQL;
        }
        if (iPageSize < 1) {
            logger.error("\u975e\u6cd5\u7684\u6bcf\u9875\u8bb0\u5f55\u6570(Invalid page size): " + iPageSize);
            return strSQL;
        }
        if ((strSQL = strSQL.trim()).length() == 0) {
            logger.error("SQL\u8bed\u53e5\u4e3a\u7a7a(The sql is empty)");
            return strSQL;
        }
        String sql = this.getPaginationSQLFor2005(strSQL, iPageNo, iPageSize);
        return sql;
    }

    private String getPaginationSQLFor2005(String strSql, int pageNo, int pageSize) {
        int endRecoderNo = pageNo * pageSize;
        int startRecoderNo = endRecoderNo - pageSize + 1;
        String strSQL = strSql.replaceAll("[\r\n]", SPACE).replaceAll("\\s{2,}", SPACE);
        int indexOrderNo = this.getOrderByLastIndex(strSQL);
        String strOrderByColumns = null;
        if (indexOrderNo > 0) {
            strOrderByColumns = strSQL.substring(indexOrderNo).toUpperCase();
            if (strOrderByColumns.indexOf(")") >= 0) {
                strOrderByColumns = strOrderByColumns.substring(0, strOrderByColumns.indexOf(")"));
            }
            strOrderByColumns = strOrderByColumns.replaceAll("ORDER BY", "");
            strOrderByColumns = strOrderByColumns.replaceAll(regex_Replace_PreffixColumn_Alias, "");
            int index = strSQL.indexOf(")", indexOrderNo);
            String orderBy = index < 0 ? strSQL.substring(indexOrderNo) : strSQL.substring(indexOrderNo, index);
            strSql = strSQL.replace(orderBy, "");
        } else {
            String selectColumns = this.getSelectColumns(strSQL);
            strOrderByColumns = this.getParsedOrderByColumns(selectColumns);
        }
        String sql = this.getFullPagingSql(strSql, strOrderByColumns, startRecoderNo, endRecoderNo);
        return sql;
    }

    private String getSelectColumns(String sql) {
        int idxSelect = sql.trim().toLowerCase().indexOf(keywordSelect);
        if (idxSelect < 0) {
            throw new RuntimeException("Invalid sql: Not existed 'select' in the sql: " + sql);
        }
        int idxFrom = SqlUtil.findComparedIndex4FirstSelect(sql, keywordFrom);
        String selectColumns = sql.substring(idxSelect + keywordSelect.length(), idxFrom);
        return selectColumns;
    }

    private String getParsedOrderByColumns(String selectColumns) {
        if (STAR.equals(selectColumns)) {
            return "id";
        }
        selectColumns = selectColumns.replaceAll(regex_Replace_PreffixColumn_Alias, "");
        if ((selectColumns = selectColumns.trim()).indexOf(COMMA) > 0) {
            String[] columns = selectColumns.split("\\,");
            StringBuffer sbColumns = new StringBuffer();
            int len = columns.length;
            for (int i = 0; i < len; ++i) {
                String tmpColumn;
                String[] cols;
                String column = columns[i].trim().toLowerCase();
                if (column.lastIndexOf(AS) > 0) {
                    cols = column.split(regexAS);
                    tmpColumn = cols[cols.length - 1];
                } else if (column.lastIndexOf(AS2) > 0) {
                    cols = column.split(regexAS2);
                    tmpColumn = cols[cols.length - 1];
                } else if (column.lastIndexOf(")") > 0) {
                    cols = column.split(regexRightKh);
                    tmpColumn = cols[cols.length - 1].trim();
                } else if (column.lastIndexOf(SPACE) > 0) {
                    cols = column.split(SPACE);
                    tmpColumn = cols[cols.length - 1];
                } else {
                    tmpColumn = column;
                }
                if (sbColumns.length() > 0) {
                    sbColumns.append(COMMA);
                }
                sbColumns.append(tmpColumn);
            }
            selectColumns = sbColumns.toString();
        }
        String orderByColumns = selectColumns;
        return orderByColumns;
    }

    private String getFullPagingSql(String sql, String orderByColumns, int startRecoderNo, int endRecoderNo) {
        orderByColumns = orderByColumns.toUpperCase();
        orderByColumns = orderByColumns.replaceAll("DISTINCT", "");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select * from (select ROW_NUMBER() OVER(order by ");
        sbSql.append(orderByColumns);
        sbSql.append(") rownumber_, a.* from (");
        sbSql.append(sql);
        sbSql.append(") a) b where b.rownumber_ between ");
        sbSql.append(startRecoderNo).append(" and ").append(endRecoderNo);
        String pagingSql = sbSql.toString();
        return pagingSql;
    }

    @Override
    public String deal_HZSQL_ORDERBY(String sql) {
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(this.hzoasqlexp[13]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        Pattern pattern = Pattern.compile("COUNT\\s*\\([^)]+\\s*\\)");
        Matcher matcher = pattern.matcher(sql.toUpperCase());
        if (matcher.find()) {
            m.appendReplacement(sb, "");
            m.appendTail(sb);
            return sb.toString();
        }
        Matcher argm = argp.matcher(m.group(0));
        if (argm.find()) {
            String[] argments = SqlServerDiaect.splitargs(argm.group(0));
            m.appendReplacement(sb, " ORDER BY " + argments[1]);
            m.appendTail(sb);
        }
        sql = sb.toString().toUpperCase().replaceFirst("SELECT", "SELECT TOP(100) ");
        return sql;
    }

    @Override
    public String getTableNameSql() {
        return "select name from sysobjects where xtype='u'";
    }

    public static void main(String[] args) {
        String sql = "";
        sql = "select ai.a,b,c,d,(select e from te) as ee from t_hzcms_article_info ai";
        sql = sql + " union select ai.a,b,c,d,(select e from te) as ee from t_hzcms_article_info ai";
        SqlServerDiaect sqlDiaect = new SqlServerDiaect();
        String sql1 = sqlDiaect.getPaginationSQL(sql, 2, 10, null);
        System.out.println(sql1);
    }
}

