/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.sql;

import com.horizon.db.sql.SQLParser;
import com.horizon.db.sql.SqlServerDiaect;
import com.horizon.db.sql.SqlUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServer2000Diaect
extends SqlServerDiaect {
    private static Logger logger = LoggerFactory.getLogger(SQLParser.class);

    @Override
    public String getPaginationSQL(String strSQL, int iPageNo, int iPageSize, List lstConditions) {
        if (strSQL == null) {
            logger.error("\u975e\u6cd5\u7684SQL\u8bed\u53e5(Invalid sql): null");
            return null;
        }
        if (iPageNo < 1) {
            logger.error("\u975e\u6cd5\u7684\u9875\u53f7(Invalid page number): " + iPageNo);
            return strSQL;
        }
        if (iPageSize < 1) {
            logger.error("\u975e\u6cd5\u7684\u6bcf\u9875\u8bb0\u5f55\u6570(Invalid page size): " + iPageSize);
            return strSQL;
        }
        if ((strSQL = strSQL.trim()).length() == 0) {
            logger.error("SQL\u8bed\u53e5\u4e3a\u7a7a(The sql is empty)");
            return strSQL;
        }
        String sql = this.getPaginationSQLFor2000(strSQL, iPageNo, iPageSize, lstConditions);
        return sql;
    }

    private String getPaginationSQLFor2000(String strSql, int pageNo, int pageSize, List lstConditions) {
        if (pageNo == 1) {
            String sql = this.getFirstPageSql(strSql, pageSize);
            return sql;
        }
        String sql = this.getAfterFirstPageSql(strSql, pageNo, pageSize);
        if (lstConditions != null && !lstConditions.isEmpty()) {
            lstConditions.addAll(lstConditions);
        }
        return sql;
    }

    private String getFirstPageSql(String strSQL, int iPageSize) {
        String strTemSql = strSQL.toLowerCase();
        int idxSelect = strTemSql.indexOf("select");
        if (idxSelect == -1) {
            logger.error("\u975e\u6cd5\u7684SQL\u8bed\u53e5\uff08\u4e0d\u5b58\u5728select\u5173\u952e\u5b57\uff09(Invalid search sql: not exist 'select').");
            return strSQL;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(iPageSize);
        sb.append(" * from (").append(strSQL).append(") a");
        strTemSql = sb.toString();
        return strTemSql;
    }

    private String getAfterFirstPageSql(String strSQL, int iPageNo, int iPageSize) {
        int idxSelect = (strSQL = strSQL.trim().replaceAll("\\s+", " ")).toLowerCase().indexOf("select");
        if (idxSelect == -1) {
            logger.error("Invalid search sql: not exist 'select'.");
            return strSQL;
        }
        int idxFrom = SqlUtil.findComparedIndex4FirstSelect(strSQL, "from");
        if (idxFrom == -1) {
            logger.error("Invalid sql: " + strSQL);
            return strSQL;
        }
        String strTemSql = strSQL;
        int idxOrderBy = -1;
        Pattern p = Pattern.compile("\\s+order\\s+by\\s+", 2);
        Matcher m = p.matcher(strTemSql);
        while (m.find()) {
            idxOrderBy = m.start();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select TOP ").append(iPageSize);
        sb.append(strSQL.substring(idxSelect + 6, idxFrom));
        sb.append(" from ");
        int idxWhere = SqlUtil.findComparedIndex4FirstSelect(strSQL, "where");
        if (idxWhere > 0) {
            sb.append(strSQL.substring(idxFrom + 4, idxWhere));
        } else {
            sb.append(strSQL.substring(idxFrom + 4));
        }
        sb.append(" where ID NOT IN(");
        sb.append("SELECT TOP ").append((iPageNo - 1) * iPageSize).append(" ID FROM ").append(strSQL.substring(idxFrom + 4));
        if (idxOrderBy > 0) {
            sb.append(",ID");
        } else {
            sb.append(" ORDER BY ID");
        }
        sb.append(")");
        if (idxWhere > 0) {
            sb.append(" AND ");
            sb.append(strSQL.substring(idxWhere + 5));
        }
        if (idxOrderBy > 0) {
            sb.append(",ID");
        } else {
            sb.append(" ORDER BY ID");
        }
        String sql = sb.toString();
        return sql;
    }

    private static String getAfterFirstPageSql2(String strSQL, int iPageNo, int iPageSize) {
        StringBuffer sb = new StringBuffer();
        sb.append("select top ").append(iPageSize).append(" * from (");
        sb.append(strSQL);
        sb.append(") a where a.id not in (");
        sb.append("select top ").append((iPageNo - 1) * iPageSize).append(" id from (");
        sb.append(strSQL);
        sb.append(") b");
        sb.append(")");
        String strTemSql = sb.toString();
        return strTemSql;
    }

    public static void main(String[] args) {
        SqlServer2000Diaect sqlDiaect = new SqlServer2000Diaect();
        String sql = "select * from t_hzcms_article_info";
        String sql1 = sqlDiaect.getPaginationSQLFor2000(sql, 2, 10, null);
        System.out.println(sql1);
    }
}

