/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.sql;

import com.horizon.db.DBConfigInfoHelper;
import com.horizon.db.sql.AbstractSQLDiaect;
import com.horizon.db.sql.DB2Diaect;
import com.horizon.db.sql.DMDiaect;
import com.horizon.db.sql.GBase8sDiaect;
import com.horizon.db.sql.GBaseDiaect;
import com.horizon.db.sql.GaussDiaect;
import com.horizon.db.sql.HighgoDiaect;
import com.horizon.db.sql.KingBaseDiaect;
import com.horizon.db.sql.MysqlDiaect;
import com.horizon.db.sql.OracleDiaect;
import com.horizon.db.sql.OscarDiaect;
import com.horizon.db.sql.PostgresqlDiaect;
import com.horizon.db.sql.SQLDiaect;
import com.horizon.db.sql.SqlServer2000Diaect;
import com.horizon.db.sql.SqlServerDiaect;
import com.horizon.db.sql.TiDbDiaect;
import com.horizon.db.sql.UpbaseDiaect;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.exception.HorizonException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLParser {
    private static Logger LOGGER = LoggerFactory.getLogger(SQLParser.class);
    private SQLDiaect sqlDiaect;

    public SQLParser(SQLDiaect sqlDiaect) {
        this.sqlDiaect = sqlDiaect;
    }

    public SQLParser(String dbType, String dbProductVersion) {
        if (dbType == null || dbType.trim().length() == 0) {
            try {
                String strIdentifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
                dbType = DBConfigInfoHelper.getDatabaseType(strIdentifier);
            }
            catch (InvalidIdentifierException e) {
                throw new HorizonException(e.getMessage(), e);
            }
        }
        if (dbType == null || dbType.trim().length() == 0) {
            throw new HorizonException("\u6570\u636e\u5e93\u7c7b\u578b\u4e3anull\u6216\u7a7a\u3002");
        }
        this.sqlDiaect = this.getSqlDiaect(dbType, dbProductVersion);
        if (this.sqlDiaect == null) {
            LOGGER.error("Unknown database type: " + dbType);
            throw new HorizonException("\u672a\u77e5\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbType);
        }
    }

    private SQLDiaect getSqlDiaect(String dbType, String dbProductVersion) {
        dbType = dbType.trim().replaceAll(" ", "").toUpperCase();
        AbstractSQLDiaect sqlDiaect = null;
        if ("ORACLE".equalsIgnoreCase(dbType)) {
            sqlDiaect = new OracleDiaect();
        } else if ("SQLSERVER".equalsIgnoreCase(dbType)) {
            if (dbProductVersion != null) {
                dbProductVersion = dbProductVersion.replaceAll(" ", "");
                sqlDiaect = (dbProductVersion = dbProductVersion.toLowerCase()).contains("sqlserver2000") || dbProductVersion.startsWith("8.00") ? new SqlServer2000Diaect() : new SqlServerDiaect();
            } else {
                LOGGER.error("The database ProductVersion is null.");
                sqlDiaect = new SqlServerDiaect();
            }
        } else if ("MYSQL".equalsIgnoreCase(dbType) || "MYSQL8".equalsIgnoreCase(dbType)) {
            sqlDiaect = new MysqlDiaect();
        } else if ("DB2".equalsIgnoreCase(dbType)) {
            sqlDiaect = new DB2Diaect();
        } else if ("KINGBASE".equalsIgnoreCase(dbType) || "KINGBASE8".equalsIgnoreCase(dbType)) {
            sqlDiaect = new KingBaseDiaect();
        } else if ("DM".equalsIgnoreCase(dbType)) {
            sqlDiaect = new DMDiaect();
        } else if ("GBASE".equalsIgnoreCase(dbType)) {
            sqlDiaect = new GBaseDiaect();
        } else if ("GBASE8S".equalsIgnoreCase(dbType)) {
            sqlDiaect = new GBase8sDiaect();
        } else if ("POSTGRESQL".equalsIgnoreCase(dbType)) {
            sqlDiaect = new PostgresqlDiaect();
        } else if ("HIGHGO".equalsIgnoreCase(dbType)) {
            sqlDiaect = new HighgoDiaect();
        } else if ("OSCAR".equalsIgnoreCase(dbType)) {
            sqlDiaect = new OscarDiaect();
        } else if ("UPBASE".equalsIgnoreCase(dbType)) {
            sqlDiaect = new UpbaseDiaect();
        } else if ("GAUSS".equalsIgnoreCase(dbType)) {
            sqlDiaect = new GaussDiaect();
        } else if ("TIDB".equalsIgnoreCase(dbType)) {
            sqlDiaect = new TiDbDiaect();
        }
        return sqlDiaect;
    }

    public String parse(String sql) {
        if (this.sqlDiaect == null) {
            return sql;
        }
        if ((sql = this.sqlDiaect.deal_null(sql)).indexOf("HZSQL_CONCAT") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_CONCAT(sql);
        }
        if (sql.indexOf("HZSQL_REPLACE") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_REPLACE(sql);
        }
        if (sql.indexOf("HZSQL_INSTR") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_INSTR(sql);
        }
        if (sql.indexOf("HZSQL_ADDMONTH") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_ADDMONTH(sql);
        }
        if (sql.indexOf("HZSQL_GETTIME") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETTIME(sql);
        }
        if (sql.indexOf("HZSQL_GETDATE") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETDATE(sql);
        }
        if (sql.indexOf("HZSQL_GETYM") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETYM(sql);
        }
        if (sql.indexOf("HZSQL_GETYEAR") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETYEAR(sql);
        }
        if (sql.indexOf("HZSQL_GETDATETIME") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETDATETIME(sql);
        }
        if (sql.indexOf("HZSQL_ORDERBY") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_ORDERBY(sql);
        }
        if (sql.indexOf("HZSQL_GETSYSDATE") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_GETSYSDATE(sql);
        }
        if (sql.indexOf("HZSQL_LENGTH") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_LENGTH(sql);
        }
        if (sql.indexOf("HZSQL_SUBSTR") > 0) {
            sql = this.sqlDiaect.deal_HZSQL_SUBSTR(sql);
        }
        return sql;
    }

    public String getPaginationSQL(String strSQL, int iPageNo, int iPageSize, List lstConditions) {
        return this.sqlDiaect.getPaginationSQL(strSQL, iPageNo, iPageSize, lstConditions);
    }

    public String getTableNameSql() {
        return this.sqlDiaect.getTableNameSql();
    }
}

