/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.sql;

import com.horizon.db.sql.SQLDiaect;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

abstract class AbstractSQLDiaect
implements SQLDiaect {
    protected final String[] hzoasqlexp = new String[]{"HZSQL_CONCAT\\s*\\([^)]+\\s*\\)", "HZSQL_GETSYSDATE", "HZSQL_GETDATE\\s*\\([^)]+\\s*\\)", "HZSQL_GETTIME\\s*\\([^)]+\\s*\\)", "HZSQL_SUBSTR\\s*\\([^)]+\\s*\\)", "HZSQL_ADDMONTH\\s*\\([^)]+\\s*\\)", "HZSQL_INSTR\\s*\\([^)]+\\s*\\)", "HZSQL_LENGTH", "HZSQL_REPLACE\\s*\\([^)]+\\s*\\)", "HZSQL_GETYM\\s*\\([^)]+\\s*\\)", "HZSQL_GETYEAR\\s*\\([^)]+\\s*\\)", "HZSQL_GETFULLDATE\\s*\\([^)]+\\s*\\)", "HZSQL_GETDATETIME\\s*\\([^)]+\\s*\\)", "HZSQL_ORDERBY\\s*\\([^)]+\\s*\\)"};
    protected final String concatExp = "HZSQL_CONCAT\\s*\\([^)]+\\s*\\)";
    protected final String getSysDateExp = "HZSQL_GETSYSDATE";
    protected final String getSysFormatDateExp = "HZSQL_GETDATE\\s*\\([^)]+\\s*\\)";
    protected final String getTimeExp = "HZSQL_GETTIME\\s*\\([^)]+\\s*\\)";
    protected final String substrExp = "HZSQL_SUBSTR\\s*\\([^)]+\\s*\\)";
    protected final String addMonthExp = "HZSQL_ADDMONTH\\s*\\([^)]+\\s*\\)";
    protected final String instrExp = "HZSQL_INSTR\\s*\\([^)]+\\s*\\)";
    protected final String lengthExp = "HZSQL_LENGTH";
    protected final String replaceExp = "HZSQL_REPLACE\\s*\\([^)]+\\s*\\)";
    protected final String getYmExp = "HZSQL_GETYM\\s*\\([^)]+\\s*\\)";
    protected final String getYearExp = "HZSQL_GETYEAR\\s*\\([^)]+\\s*\\)";
    protected final String getFullDateExp = "HZSQL_GETFULLDATE\\s*\\([^)]+\\s*\\)";
    protected final String arg_1 = "\\s*\\(([^)]+\\s*)\\)";
    private static final String hzoasql_tmp_para = "hzoasql_tmp_para";
    private static final String HZSQL_TMP_PARA = "HZSQL_TMP_PARA";

    AbstractSQLDiaect() {
    }

    protected abstract String[] getKey();

    @Override
    public String deal_null(String sql) {
        return sql;
    }

    @Override
    public String[] getDBMSFunction() {
        return null;
    }

    @Override
    public String deal_HZSQL_CONCAT(String sql) {
        Pattern p = Pattern.compile(this.hzoasqlexp[0]);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        while (result) {
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find()) {
                String[] argments = AbstractSQLDiaect.splitargsByConcat(argm.group(0));
                formula = argments[0];
                int len = argments.length;
                for (int i = 1; i < len; ++i) {
                    formula = formula != null && !formula.equals("") ? formula + this.getKey()[0] + argments[i] : argments[i];
                }
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String deal_HZSQL_REPLACE(String sql) {
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(this.hzoasqlexp[8]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractSQLDiaect.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[8].replaceAll("HZSQL_TMP_SOURCE_STR", argments[1]);
                formula = formula.replaceAll("HZSQL_TMP_SEARCH_STR", argments[2]);
                formula = formula.replaceAll("HZSQL_TMP_REPLACEMENT_STR", argments[3]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String deal_HZSQL_INSTR(String sql) {
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(this.hzoasqlexp[6]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractSQLDiaect.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[6].replaceAll("HZSQL_TMP_PARA_STR", argments[1]);
                formula = formula.replaceAll("HZSQL_TMP_PARA_SUBSTR", argments[2]);
                formula = formula.replaceAll("HZSQL_TMP_PARA_NO", argments[3]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String deal_HZSQL_ADDMONTH(String sql) {
        Pattern p = Pattern.compile(this.hzoasqlexp[5]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractSQLDiaect.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[5].replaceAll("HZSQL_TMP_PARA_DATE", argments[1]);
                formula = formula.replaceAll("HZSQL_TMP_PARA_NO", argments[2]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String deal_HZSQL_GETTIME(String sql) {
        return this.dealHZSQL(sql, this.hzoasqlexp[3], this.getKey()[3]);
    }

    @Override
    public String deal_HZSQL_GETDATE(String sql) {
        return this.dealHZSQL(sql, this.hzoasqlexp[2], this.getKey()[2]);
    }

    @Override
    public String deal_HZSQL_GETYM(String sql) {
        return this.dealHZSQL(sql, this.hzoasqlexp[9], this.getKey()[9]);
    }

    @Override
    public String deal_HZSQL_GETYEAR(String sql) {
        return this.dealHZSQL(sql, this.hzoasqlexp[10], this.getKey()[10]);
    }

    @Override
    public String deal_HZSQL_GETSYSDATE(String sql) {
        Pattern p = Pattern.compile(this.hzoasqlexp[1]);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.replaceAll(this.getKey()[1]);
        }
        return sql;
    }

    @Override
    public String deal_HZSQL_GETDATETIME(String sql) {
        return this.dealHZSQL(sql, this.hzoasqlexp[12], this.getKey()[12]);
    }

    @Override
    public String deal_HZSQL_LENGTH(String sql) {
        Pattern p = Pattern.compile(this.hzoasqlexp[7]);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.replaceAll(this.getKey()[7]);
        }
        return sql;
    }

    @Override
    public String deal_HZSQL_SUBSTR(String sql) {
        String argstr = "";
        Pattern p = Pattern.compile(this.hzoasqlexp[4]);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        StringBuffer sb = new StringBuffer();
        while (result) {
            argstr = m.group(0).replaceAll("HZSQL_SUBSTR", this.getKey()[4]);
            m.appendReplacement(sb, argstr);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected static String[] splitargsByConcat(String allargs) {
        ArrayList<String> srcPara = new ArrayList<String>();
        String splitexp = "\\s*[\\(,\\)]\\s*";
        String yhexp = "'[^']+'";
        Pattern p = Pattern.compile(splitexp);
        Pattern yhp = Pattern.compile(yhexp);
        Matcher m = yhp.matcher(allargs);
        boolean result = m.find();
        while (result) {
            String tmp = m.group(0);
            srcPara.add(tmp);
            result = m.find();
        }
        String[] argments = p.split(allargs);
        if (srcPara.size() > 0) {
            allargs = m.replaceAll(hzoasql_tmp_para);
            int len = argments.length;
            for (int j = 0; j < len; ++j) {
                if (!argments[j].equals(hzoasql_tmp_para)) continue;
                argments[j] = (String)srcPara.remove(0);
            }
        }
        return argments;
    }

    protected static String[] splitargs(String allargs) {
        String[] para = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        String splitexp = "\\s*[\\(,\\)]\\s*";
        String yhexp = "'[^']+'";
        Pattern p = Pattern.compile(splitexp);
        Pattern yhp = Pattern.compile(yhexp);
        Matcher m = yhp.matcher(allargs);
        int i = 0;
        while (m.find()) {
            para[i] = m.group(0);
            ++i;
        }
        allargs = m.replaceAll(hzoasql_tmp_para);
        String[] argments = p.split(allargs);
        int len = argments.length;
        for (int j = 0; j < len; ++j) {
            if (!argments[j].equals(hzoasql_tmp_para)) continue;
            argments[j] = para[j - 1];
        }
        return argments;
    }

    public static String splitpgargs(String allargs, HttpServletRequest request) {
        String argstr = allargs;
        String pgexp = "\\$[^$]+\\$";
        Pattern yhp = Pattern.compile(pgexp);
        Matcher m = yhp.matcher(allargs);
        while (m.find()) {
            int paralen;
            String para = m.group(0);
            String inpara = para.substring(1, (paralen = para.length()) - 1);
            String reqpara = request.getParameter(inpara);
            if (reqpara == null) {
                reqpara = "";
            }
            argstr = argstr.replaceAll("\\$" + inpara + "\\$", inpara + "=" + reqpara);
        }
        return argstr;
    }

    private String dealHZSQL(String sql, String exp, String key) {
        Pattern p = Pattern.compile(exp);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        String argstr = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractSQLDiaect.splitargs(argm.group(0)))[1].equals("")) {
                argstr = argments[1];
                formula = key.replaceAll(HZSQL_TMP_PARA, argstr);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected int getOrderByLastIndex(String strSQL) {
        String reg2 = "\\bORDER\\s+BY\\s*+[\\w.,*?\\s]+(DESC|ASC)\\s*|\\bORDER\\s+BY\\s+[\\w.,*?\\s]";
        Pattern ptOrderNo = Pattern.compile(reg2, 2);
        Matcher mOrderNo = ptOrderNo.matcher(strSQL);
        int indexOrderNo = -1;
        while (mOrderNo.find()) {
            indexOrderNo = mOrderNo.start();
        }
        return indexOrderNo;
    }

    protected int getUnionFirstIndex(String strSQL) {
        String reg = "\\bUNION\\s+[\\w.,*?\\s]|\\bUNION ALL\\s+[\\w.,*?\\s]+$";
        Pattern ptOrderNo = Pattern.compile(reg, 2);
        Matcher mOrderNo = ptOrderNo.matcher(strSQL);
        int indexOrderNo = -1;
        if (mOrderNo.find()) {
            indexOrderNo = mOrderNo.start();
        }
        return indexOrderNo;
    }

    protected int getFromFirstIndex(String strSQL) {
        return strSQL.toUpperCase().indexOf("FROM");
    }

    @Override
    public String deal_HZSQL_ORDERBY(String sql) {
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(this.hzoasqlexp[13]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        Matcher argm = argp.matcher(m.group(0));
        if (argm.find()) {
            String[] argments = AbstractSQLDiaect.splitargs(argm.group(0));
            m.appendReplacement(sb, " ORDER BY " + argments[1]);
            m.appendTail(sb);
        }
        return sb.toString();
    }
}

