/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.resultset;

import com.horizon.db.resultset.ResultSetProcessor;
import com.horizon.db.xlob.XlobProcessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetProcessorImpl4Object
implements ResultSetProcessor {
    private ThreadLocal threadLocalDataObjectClass = new ThreadLocal();

    public void setDataObjectClass(Class dataObjectClass) {
        this.threadLocalDataObjectClass.set(dataObjectClass);
    }

    @Override
    public List getResultSet(ResultSet rs) throws SQLException {
        List lstResultSet = this.getResultSet(rs, null, Boolean.TRUE);
        return lstResultSet;
    }

    @Override
    public List getResultSet(ResultSet rs, XlobProcessor xlobProcessor) throws SQLException {
        List lstResultSet = this.getResultSet(rs, xlobProcessor, Boolean.TRUE);
        return lstResultSet;
    }

    private List getResultSet(ResultSet rs, XlobProcessor xlobProcessor, boolean isToLowerCase) throws SQLException {
        Class dataObjectClass = (Class)this.threadLocalDataObjectClass.get();
        if (dataObjectClass == null) {
            throw new SQLException("\u6307\u5b9a\u7684\u6570\u636e\u5bf9\u8c61Class\u4e3anull\u3002");
        }
        this.threadLocalDataObjectClass.set(null);
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int[] columnTypes = new int[columnCount];
        int i = 0;
        int columnIdx = 1;
        while (i < columnCount) {
            columnTypes[i] = rsmd.getColumnType(columnIdx);
            ++i;
            ++columnIdx;
        }
        String[] columnNames = this.getColumnNames(rs, isToLowerCase);
        String[] setMethodNames = this.convertSetMethodName(columnNames);
        Map comparedMethods = this.findComparedMethods(dataObjectClass, setMethodNames, columnNames);
        Object objValue = null;
        Object[] args = new Object[1];
        ArrayList<Object> rsObjectList = new ArrayList<Object>();
        while (rs.next()) {
            Object obj = this.getNewObjectInstance(dataObjectClass);
            if (obj == null) {
                throw new SQLException("\u751f\u6210\u65b0\u5bf9\u8c61\u65f6\u4ea7\u751f\u5f02\u5e38\u3002");
            }
            boolean isTheObjectHasBeenSetValue = Boolean.FALSE;
            int i2 = 0;
            int columnIndex = 1;
            while (i2 < columnCount) {
                if (comparedMethods.containsKey(setMethodNames[i2])) {
                    Object[] objs = (Object[])comparedMethods.get(setMethodNames[i2]);
                    Map mmmm = (Map)objs[0];
                    String columnName = (String)objs[1];
                    boolean isNoValue = Boolean.FALSE;
                    boolean hasSetPropertyValue = Boolean.FALSE;
                    for (Object objParameterType : mmmm.keySet()) {
                        if (hasSetPropertyValue) continue;
                        String parameterType = (String)objParameterType;
                        if (parameterType.equals("java.lang.String")) {
                            if (columnTypes[i2] == 2005) {
                                Clob clob = rs.getClob(columnIndex);
                                objValue = xlobProcessor != null ? xlobProcessor.getClobContent(clob) : clob.getSubString(0L, (int)clob.length());
                            } else {
                                objValue = rs.getString(columnIndex);
                                if (objValue == null) {
                                    objValue = "";
                                }
                            }
                        } else if (parameterType.equals("java.lang.Integer")) {
                            objValue = new Integer(rs.getInt(columnIndex));
                        } else if (parameterType.equals("int")) {
                            objValue = new Integer(rs.getInt(columnIndex));
                        } else if (parameterType.equals("long")) {
                            objValue = new Long(rs.getLong(columnIndex));
                        } else if (parameterType.equals("float")) {
                            objValue = new Float(rs.getFloat(columnIndex));
                        } else if (parameterType.equals("double")) {
                            objValue = new Double(rs.getDouble(columnIndex));
                        } else if (parameterType.equals("java.util.Date")) {
                            objValue = rs.getDate(columnIndex);
                        } else if (parameterType.equals("java.sql.Date")) {
                            objValue = rs.getDate(columnIndex);
                        } else if (parameterType.equals("java.sql.Timestamp")) {
                            objValue = rs.getTimestamp(columnIndex);
                        } else if (parameterType.equals("java.sql.Clob")) {
                            objValue = rs.getClob(columnIndex);
                        } else if (parameterType.equals("java.sql.Blob")) {
                            objValue = rs.getBlob(columnIndex);
                        } else {
                            isNoValue = Boolean.TRUE;
                        }
                        if (isNoValue != Boolean.FALSE) continue;
                        try {
                            args[0] = objValue;
                            Method m = (Method)mmmm.get(parameterType);
                            m.invoke(obj, args);
                            hasSetPropertyValue = Boolean.TRUE;
                            isTheObjectHasBeenSetValue = Boolean.TRUE;
                        }
                        catch (IllegalArgumentException ex) {
                            ex.printStackTrace();
                            throw new SQLException(ex.getMessage());
                        }
                        catch (IllegalAccessException ex) {
                            ex.printStackTrace();
                            throw new SQLException(ex.getMessage());
                        }
                        catch (InvocationTargetException ex) {
                            ex.printStackTrace();
                            throw new SQLException(ex.getMessage());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new SQLException(ex.getMessage());
                        }
                    }
                }
                ++i2;
                ++columnIndex;
            }
            if (!isTheObjectHasBeenSetValue) continue;
            rsObjectList.add(obj);
        }
        return rsObjectList;
    }

    private String[] getColumnNames(ResultSet rs, boolean isToLowerCase) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        if (isToLowerCase) {
            String columnName;
            int i = 0;
            int columnIndex = 1;
            while (i < columnCount) {
                columnName = rsmd.getColumnLabel(columnIndex);
                if (columnName == null) {
                    columnName = rsmd.getColumnName(columnIndex);
                }
                columnNames[i] = columnName.toLowerCase();
                ++i;
                ++columnIndex;
            }
            columnName = null;
        } else {
            String columnName;
            int i = 0;
            int columnIndex = 1;
            while (i < columnCount) {
                columnName = rsmd.getColumnLabel(columnIndex);
                if (columnName == null) {
                    columnName = rsmd.getColumnName(columnIndex);
                }
                columnNames[i] = columnName;
                ++i;
                ++columnIndex;
            }
            columnName = null;
        }
        return columnNames;
    }

    private String[] convertSetMethodName(String[] columnNames) {
        String set = "set";
        int columnCount = columnNames.length;
        String[] setter = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            setter[i] = "set" + this.formatColumnName2BeanName(columnNames[i]);
        }
        return setter;
    }

    private String formatColumnName2BeanName(String columnName) {
        if (columnName == null) {
            return columnName;
        }
        if ((columnName = columnName.trim()).length() == 0) {
            return columnName;
        }
        columnName = columnName.toLowerCase();
        String underLine = "_";
        if (columnName.indexOf("_") < 0) {
            return this.setFirstCharToUpcase(columnName);
        }
        StringBuffer sb = new StringBuffer();
        String[] split = columnName.split("_");
        int len = split.length;
        for (int i = 0; i < len; ++i) {
            String str = split[i].trim();
            if (str.length() <= 0) continue;
            sb.append(this.setFirstCharToUpcase(str));
        }
        return sb.toString();
    }

    private String setFirstCharToUpcase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private Map findComparedMethods(Class dataObjectClass, String[] setMethodNames, String[] columnNames) {
        int columnCount = setMethodNames.length;
        HashMap<String, Object[]> m = new HashMap<String, Object[]>(columnCount);
        Method[] methods = dataObjectClass.getMethods();
        for (int i = 0; i < columnCount; ++i) {
            String setMethodName = setMethodNames[i];
            for (Method method : methods) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(setMethodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
                String parameterType = parameterTypes[0].getName();
                if (m.containsKey(setMethodName)) {
                    Object[] objs = (Object[])m.get(setMethodName);
                    Map mmmm = (Map)objs[0];
                    mmmm.put(parameterType, method);
                    continue;
                }
                HashMap<String, Method> mmmm = new HashMap<String, Method>(3);
                mmmm.put(parameterType, method);
                Object[] objs = new Object[]{mmmm, columnNames[i]};
                m.put(setMethodName, objs);
            }
        }
        return m;
    }

    private Object getNewObjectInstance(Class dataObjectClass) {
        Object obj = null;
        try {
            obj = dataObjectClass.newInstance();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

