/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.resultset;

import com.horizon.db.resultset.ResultSetProcessor;
import com.horizon.db.xlob.XlobProcessor;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ResultSetProcessorImpl4Map
implements ResultSetProcessor {
    private boolean isToLowerCase4ColumnName = Boolean.TRUE;

    public void setLowerCase4ColumnName(boolean isToLowerCase4ColumnName) {
        this.isToLowerCase4ColumnName = isToLowerCase4ColumnName;
    }

    @Override
    public List getResultSet(ResultSet rs) throws SQLException {
        ArrayList lstResultSet = new ArrayList();
        if (rs.next()) {
            boolean step = true;
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] columnNames = this.getColumnNames(rs, this.isToLowerCase4ColumnName);
            do {
                HashMap<String, Object> rowData = new HashMap<String, Object>(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    Object o = null;
                    int index = i + 1;
                    o = rs.getObject(index) instanceof Date ? rs.getTimestamp(index) : rs.getObject(index);
                    rowData.put(columnNames[i], o);
                }
                lstResultSet.add(rowData);
            } while (rs.next());
        }
        return lstResultSet;
    }

    @Override
    public List getResultSet(ResultSet rs, XlobProcessor xlobProcessor) throws SQLException {
        ArrayList lstResultSet = new ArrayList();
        if (rs.next()) {
            boolean step = true;
            String empty = "";
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            int[] columnTypes = new int[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnTypes[i] = rsmd.getColumnType(i + 1);
            }
            String[] columnNames = this.getColumnNames(rs, this.isToLowerCase4ColumnName);
            do {
                HashMap<String, Object> rowData = new HashMap<String, Object>(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    Object o = null;
                    int index = i + 1;
                    o = rs.getObject(index) instanceof Date ? rs.getTimestamp(index) : rs.getObject(index);
                    if (columnTypes[i] == 2005) {
                        Clob clob = (Clob)o;
                        String colbTxt = xlobProcessor.getClobContent(clob);
                        o = colbTxt;
                    } else if (columnTypes[i] == 2004) {
                        o = "";
                    }
                    rowData.put(columnNames[i], o);
                }
                lstResultSet.add(rowData);
            } while (rs.next());
        }
        return lstResultSet;
    }

    private String[] getColumnNames(ResultSet rs, boolean isToLowerCase) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] columnNames = new String[columnCount];
        if (isToLowerCase) {
            String columnName;
            int i = 0;
            int columnIndex = 1;
            while (i < columnCount) {
                columnName = rsmd.getColumnLabel(columnIndex);
                if (columnName == null) {
                    columnName = rsmd.getColumnName(columnIndex);
                }
                columnNames[i] = columnName.toLowerCase();
                ++i;
                ++columnIndex;
            }
            columnName = null;
        } else {
            String columnName;
            int i = 0;
            int columnIndex = 1;
            while (i < columnCount) {
                columnName = rsmd.getColumnLabel(columnIndex);
                if (columnName == null) {
                    columnName = rsmd.getColumnName(columnIndex);
                }
                columnNames[i] = columnName;
                ++i;
                ++columnIndex;
            }
            columnName = null;
        }
        return columnNames;
    }
}

