/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.resultset;

import com.horizon.db.resultset.ResultSetProcessor;
import com.horizon.db.xlob.XlobProcessor;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ResultSetProcessorImpl4List
implements ResultSetProcessor {
    @Override
    public List getResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        ArrayList lstResultSet = new ArrayList();
        while (rs.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Object o = rs.getObject(i);
                rowData.add(o);
            }
            lstResultSet.add(rowData);
        }
        return lstResultSet;
    }

    @Override
    public List getResultSet(ResultSet rs, XlobProcessor xlobProcessor) throws SQLException {
        boolean step = true;
        String empty = "";
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int[] columnTypes = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnTypes[i] = rsmd.getColumnType(i + 1);
        }
        ArrayList lstResultSet = new ArrayList();
        while (rs.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                Object o = rs.getObject(i + 1);
                if (columnTypes[i] == 2005) {
                    Clob clob = (Clob)o;
                    String colbTxt = xlobProcessor.getClobContent(clob);
                    o = colbTxt;
                } else if (columnTypes[i] == 2004) {
                    o = "";
                }
                rowData.add(o);
            }
            lstResultSet.add(rowData);
        }
        return lstResultSet;
    }
}

