/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.module;

public class Pages {
    public static final String HZ_PAGE_OBJECT = "HZ_PAGE_OBJECT";
    public static final String HZ_PAGE_NO = "HZ_PAGE_NO";
    public static final String HZ_PAGE_SIZE = "HZ_PAGE_SIZE";
    private static final String REGEX_DIGITAL = "\\d+";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final int DEFAULT_PAGE_NO = 1;
    private int pageNo = 1;
    private int pageSize = 10;
    private int totalRecordNumber = 0;
    private int totalPage = 1;
    private int pageOrderNo;
    private String reqNum;

    public Pages() {
    }

    public Pages(String strPageNo, String strPageSize) {
        this.init(strPageNo, strPageSize, 10);
    }

    public Pages(String strPageNo, String strPageSize, int defaultPageSize) {
        this.init(strPageNo, strPageSize, defaultPageSize);
    }

    private void init(String strPageNo, String strPageSize, int defaultPageSize) {
        int pageNo = 0;
        if (strPageNo != null && strPageNo.trim().length() > 0) {
            if ((strPageNo = strPageNo.trim()).matches(REGEX_DIGITAL)) {
                pageNo = Integer.parseInt(strPageNo);
            } else {
                System.out.println("[" + this.getClass().getName() + "][init(...)] " + "\uff08\u8bf7\u6c42\u53c2\u6570\uff09\u9875\u53f7\uff1a\u5305\u542b\u975e\u6570\u5b57\u5b57\u7b26\u3002\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a" + 1);
            }
        }
        this.pageNo = pageNo > 0 ? pageNo : 1;
        int pageSize = 0;
        if (strPageSize != null && strPageSize.trim().length() > 0) {
            if ((strPageSize = strPageSize.trim()).matches(REGEX_DIGITAL)) {
                pageSize = Integer.parseInt(strPageSize);
            } else {
                System.out.println("[" + this.getClass().getName() + "][init(...)] " + "\uff08\u8bf7\u6c42\u53c2\u6570\uff09\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570\uff1a\u5305\u542b\u975e\u6570\u5b57\u5b57\u7b26\u3002\u4f7f\u7528\u9ed8\u8ba4\u503c\uff1a" + (defaultPageSize > 0 ? defaultPageSize : 10));
            }
        }
        this.pageSize = pageSize > 0 ? pageSize : (defaultPageSize > 0 ? defaultPageSize : 10);
    }

    public int getPage() {
        return this.pageNo;
    }

    public void setPage(int page) {
        this.pageNo = page;
    }

    public void setTotalRecordNumber(int totalRecordNumber) {
        this.totalRecordNumber = totalRecordNumber;
        this.totalPage = this.initTotalPage();
        if (this.pageNo > this.totalPage) {
            this.pageNo = this.totalPage;
        }
        this.pageOrderNo = this.pageSize * (this.pageNo - 1) + 1;
    }

    public int getTotalRecordNumber() {
        return this.totalRecordNumber;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize > 0 ? pageSize : 10;
    }

    public int getPageOrderNo() {
        return this.pageOrderNo;
    }

    private int initTotalPage() {
        int totalPage = this.totalRecordNumber > 0 ? (this.totalRecordNumber % this.pageSize == 0 ? this.totalRecordNumber / this.pageSize : this.totalRecordNumber / this.pageSize + 1) : 1;
        return totalPage;
    }

    public String getReqNum() {
        return this.reqNum;
    }

    public void setReqNum(String reqNum) {
        this.reqNum = reqNum;
    }
}

