/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.access.tx;

import com.horizon.db.access.IExeQuery;
import com.horizon.db.access.tx.ExeBase;
import com.horizon.db.module.TableColumn;
import com.horizon.db.resultset.ResultSetProcessor;
import com.horizon.db.resultset.ResultSetProcessorImpl4List;
import com.horizon.db.resultset.ResultSetProcessorImpl4Map;
import com.horizon.db.resultset.ResultSetProcessorImpl4Object;
import com.horizon.db.sql.SQLParser;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xlob.XlobProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExeQuery
extends ExeBase
implements IExeQuery {
    private static Logger logger = LoggerFactory.getLogger(ExeQuery.class);
    private ResultSetProcessor rsProcessor4List = new ResultSetProcessorImpl4List();
    private ResultSetProcessor rsProcessor4Map = new ResultSetProcessorImpl4Map();
    private ResultSetProcessorImpl4Object rsProcessor4Object = new ResultSetProcessorImpl4Object();

    @Override
    public List getMultiList(String dbIdentifier, String strSQL, List lstCondition) {
        List rsLst = this.executeQuery(dbIdentifier, strSQL, lstCondition, this.rsProcessor4List);
        return rsLst;
    }

    @Override
    public List getPagingList(String dbIdentifier, String strSQL, List lstConditions, int iPageNo, int iPageSize) {
        String strPageSql = this.getParsedSql(dbIdentifier, strSQL, iPageNo, iPageSize, lstConditions);
        List list = this.getMultiList(dbIdentifier, strPageSql, lstConditions);
        return list;
    }

    @Override
    public List getMultiMap(String dbIdentifier, String strSQL, List lstConditions) {
        List rsLst = this.executeQuery(dbIdentifier, strSQL, lstConditions, this.rsProcessor4Map);
        return rsLst;
    }

    @Override
    public List getPagingMap(String dbIdentifier, String strSQL, List lstConditions, int iPageNo, int iPageSize) {
        String strPageSql = this.getParsedSql(dbIdentifier, strSQL, iPageNo, iPageSize, lstConditions);
        List list = this.getMultiMap(dbIdentifier, strPageSql, lstConditions);
        return list;
    }

    @Override
    public List getMultiObject(String dbIdentifier, String strSQL, List lstConditions, Class dataObjectClass) {
        this.rsProcessor4Object.setDataObjectClass(dataObjectClass);
        List rsLst = this.executeQuery(dbIdentifier, strSQL, lstConditions, this.rsProcessor4Object);
        return rsLst;
    }

    @Override
    public List getPagingObject(String dbIdentifier, String strSQL, List lstConditions, Class dataObjectClass, int iPageNo, int iPageSize) {
        String strPageSql = this.getParsedSql(dbIdentifier, strSQL, iPageNo, iPageSize, lstConditions);
        List list = this.getMultiObject(dbIdentifier, strPageSql, lstConditions, dataObjectClass);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRsCount(String dbIdentifier, String strSQL, List lstConditions) {
        int iCount;
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            conn = null;
            pstmt = null;
            rs = null;
            iCount = -1;
            String strCountSQL = this.getCountSQL(strSQL);
            try {
                strCountSQL = this.parseHzSql(dbIdentifier, strCountSQL);
                conn = ExeQuery.getConnection(dbIdentifier);
                pstmt = conn.prepareStatement(strCountSQL);
                this.setParameters(pstmt, lstConditions);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                iCount = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    logger.error("sql: " + strCountSQL);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    ExeQuery.releaseDbResource(conn, pstmt, rs);
                    throw throwable;
                }
                ExeQuery.releaseDbResource(conn, pstmt, rs);
            }
        }
        ExeQuery.releaseDbResource(conn, pstmt, rs);
        return iCount;
    }

    @Override
    public List getTableNames(String dbIdentifier) {
        try {
            SQLParser sqlpaser = this.getSqlParser(dbIdentifier);
            String sql = sqlpaser.getTableNameSql();
            ArrayList lst = this.getMultiList(dbIdentifier, sql, null);
            if (lst == null) {
                lst = new ArrayList(0);
                return lst;
            }
            if (!lst.isEmpty()) {
                int size = lst.size();
                for (int i = 0; i < size; ++i) {
                    List aList = (List)lst.get(i);
                    lst.set(i, aList.get(0));
                }
            }
            return lst;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getClobContent(String dbIdentifier, String tableName, String fieldName, String condition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getBlobContent(String dbIdentifier, String tableName, String fieldName, String condition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getColumnMsg(String dbIdentifier, String tableName, boolean isToLowerCase) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block8: {
            LinkedHashMap<String, TableColumn> linkedHashMap;
            conn = null;
            stmt = null;
            rs = null;
            String strSql = "select a.* from " + tableName + " a where 1<>1";
            try {
                int i;
                conn = ExeQuery.getConnection(dbIdentifier);
                stmt = conn.prepareStatement(strSql);
                rs = stmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                if (columnCount <= 0) break block8;
                LinkedHashMap<String, TableColumn> map = new LinkedHashMap<String, TableColumn>(columnCount);
                if (isToLowerCase) {
                    for (i = 0; i < columnCount; ++i) {
                        int column = i + 1;
                        String columnName = rsmd.getColumnName(column).toLowerCase();
                        TableColumn tbcolumn = new TableColumn();
                        tbcolumn.setColumnClassName(rsmd.getColumnClassName(column));
                        tbcolumn.setColumnTypeName(rsmd.getColumnTypeName(column));
                        tbcolumn.setNullable(rsmd.isNullable(column));
                        tbcolumn.setColumnSize(rsmd.getColumnDisplaySize(column));
                        map.put(columnName, tbcolumn);
                    }
                } else {
                    for (i = 0; i < columnCount; ++i) {
                        int column = i + 1;
                        String columnName = rsmd.getColumnName(column);
                        TableColumn tbcolumn = new TableColumn();
                        tbcolumn.setColumnClassName(rsmd.getColumnClassName(column));
                        tbcolumn.setColumnTypeName(rsmd.getColumnTypeName(column));
                        tbcolumn.setNullable(rsmd.isNullable(column));
                        tbcolumn.setColumnSize(rsmd.getColumnDisplaySize(column));
                        map.put(columnName, tbcolumn);
                    }
                }
                linkedHashMap = map;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    ExeQuery.releaseDbResource(conn, stmt, rs);
                    throw throwable;
                }
                ExeQuery.releaseDbResource(conn, stmt, rs);
            }
            ExeQuery.releaseDbResource(conn, stmt, rs);
            return linkedHashMap;
        }
        ExeQuery.releaseDbResource(conn, stmt, rs);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getColumnBySql(String sql, boolean isToLowerCase, String dbIdentifier) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block8: {
            LinkedHashMap<String, TableColumn> linkedHashMap;
            conn = null;
            stmt = null;
            rs = null;
            try {
                int i;
                conn = ExeQuery.getConnection(dbIdentifier);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                if (columnCount <= 0) break block8;
                LinkedHashMap<String, TableColumn> map = new LinkedHashMap<String, TableColumn>(columnCount);
                if (isToLowerCase) {
                    for (i = 0; i < columnCount; ++i) {
                        int column = i + 1;
                        String columnName = rsmd.getColumnName(column).toLowerCase();
                        TableColumn tbcolumn = new TableColumn();
                        tbcolumn.setColumnClassName(rsmd.getColumnClassName(column));
                        tbcolumn.setColumnTypeName(rsmd.getColumnTypeName(column));
                        tbcolumn.setNullable(rsmd.isNullable(column));
                        tbcolumn.setColumnSize(rsmd.getColumnDisplaySize(column));
                        map.put(columnName, tbcolumn);
                    }
                } else {
                    for (i = 0; i < columnCount; ++i) {
                        int column = i + 1;
                        String columnName = rsmd.getColumnName(column);
                        TableColumn tbcolumn = new TableColumn();
                        tbcolumn.setColumnClassName(rsmd.getColumnClassName(column));
                        tbcolumn.setColumnTypeName(rsmd.getColumnTypeName(column));
                        tbcolumn.setNullable(rsmd.isNullable(column));
                        tbcolumn.setColumnSize(rsmd.getColumnDisplaySize(column));
                        map.put(columnName, tbcolumn);
                    }
                }
                linkedHashMap = map;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    ExeQuery.releaseDbResource(conn, stmt, rs);
                    throw throwable;
                }
                ExeQuery.releaseDbResource(conn, stmt, rs);
            }
            ExeQuery.releaseDbResource(conn, stmt, rs);
            return linkedHashMap;
        }
        ExeQuery.releaseDbResource(conn, stmt, rs);
        return null;
    }

    public static XlobProcessor getLobProcessorClass(String dbIdentifier) throws InvalidIdentifierException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return ExeBase.getLobProcessorClass(dbIdentifier);
    }

    public static Connection getConnection(String dbIdentifier) throws InvalidIdentifierException {
        return ExeBase.getConnection(dbIdentifier);
    }

    public static void releaseDbResource(Connection conn, Statement stmt, ResultSet rs) {
        ExeBase.releaseDbResource(conn, stmt, rs);
    }

    /*
     * Exception decompiling
     */
    protected List executeQuery(String dbIdentifier, String strSQL, List lstConditions, ResultSetProcessor resultSetProcessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean existedXlob(ResultSet rs) throws SQLException {
        boolean flag = false;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int i = 0;
        int columnIdx = 1;
        while (i < columnCount) {
            int columnType = rsmd.getColumnType(columnIdx);
            if (columnType == 2005) {
                flag = true;
                break;
            }
            ++i;
            ++columnIdx;
        }
        return flag;
    }

    private String getCompletedSql(String tableName, String fieldName, String condition) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select ").append(fieldName);
        sbSql.append(" from ").append(tableName);
        if (condition.toLowerCase().trim().startsWith("where")) {
            sbSql.append(" ").append(condition);
        } else {
            sbSql.append(" where ").append(condition);
        }
        String strSQL = sbSql.toString();
        return strSQL;
    }

    private String getCountSQL(String strSQL) {
        String strSQL2 = strSQL.replaceAll("\\s+", " ").trim();
        String regx = "select count\\s*\\(\\s*(\\*|\\w+|\\w+\\.\\*|\\w+\\.\\w+)\\s*\\)\\s+from\\s+";
        Pattern pt = Pattern.compile(regx, 2);
        Matcher mc = pt.matcher(strSQL2);
        if (mc.find() && mc.start() == 0) {
            return strSQL;
        }
        String reg2 = "\\bORDER\\s+BY\\s+(\\w.)+\\s+(DESC|ASC)\\s*$|\\bORDER\\s+BY\\s+(\\w.)+\\s*$";
        Pattern ptOrderNo = Pattern.compile(reg2, 2);
        Matcher mOrderNo = ptOrderNo.matcher(strSQL2);
        int indexOrderNo = -1;
        while (mOrderNo.find()) {
            indexOrderNo = mOrderNo.start();
        }
        if (indexOrderNo > 0) {
            strSQL = strSQL2 = strSQL2.substring(0, indexOrderNo);
        }
        StringBuffer sqlbuf = new StringBuffer(strSQL.length() + 30);
        sqlbuf.append("select count(*) from (");
        sqlbuf.append(strSQL);
        sqlbuf.append(") a");
        strSQL = sqlbuf.toString();
        return strSQL;
    }

    private String getParsedSql(String dbIdentifier, String strSQL, int iPageNo, int iPageSize, List lstConditions) {
        String strPageSql = null;
        try {
            strSQL = this.parseHzSql(dbIdentifier, strSQL);
            SQLParser sqlpaser = this.getSqlParser(dbIdentifier);
            strPageSql = sqlpaser.getPaginationSQL(strSQL, iPageNo, iPageSize, lstConditions);
        }
        catch (Exception e) {
            logger.debug(" \u65e0\u6cd5\u6784\u5efa\u6570\u636e\u5e93\u5206\u9875SQL, \u539f\u56e0SQLParser\u7c7b\u5b9e\u4f8b\u5316\u5931\u8d25!!");
            e.printStackTrace();
            return strSQL;
        }
        return strPageSql;
    }
}

