/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.access.tx;

import com.horizon.datasource.util.DataSourceContextHolder;
import com.horizon.db.DBConfigInfoHelper;
import com.horizon.db.sql.SQLParser;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xlob.CommonXlobProcessor;
import com.horizon.db.xlob.XlobProcessor;
import com.horizon.exception.HorizonException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;

class ExeBase {
    private static JdbcTemplate jdbcTemplate;
    private static Map sqlParserMap;

    ExeBase() {
    }

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        ExeBase.jdbcTemplate = jdbcTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLParser getSqlParser(String dbIdentifier) throws InvalidIdentifierException {
        Object objSqlParser = sqlParserMap.get(dbIdentifier);
        if (objSqlParser != null) {
            return (SQLParser)objSqlParser;
        }
        String strDBType = DBConfigInfoHelper.getDatabaseType(dbIdentifier);
        if (strDBType == null || strDBType.trim().length() == 0) {
            throw new InvalidIdentifierException("\u6570\u636e\u5e93\u6807\u8bc6\u6240\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e3anull\u6216\u7a7a\u3002dbIdentifier: " + dbIdentifier);
        }
        SQLParser sqlParser = null;
        if ("SQLSERVER".equals(strDBType = strDBType.trim().replaceAll(" ", "").toUpperCase())) {
            String dbProductVersion = null;
            Connection conn = null;
            try {
                conn = ExeBase.getConnection(dbIdentifier);
                DatabaseMetaData dbmd = conn.getMetaData();
                dbProductVersion = dbmd.getDatabaseProductVersion();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ExeBase.releaseDbResource(conn);
                conn = null;
            }
            sqlParser = new SQLParser(strDBType, dbProductVersion);
        } else {
            sqlParser = new SQLParser(strDBType, null);
        }
        sqlParserMap.put(dbIdentifier, sqlParser);
        return sqlParser;
    }

    protected String parseHzSql(String dbIdentifier, String sql) throws InvalidIdentifierException {
        SQLParser sqlpaser = this.getSqlParser(dbIdentifier);
        String strSQL = sqlpaser.parse(sql);
        return strSQL;
    }

    protected void setParameters(PreparedStatement pstmt, List lstConditions) throws SQLException {
        if (pstmt == null) {
            return;
        }
        if (lstConditions != null && !lstConditions.isEmpty()) {
            int len = lstConditions.size();
            for (int i = 0; i < len; ++i) {
                Object object = lstConditions.get(i);
                pstmt.setObject(i + 1, object);
            }
        }
    }

    protected boolean checkQuestionNumber(String sql, List lstParameters) {
        boolean isCompared;
        if (sql == null) {
            throw new HorizonException("SQL\u8bed\u53e5\u4e3anull (Invalid sql: the sql is null.)");
        }
        if ((sql = sql.trim()).length() == 0) {
            throw new HorizonException("SQL\u8bed\u53e5\u4e3a\u7a7a (Invalid sql: the sql is empty.)");
        }
        int chr = 63;
        int endCondition = -1;
        int i = sql.indexOf(63);
        if (i == -1) {
            if (lstParameters == null || lstParameters.isEmpty()) {
                return Boolean.TRUE;
            }
            throw new HorizonException("SQL\u8bed\u53e5\u4e0e\u53c2\u6570\u503c\u6570\u91cf\u4e0d\u5339\u914d\uff1aSQL\u8bed\u53e5\u6ca1\u6709\u95ee\u53f7\uff0c\u4f46\u5374\u6709\u53c2\u6570\u3002 (Not compared SQL and parameters's number: the sql hasn't question-mark, but has condition-value): \nparameter-number: " + lstParameters.size() + ", SQL: " + sql);
        }
        if (lstParameters == null || lstParameters.isEmpty()) {
            throw new HorizonException("SQL\u8bed\u53e5\u4e2d\u6709\u95ee\u53f7\uff0c\u4f46\u5374\u6ca1\u6709\u6761\u4ef6\u503c\u3002 (The sql has question-mark, but NO condition-value): " + sql);
        }
        boolean step = true;
        int iCount = 0;
        do {
            ++iCount;
        } while ((i = sql.indexOf(63, i + 1)) != -1);
        boolean bl = isCompared = iCount == lstParameters.size();
        if (!isCompared) {
            throw new HorizonException("SQL\u8bed\u53e5\u4e0e\u53c2\u6570\u503c\u6570\u91cf\u4e0d\u5339\u914d (Not compared SQL and parameters's number): \nparameter-number: " + lstParameters.size() + ", SQL: " + sql);
        }
        return isCompared;
    }

    protected static XlobProcessor getLobProcessorClass(String dbIdentifier) throws InvalidIdentifierException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (dbIdentifier == null || dbIdentifier.trim().length() == 0) {
            throw new InvalidIdentifierException("\u975e\u6cd5\u7684\u6570\u636e\u5e93\u6807\u8bc6\uff1anull or empty");
        }
        String strLobProClass = DBConfigInfoHelper.getLobProcessorClass(dbIdentifier);
        Object object = Class.forName(strLobProClass).newInstance();
        if (object instanceof CommonXlobProcessor) {
            CommonXlobProcessor xlob = (CommonXlobProcessor)object;
            xlob.setBufferSize(ExeBase.getBufferSize(dbIdentifier));
            return xlob;
        }
        throw new InvalidIdentifierException("\u6307\u5b9a\u7684\u5904\u7406\u5927\u5b57\u6bb5\u5b9e\u73b0\u7c7b\u975e\u6cd5\uff1a\u6ca1\u6709\u7ee7\u627f\u81ea" + CommonXlobProcessor.class.getName() + "\u62bd\u8c61\u7c7b\u3002\u6570\u636e\u5e93\u6807\u8bc6\u7b26\uff1a" + dbIdentifier);
    }

    protected static int getBufferSize(String dbIdentifier) throws InvalidIdentifierException {
        int strBuffSize = DBConfigInfoHelper.getLobBufferSize(dbIdentifier);
        return strBuffSize;
    }

    protected static Connection getConnection(String dbIdentifier) throws InvalidIdentifierException {
        DataSourceContextHolder.setDataSourceType(dbIdentifier);
        DataSource ds = jdbcTemplate.getDataSource();
        Connection conn = DataSourceUtils.getConnection((DataSource)ds);
        return conn;
    }

    protected static void releaseDbResource(Connection conn) {
        ExeBase.releaseDbResource(conn, null, null);
    }

    protected static void releaseDbResource(Connection conn, Statement stmt) {
        ExeBase.releaseDbResource(conn, stmt, null);
    }

    protected static void releaseDbResource(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            JdbcUtils.closeResultSet((ResultSet)rs);
        }
        if (stmt != null) {
            JdbcUtils.closeStatement((Statement)stmt);
        }
        if (conn != null) {
            DataSourceUtils.releaseConnection((Connection)conn, (DataSource)jdbcTemplate.getDataSource());
        }
    }

    static {
        sqlParserMap = new HashMap(6);
    }
}

