/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.access.def;

import com.horizon.db.Access;
import com.horizon.db.access.IObject2Database;
import com.horizon.db.access.def.ExeBase;
import com.horizon.exception.HorizonException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Object2Database
extends ExeBase
implements IObject2Database {
    private static Logger LOGGER = LoggerFactory.getLogger(Object2Database.class);
    private final String COMMA = ",";
    private final String QUESTION_MARK = "?,";
    private static Map allowedDataType = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveObjectData(String dataSourceIdentifier, Map<String, ? extends Object> mapTableNameAndDataObjects) {
        if (dataSourceIdentifier == null || dataSourceIdentifier.trim().length() == 0) {
            throw new HorizonException("\u6570\u636e\u5e93\u6807\u8bc6\u4e3a\u7a7a[dataSourceIdentifier is null]");
        }
        if (mapTableNameAndDataObjects == null || mapTableNameAndDataObjects.isEmpty()) {
            throw new HorizonException("\u5305\u542b\u8868\u540d\u548c\u6570\u636e\u5bf9\u8c61\u7684Map\u5bf9\u8c61\u4e3anull\u6216\u7a7a\u3002");
        }
        boolean isOk = Boolean.FALSE;
        boolean oldAutoCommit = Boolean.TRUE;
        Connection conn = null;
        PreparedStatement pstmt1 = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String methodName = null;
            String paraTypeName = null;
            String columnName = null;
            StringBuffer sbUpdateSql = new StringBuffer();
            StringBuffer sbAddSql = new StringBuffer();
            StringBuffer sbAddParamSql = new StringBuffer();
            int iCount = 0;
            LinkedHashMap logMap = new LinkedHashMap(mapTableNameAndDataObjects.size());
            conn = Object2Database.getConnection(dataSourceIdentifier.trim());
            oldAutoCommit = conn.getAutoCommit();
            conn.setAutoCommit(Boolean.FALSE);
            for (String keyTableName : mapTableNameAndDataObjects.keySet()) {
                if (keyTableName == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("\u975e\u6cd5\u7684\u6570\u636e\u8868\u540d\uff1anull");
                    continue;
                }
                if (!(keyTableName instanceof String)) {
                    throw new HorizonException("\u975e\u6cd5\u7684\u6570\u636e\u8868\u540d\uff1a\u4e0d\u662fString\u7c7b\u578b\u3002");
                }
                String tableName = keyTableName;
                if ((tableName = tableName.trim()).length() == 0) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.error("\u6570\u636e\u8868\u540d\u4e3a\u7a7a\u3002");
                    continue;
                }
                Object tmpDataObjects = mapTableNameAndDataObjects.get(tableName);
                if (tmpDataObjects == null) {
                    LOGGER.error("\u6570\u636e\u5bf9\u8c61\u4e3anull\uff1b\u5bf9\u5e94\u7684\u6570\u636e\u8868\u540d\uff1a" + tableName);
                    continue;
                }
                Object[] dataObjects = null;
                if (tmpDataObjects instanceof Object[]) {
                    dataObjects = (Object[])tmpDataObjects;
                } else if (tmpDataObjects instanceof List) {
                    List lst = (List)tmpDataObjects;
                    dataObjects = lst.toArray();
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Data object: " + tmpDataObjects.getClass().getName());
                    }
                    dataObjects = new Object[]{tmpDataObjects};
                }
                ArrayList lstLogTotalParam = new ArrayList(mapTableNameAndDataObjects.size());
                int len = dataObjects.length;
                for (int k = 0; k < len; ++k) {
                    Timestamp timestampVar;
                    Date datevalue;
                    java.util.Date dateVar;
                    String strvalue;
                    Float fvalue;
                    Double dvalue;
                    Long lngvalue;
                    Integer intvalue;
                    Class<?>[] clazz;
                    int j;
                    int methodCount;
                    int i;
                    int columnCount;
                    ResultSetMetaData rsmd;
                    Object dataObject = dataObjects[k];
                    if (dataObject == null) {
                        LOGGER.error("\u6570\u636e\u5bf9\u8c61\u4e3anull\uff0c\u7d22\u5f15\u503c\uff1a" + k + "\uff1b\u5bf9\u5e94\u7684\u6570\u636e\u8868\u540d\uff1a" + tableName);
                        continue;
                    }
                    Class<?> objClass = dataObject.getClass();
                    Method[] ms = objClass.getMethods();
                    Method getId = objClass.getMethod("getId", new Class[0]);
                    String primaryId = (String)getId.invoke(dataObject, new Object[0]);
                    iCount = 0;
                    if (primaryId != null && primaryId.trim().length() > 0) {
                        pstmt1 = conn.prepareStatement("SELECT count(a.ID) FROM " + tableName + " a WHERE a.ID=?");
                        pstmt1.setString(1, primaryId);
                        rs = pstmt1.executeQuery();
                        if (rs.next()) {
                            iCount = rs.getInt(1);
                        }
                        Object2Database.releaseDbResource(null, pstmt1, rs);
                    } else {
                        Method setIdMethod = objClass.getMethod("setId", String.class);
                        setIdMethod.invoke(dataObject, Access.getUUID());
                    }
                    pstmt1 = conn.prepareStatement("SELECT a.* FROM " + tableName + " a WHERE 1<>1");
                    rs = pstmt1.executeQuery();
                    if (iCount == 0) {
                        rsmd = rs.getMetaData();
                        columnCount = rsmd.getColumnCount();
                        for (i = 0; i < columnCount; ++i) {
                            columnName = rsmd.getColumnName(i + 1).toLowerCase();
                            methodName = this.formatColumnName("get", columnName);
                            int methodCount2 = ms.length;
                            for (int j2 = 0; j2 < methodCount2; ++j2) {
                                if (!ms[j2].getName().equals(methodName) || !this.isParameterTypes(paraTypeName = ms[j2].getReturnType().getName())) continue;
                                this.getAddSql(sbAddSql, sbAddParamSql, columnName);
                            }
                        }
                        if (sbAddSql != null && sbAddSql.length() > 0) {
                            String addSql = sbAddSql.toString();
                            addSql = addSql.substring(0, addSql.length() - 1);
                            String addParamSql = sbAddParamSql.toString();
                            addParamSql = addParamSql.substring(0, addParamSql.length() - 1);
                            String mainSql = "insert into " + tableName + " (" + addSql + ") values (" + addParamSql + ")";
                            pstmt = conn.prepareStatement(mainSql);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u4fdd\u5b58\u5bf9\u8c61\u5230\u6570\u636e\u5e93-\u8d4b\u503cSQL: [" + mainSql + "]");
                            }
                            ArrayList<Object> lstLogParam = new ArrayList<Object>();
                            int columnIndex = 1;
                            for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                                columnName = rsmd.getColumnName(i2 + 1).toLowerCase();
                                methodName = this.formatColumnName("get", columnName);
                                methodCount = ms.length;
                                for (j = 0; j < methodCount; ++j) {
                                    if (!ms[j].getName().equals(methodName) || (clazz = ms[j].getParameterTypes()) != null && clazz.length > 1 || !this.isParameterTypes(paraTypeName = ms[j].getReturnType().getName())) continue;
                                    if (paraTypeName.equals("int") || paraTypeName.equals("Integer")) {
                                        intvalue = (Integer)ms[j].invoke(dataObject, new Object[0]);
                                        int value = intvalue == null ? 0 : intvalue;
                                        pstmt.setInt(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Integer(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("long") || paraTypeName.equals("Long")) {
                                        lngvalue = (Long)ms[j].invoke(dataObject, new Object[0]);
                                        long value = lngvalue == null ? 0L : (long)lngvalue.intValue();
                                        pstmt.setLong(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Long(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("double") || paraTypeName.equals("Double")) {
                                        dvalue = (Double)ms[j].invoke(dataObject, new Object[0]);
                                        double value = dvalue == null ? 0.0 : dvalue;
                                        pstmt.setDouble(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Double(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("float") || paraTypeName.equals("Float")) {
                                        fvalue = (Float)ms[j].invoke(dataObject, new Object[0]);
                                        float value = fvalue == null ? 0.0f : fvalue.floatValue();
                                        pstmt.setFloat(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Float(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.lang.String")) {
                                        strvalue = (String)ms[j].invoke(dataObject, new Object[0]);
                                        pstmt.setString(columnIndex, strvalue);
                                        ++columnIndex;
                                        lstLogParam.add(strvalue);
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.util.Date")) {
                                        dateVar = (java.util.Date)ms[j].invoke(dataObject, new Object[0]);
                                        Timestamp timestampVar2 = null;
                                        if (dateVar != null) {
                                            timestampVar2 = new Timestamp(dateVar.getTime());
                                        }
                                        pstmt.setTimestamp(columnIndex, timestampVar2);
                                        ++columnIndex;
                                        lstLogParam.add(timestampVar2);
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.sql.Date")) {
                                        datevalue = (Date)ms[j].invoke(dataObject, new Object[0]);
                                        pstmt.setDate(columnIndex, datevalue);
                                        ++columnIndex;
                                        lstLogParam.add(datevalue);
                                        continue;
                                    }
                                    if (!paraTypeName.equals("java.sql.Timestamp")) continue;
                                    timestampVar = (Timestamp)ms[j].invoke(dataObject, new Object[0]);
                                    if (rs.getMetaData().isNullable(i2 + 1) != 1 && timestampVar == null) {
                                        timestampVar = new Timestamp(System.currentTimeMillis());
                                    }
                                    pstmt.setTimestamp(columnIndex, timestampVar);
                                    ++columnIndex;
                                    lstLogParam.add(timestampVar);
                                }
                            }
                            lstLogTotalParam.add(lstLogParam);
                            logMap.put(mainSql, lstLogTotalParam);
                            int rowNum = pstmt.executeUpdate();
                            Object2Database.releaseDbResource(null, pstmt, null);
                            isOk = rowNum == 1;
                        }
                        sbAddSql.delete(0, sbAddSql.length());
                        sbAddParamSql.delete(0, sbAddParamSql.length());
                    } else {
                        rsmd = rs.getMetaData();
                        columnCount = rsmd.getColumnCount();
                        block30: for (i = 0; i < columnCount; ++i) {
                            columnName = rsmd.getColumnName(i + 1).toLowerCase();
                            methodName = this.formatColumnName("get", columnName);
                            int methodCount3 = ms.length;
                            for (int j3 = 0; j3 < methodCount3; ++j3) {
                                Timestamp timestampVar3;
                                Date datevalue2;
                                java.util.Date dateVar2;
                                String strvalue2;
                                Float fvalue2;
                                Double dvalue2;
                                Long lngvalue2;
                                Integer intvalue2;
                                Class<?>[] clazz2;
                                if (!ms[j3].getName().equals(methodName) || (clazz2 = ms[j3].getParameterTypes()) != null && clazz2.length > 1 || !this.isParameterTypes(paraTypeName = ms[j3].getReturnType().getName())) continue;
                                if (paraTypeName.equals("int") || paraTypeName.equals("Integer") ? (intvalue2 = (Integer)ms[j3].invoke(dataObject, new Object[0])) == -9 : (paraTypeName.equals("long") || paraTypeName.equals("Long") ? (lngvalue2 = (Long)ms[j3].invoke(dataObject, new Object[0])) == -9L : (paraTypeName.equals("double") || paraTypeName.equals("Double") ? (dvalue2 = (Double)ms[j3].invoke(dataObject, new Object[0])) == -9.0 : (paraTypeName.equals("float") || paraTypeName.equals("Float") ? (fvalue2 = (Float)ms[j3].invoke(dataObject, new Object[0])).floatValue() == -9.0f : (paraTypeName.equals("java.lang.String") ? (strvalue2 = (String)ms[j3].invoke(dataObject, new Object[0])) == null : (paraTypeName.equals("java.util.Date") ? (dateVar2 = (java.util.Date)ms[j3].invoke(dataObject, new Object[0])) == null : (paraTypeName.equals("java.sql.Date") ? (datevalue2 = (Date)ms[j3].invoke(dataObject, new Object[0])) == null : paraTypeName.equals("java.sql.Timestamp") && (timestampVar3 = (Timestamp)ms[j3].invoke(dataObject, new Object[0])) == null))))))) continue block30;
                                this.getUpdateSql(sbUpdateSql, columnName + "=?");
                            }
                        }
                        if (sbUpdateSql != null && sbUpdateSql.length() > 0) {
                            String updateSql = sbUpdateSql.toString();
                            updateSql = updateSql.substring(0, updateSql.length() - 1);
                            String sql = "UPDATE " + tableName + " SET " + updateSql + " WHERE ID=?";
                            pstmt = conn.prepareStatement(sql);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("\u4fdd\u5b58\u5bf9\u8c61\u5230\u6570\u636e\u5e93-\u8d4b\u503cSQL: [" + sql + "]");
                            }
                            int columnIndex = 1;
                            ArrayList<Object> lstLogParam = new ArrayList<Object>();
                            int columnCount2 = rsmd.getColumnCount();
                            block32: for (int i3 = 0; i3 < columnCount2; ++i3) {
                                columnName = rsmd.getColumnName(i3 + 1).toLowerCase();
                                methodName = this.formatColumnName("get", columnName);
                                methodCount = ms.length;
                                for (j = 0; j < methodCount; ++j) {
                                    if (!ms[j].getName().equals(methodName) || (clazz = ms[j].getParameterTypes()) != null && clazz.length > 1 || !this.isParameterTypes(paraTypeName = ms[j].getReturnType().getName())) continue;
                                    if (paraTypeName.equals("int") || paraTypeName.equals("Integer")) {
                                        intvalue = (Integer)ms[j].invoke(dataObject, new Object[0]);
                                        if (intvalue == -9) continue block32;
                                        int value = intvalue;
                                        pstmt.setInt(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Integer(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("long") || paraTypeName.equals("Long")) {
                                        lngvalue = (Long)ms[j].invoke(dataObject, new Object[0]);
                                        if (lngvalue == -9L) continue block32;
                                        long value = lngvalue.intValue();
                                        pstmt.setLong(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Long(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("double") || paraTypeName.equals("Double")) {
                                        dvalue = (Double)ms[j].invoke(dataObject, new Object[0]);
                                        if (dvalue == -9.0) continue block32;
                                        double value = dvalue;
                                        pstmt.setDouble(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Double(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("float") || paraTypeName.equals("Float")) {
                                        fvalue = (Float)ms[j].invoke(dataObject, new Object[0]);
                                        if (fvalue.floatValue() == -9.0f) continue block32;
                                        float value = fvalue.floatValue();
                                        pstmt.setFloat(columnIndex, value);
                                        ++columnIndex;
                                        lstLogParam.add(new Float(value));
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.lang.String")) {
                                        strvalue = (String)ms[j].invoke(dataObject, new Object[0]);
                                        if (strvalue == null) continue block32;
                                        pstmt.setString(columnIndex, strvalue);
                                        ++columnIndex;
                                        lstLogParam.add(strvalue);
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.util.Date")) {
                                        dateVar = (java.util.Date)ms[j].invoke(dataObject, new Object[0]);
                                        Timestamp timestampVar4 = null;
                                        if (dateVar == null) continue block32;
                                        timestampVar4 = new Timestamp(dateVar.getTime());
                                        pstmt.setTimestamp(columnIndex, timestampVar4);
                                        ++columnIndex;
                                        lstLogParam.add(timestampVar4);
                                        continue;
                                    }
                                    if (paraTypeName.equals("java.sql.Date")) {
                                        datevalue = (Date)ms[j].invoke(dataObject, new Object[0]);
                                        if (datevalue == null) continue block32;
                                        pstmt.setDate(columnIndex, datevalue);
                                        ++columnIndex;
                                        lstLogParam.add(datevalue);
                                        continue;
                                    }
                                    if (!paraTypeName.equals("java.sql.Timestamp")) continue;
                                    timestampVar = (Timestamp)ms[j].invoke(dataObject, new Object[0]);
                                    if (timestampVar == null) continue block32;
                                    pstmt.setTimestamp(columnIndex, timestampVar);
                                    ++columnIndex;
                                    lstLogParam.add(timestampVar);
                                }
                            }
                            pstmt.setString(columnIndex, primaryId);
                            int rowNum = pstmt.executeUpdate();
                            Object2Database.releaseDbResource(null, pstmt, null);
                            isOk = rowNum == 1;
                            lstLogTotalParam.add(lstLogParam);
                            logMap.put(sql, lstLogTotalParam);
                        }
                        sbUpdateSql.delete(0, sbUpdateSql.length());
                    }
                    Object2Database.releaseDbResource(null, pstmt1, rs);
                }
            }
            if (isOk) {
                conn.commit();
            }
        }
        catch (NoSuchMethodException nsme) {
            isOk = Boolean.FALSE;
            this.rollback(conn);
            LOGGER.error(nsme.getMessage());
            nsme.printStackTrace();
        }
        catch (SQLException sqlEx) {
            isOk = Boolean.FALSE;
            this.rollback(conn);
            LOGGER.error(sqlEx.getMessage());
            sqlEx.printStackTrace();
        }
        catch (Exception ex) {
            isOk = Boolean.FALSE;
            this.rollback(conn);
            LOGGER.error(ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.setAutoCommit(oldAutoCommit);
                }
                catch (SQLException sqlEx) {
                    LOGGER.error(sqlEx.getMessage());
                    sqlEx.printStackTrace();
                }
                catch (Exception ex) {
                    LOGGER.error(ex.getMessage());
                    ex.printStackTrace();
                }
            }
            Object2Database.releaseDbResource(null, pstmt1, rs);
            Object2Database.releaseDbResource(conn, pstmt);
        }
        return isOk;
    }

    private void rollback(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException sqlEx) {
                LOGGER.error(sqlEx.getMessage());
                sqlEx.printStackTrace();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private boolean isParameterTypes(String parameterType) {
        return allowedDataType.containsKey(parameterType);
    }

    private void getUpdateSql(StringBuffer sbSql, String para) {
        sbSql.append(para).append(",");
    }

    private void getAddSql(StringBuffer sbSql, StringBuffer sbParamSql, String para) {
        sbSql.append(para).append(",");
        sbParamSql.append("?,");
    }

    private String formatColumnName(String prefixMethodName, String columnName) {
        StringBuffer sb = new StringBuffer(prefixMethodName);
        for (String str : columnName.split("_")) {
            String tmp = str.substring(0, 1).toUpperCase();
            str = str.substring(1);
            sb.append(tmp).append(str);
        }
        return sb.toString();
    }

    static {
        allowedDataType.put("int", allowedDataType);
        allowedDataType.put("long", allowedDataType);
        allowedDataType.put("double", allowedDataType);
        allowedDataType.put("float", allowedDataType);
        allowedDataType.put("Integer", allowedDataType);
        allowedDataType.put("java.lang.Integer", allowedDataType);
        allowedDataType.put("java.lang.String", allowedDataType);
        allowedDataType.put("java.util.Date", allowedDataType);
        allowedDataType.put("java.sql.Date", allowedDataType);
        allowedDataType.put("java.sql.Timestamp", allowedDataType);
    }
}

