/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.access.def;

import com.horizon.db.access.IExeUpdateForQuery;
import com.horizon.db.access.def.ExeBase;
import com.horizon.db.xlob.XlobProcessor;
import com.horizon.exception.HorizonException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExeUpdateForQuery
extends ExeBase
implements IExeUpdateForQuery {
    private static Logger logger = LoggerFactory.getLogger(ExeUpdateForQuery.class);

    @Override
    public boolean executeMultiUpdateForQuery(String dbIdentifier, LinkedHashMap mapSqlParameters, Connection conn, boolean autoComm) {
        boolean flag = false;
        String sql2 = null;
        List lstParameters = null;
        PreparedStatement pstmt = null;
        try {
            conn.setAutoCommit(false);
            for (String sql2 : mapSqlParameters.keySet()) {
                List rowsParameters = (List)mapSqlParameters.get(sql2);
                sql2 = this.parseHzSql(dbIdentifier, sql2);
                pstmt = conn.prepareStatement(sql2);
                if (rowsParameters != null && !rowsParameters.isEmpty()) {
                    Object obj = rowsParameters.get(0);
                    if (obj instanceof List) {
                        int len = rowsParameters.size();
                        for (int i = 0; i < len; ++i) {
                            lstParameters = (List)rowsParameters.get(i);
                            boolean isSameNumber = this.checkQuestionNumber(sql2, lstParameters);
                            if (!isSameNumber) {
                                throw new SQLException("Not compared SQL and parameter's number.\rParameter number: " + lstParameters.size() + ", SQL: " + sql2);
                            }
                            this.setParameters(pstmt, lstParameters);
                            pstmt.addBatch();
                        }
                    } else {
                        this.setParameters(pstmt, rowsParameters);
                        pstmt.addBatch();
                    }
                } else {
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                ExeUpdateForQuery.releaseDbResource(null, pstmt);
            }
            conn.commit();
            flag = true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            ex.printStackTrace();
            String msg = this.getErrorMessage(sql2, lstParameters, mapSqlParameters, dbIdentifier);
            logger.error(msg);
            throw new HorizonException(msg, ex);
        }
        finally {
            if (conn != null) {
                if (!flag) {
                    this.rollback(conn);
                }
                try {
                    conn.setAutoCommit(autoComm);
                }
                catch (SQLException e) {
                    logger.error("\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u7684\u81ea\u52a8\u63d0\u4ea4\u72b6\u6001\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
                ExeUpdateForQuery.releaseDbResource(conn, pstmt);
            }
        }
        return flag;
    }

    @Override
    public boolean executeUpdateForQuery(String dbIdentifier, LinkedHashMap mapSqlParameters, Connection conn, boolean autoComm) {
        boolean flag = false;
        String sql2 = null;
        List lstParameters = null;
        try {
            conn.setAutoCommit(false);
            for (String sql2 : mapSqlParameters.keySet()) {
                lstParameters = (List)mapSqlParameters.get(sql2);
                flag = this.update(conn, sql2 = this.parseHzSql(dbIdentifier, sql2), lstParameters);
                if (flag) continue;
            }
            if (flag) {
                conn.commit();
            }
        }
        catch (Exception ex) {
            flag = false;
            logger.error(ex.getMessage());
            ex.printStackTrace();
            String msg = this.getErrorMessage(sql2, lstParameters);
            logger.error(msg);
            throw new HorizonException(msg, ex);
        }
        finally {
            if (conn != null) {
                if (!flag) {
                    this.rollback(conn);
                }
                try {
                    conn.setAutoCommit(autoComm);
                }
                catch (SQLException e) {
                    logger.error("\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u7684\u81ea\u52a8\u63d0\u4ea4\u72b6\u6001\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
                ExeUpdateForQuery.releaseDbResource(conn);
            }
        }
        return flag;
    }

    private boolean update(Connection conn, String sql, List lstParameters) throws SQLException {
        boolean isSameNumber = this.checkQuestionNumber(sql, lstParameters);
        if (!isSameNumber) {
            logger.debug(" SQL: Not compared SQL and parameters's number.");
        }
        boolean flag = false;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            this.setParameters(pstmt, lstParameters);
            pstmt.executeUpdate();
            flag = true;
        }
        catch (SQLException ex) {
            logger.error(ex.getMessage());
            ex.printStackTrace();
            String msg = this.getErrorMessage(sql, lstParameters);
            logger.error(msg);
            throw new HorizonException(msg, ex);
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBlob(String dbIdentifier, String tableName, String columnName, InputStream inputStream, String idValue, Connection conn, boolean autoComm) {
        boolean flag = false;
        try {
            conn.setAutoCommit(false);
            XlobProcessor xlobPro = ExeUpdateForQuery.getLobProcessorClass(dbIdentifier);
            flag = xlobPro.updateBlob(conn, tableName, columnName, inputStream, idValue);
            if (flag) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                if (!flag) {
                    this.rollback(conn);
                }
                try {
                    conn.setAutoCommit(autoComm);
                }
                catch (SQLException e) {
                    logger.error("\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u7684\u81ea\u52a8\u63d0\u4ea4\u72b6\u6001\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
                ExeUpdateForQuery.releaseDbResource(conn);
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateClob(String dbIdentifier, String tableName, String columnName, List lstParameters, Connection conn, boolean autoComm) {
        boolean flag = false;
        try {
            conn.setAutoCommit(false);
            XlobProcessor xlobPro = ExeUpdateForQuery.getLobProcessorClass(dbIdentifier);
            flag = xlobPro.updateClob(conn, tableName, columnName, lstParameters);
            if (flag) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                if (!flag) {
                    this.rollback(conn);
                }
                try {
                    conn.setAutoCommit(autoComm);
                }
                catch (SQLException e) {
                    logger.error("\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u7684\u81ea\u52a8\u63d0\u4ea4\u72b6\u6001\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.getMessage());
                }
                ExeUpdateForQuery.releaseDbResource(conn);
            }
        }
        return flag;
    }

    private void rollback(Connection conn) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException sqlEx) {
                logger.error(sqlEx.getMessage());
                sqlEx.printStackTrace();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void putLoggedSqlMapBySqlAndParameters(String sql, List lstParameters) {
        LinkedHashMap<String, List> mapSqlParameters = new LinkedHashMap<String, List>(1);
        mapSqlParameters.put(sql, lstParameters);
    }

    private String getErrorMessage(String sql, List lstParameters) {
        String errorMessage = this.getErrorMessage(sql, lstParameters, null, null);
        return errorMessage;
    }

    private String getErrorMessage(String sql2, List lstParameters, LinkedHashMap mapSqlParameters, String dbIdentifier) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u6267\u884cSQL\u8bed\u53e5\u65f6\u53d1\u751f\u5f02\u5e38 [Occured exception when execute the sql]");
        String enter = "\n\r";
        if (sql2 != null) {
            sb.append(enter).append("   SQL\u8bed\u53e5: ").append(sql2);
        }
        if (lstParameters != null && lstParameters.size() > 0) {
            sb.append(enter).append("   SQL\u53c2\u6570:");
            this.zuheSqlParameter(sb, lstParameters);
        }
        if (mapSqlParameters == null) {
            String msg = sb.toString();
            return msg;
        }
        sb.append(enter).append("\u4ee5\u4e0a\u662f\u6700\u540e\u6267\u884c\u7684SQL\u53caSQL\u53c2\u6570\uff1b\u4ee5\u4e0b\u662f\u5168\u90e8\u7684SQL\u53caSQL\u53c2\u6570:");
        sb.append(enter).append("----- SQL & Parmeters -----[START]");
        int sqlIndex = 1;
        for (String sql2 : mapSqlParameters.keySet()) {
            List rowsParameters = (List)mapSqlParameters.get(sql2);
            sb.append(enter).append(sqlIndex).append(". SQL\u8bed\u53e5: ").append(sql2);
            ++sqlIndex;
            if (rowsParameters != null && !rowsParameters.isEmpty()) {
                Object obj = rowsParameters.get(0);
                if (obj instanceof List) {
                    int len = rowsParameters.size();
                    for (int i = 0; i < len; ++i) {
                        sb.append(enter).append("    (").append(i + 1).append(") SQL\u53c2\u6570:");
                        lstParameters = (List)rowsParameters.get(i);
                        this.zuheSqlParameter(sb, lstParameters);
                    }
                    continue;
                }
                sb.append(enter).append("    (1) SQL\u53c2\u6570:");
                this.zuheSqlParameter(sb, rowsParameters);
                continue;
            }
            sb.append(enter).append("    \u6ca1\u6709SQL\u53c2\u6570\u3002");
        }
        sb.append(enter).append("----- SQL & Parmeters -----[ END ]");
        String msg = sb.toString();
        return msg;
    }

    private void zuheSqlParameter(StringBuffer stringBuffer, List lstParameters) {
        if (lstParameters == null || lstParameters.isEmpty()) {
            stringBuffer.append("\u6ca1\u6709SQL\u53c2\u6570\u3002");
            return;
        }
        String splitor = " , ";
        stringBuffer.append(" { ").append(lstParameters.get(0));
        int len = lstParameters.size();
        for (int i = 1; i < len; ++i) {
            stringBuffer.append(splitor).append(lstParameters.get(i));
        }
        stringBuffer.append(" }");
    }
}

